/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.auth.notebook;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.JupyterLoginException;
import com.intellij.jupyter.core.jupyter.connections.auth.notebook.JupyterNoteAuthUtils;
import com.intellij.jupyter.core.jupyter.connections.http.HttpSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.UriUtilKt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0080@\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0011\u0010\u0018\u001a\u00020\u000b*\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u00020\u001b*\u0006\u0012\u0002\b\u00030\u001c8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/auth/notebook/JupyterNoteAuthUtils;", "", "<init>", "()V", "LOGIN_FORM_URI_PATH", "", "XSRF_COOKIE_NAME", "LOGIN_ATTEMPTS", "", "LOGIN_FORM_PASSWORD_FIELD_NAME", "uriOfUnmanagedNotebookServer", "Ljava/net/URI;", "location", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters$Location;", "uriOfUnmanagedNotebookServer$intellij_jupyter_core", "logInToJupyterServer", "", "redirectingSession", "Lcom/intellij/jupyter/core/jupyter/connections/http/HttpSession;", "baseURI", "passwordOrToken", "Lcom/intellij/credentialStore/OneTimeString;", "logInToJupyterServer$intellij_jupyter_core", "(Lcom/intellij/jupyter/core/jupyter/connections/http/HttpSession;Ljava/net/URI;Lcom/intellij/credentialStore/OneTimeString;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeTokenFromQuery", "removeTokenFromQuery$intellij_jupyter_core", "isForbiddenOrNotAuthorized", "", "Lcom/intellij/jupyter/core/jupyter/connections/http/HttpSession$Response;", "isForbiddenOrNotAuthorized$intellij_jupyter_core", "(Lcom/intellij/jupyter/core/jupyter/connections/http/HttpSession$Response;)Z", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterNoteAuthUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNoteAuthUtils.kt\ncom/intellij/jupyter/core/jupyter/connections/auth/notebook/JupyterNoteAuthUtils\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n24#2:98\n774#3:99\n865#3,2:100\n1#4:102\n*S KotlinDebug\n*F\n+ 1 JupyterNoteAuthUtils.kt\ncom/intellij/jupyter/core/jupyter/connections/auth/notebook/JupyterNoteAuthUtils\n*L\n29#1:98\n92#1:99\n92#1:100,2\n*E\n"})
public final class JupyterNoteAuthUtils {
    @NotNull
    public static final JupyterNoteAuthUtils INSTANCE = new JupyterNoteAuthUtils();
    @NotNull
    public static final String LOGIN_FORM_URI_PATH = "/login";
    @NotNull
    public static final String XSRF_COOKIE_NAME = "_xsrf";
    public static final int LOGIN_ATTEMPTS = 3;
    @NotNull
    private static final String LOGIN_FORM_PASSWORD_FIELD_NAME = "password";

    private JupyterNoteAuthUtils() {
    }

    @NotNull
    public final URI uriOfUnmanagedNotebookServer$intellij_jupyter_core(@NotNull JupyterConnectionParameters.Location location) {
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        JupyterConnectionParameters.Location location2 = location;
        if (location2 instanceof JupyterConnectionParameters.Location.Direct) {
            uRI = ((JupyterConnectionParameters.Location.Direct)location).getUri();
        } else if (location2 instanceof JupyterConnectionParameters.Location.Tunneled) {
            JupyterNoteAuthUtils $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterNoteAuthUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unexpected location for non-managed Jupyter Notebook server: " + location);
            uRI = ((JupyterConnectionParameters.Location.Tunneled)location).getUri();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return uRI;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object logInToJupyterServer$intellij_jupyter_core(@NotNull HttpSession var1_1, @NotNull URI var2_2, @NotNull OneTimeString var3_3, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof logInToJupyterServer.1)) ** GOTO lbl-1000
        var15_5 = $completion;
        if ((var15_5.label & -2147483648) != 0) {
            var15_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ JupyterNoteAuthUtils this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.logInToJupyterServer$intellij_jupyter_core(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var6_8 = baseURI.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)var6_8, (String)"getPath(...)");
                loginUri = UriUtilKt.withPath((URI)baseURI, (String)(StringsKt.removeSuffix((String)var6_8, (CharSequence)"/") + "/login"));
                $continuation.L$0 = redirectingSession;
                $continuation.L$1 = passwordOrToken;
                $continuation.L$2 = loginUri;
                $continuation.label = 1;
                v0 = redirectingSession.executeAsync(new HttpSession.Request(HttpSession.Method.GET, loginUri, null, null, null, null, 60, null), (Continuation<? super Pair<HttpSession.Request, HttpSession.Response<InputStream>>>)$continuation);
                if (v0 == var16_7) {
                    return var16_7;
                }
                ** GOTO lbl29
            }
            case 1: {
                loginUri = (URI)$continuation.L$2;
                passwordOrToken = (OneTimeString)$continuation.L$1;
                redirectingSession = (HttpSession)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                getResponse = (HttpSession.Response)((Pair)v0).component2();
                switch (getResponse.getStatusCode()) {
                    case 200: 
                    case 302: {
                        break;
                    }
                    default: {
                        var9_11 = loginUri.toASCIIString();
                        Intrinsics.checkNotNullExpressionValue((Object)var9_11, (String)"toASCIIString(...)");
                        throw new JupyterLoginException(var9_11, false);
                    }
                }
                $this$logInToJupyterServer_u24lambda_u241 = new StringBuilder();
                $i$a$-run-JupyterNoteAuthUtils$logInToJupyterServer$body$1 = false;
                $this$logInToJupyterServer_u24lambda_u241.append("password");
                $this$logInToJupyterServer_u24lambda_u241.append("=");
                $this$logInToJupyterServer_u24lambda_u241.append(URLEncoder.encode(passwordOrToken.toString(true), StandardCharsets.UTF_8.name()));
                v1 = redirectingSession.getXsrfToken();
                if (v1 != null) {
                    it = v1;
                    $i$a$-let-JupyterNoteAuthUtils$logInToJupyterServer$body$1$1 = false;
                    $this$logInToJupyterServer_u24lambda_u241.append("&");
                    $this$logInToJupyterServer_u24lambda_u241.append("_xsrf");
                    $this$logInToJupyterServer_u24lambda_u241.append("=");
                    $this$logInToJupyterServer_u24lambda_u241.append(URLEncoder.encode(it, StandardCharsets.UTF_8.name()));
                }
                v2 = $this$logInToJupyterServer_u24lambda_u241.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toString(...)");
                v3 = v2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getBytes(...)");
                body = new ByteArrayInputStream(v3);
                loginRequest = new HttpSession.Request(HttpSession.Method.POST, loginUri, CollectionsKt.listOf((Object)TuplesKt.to((Object)"Content-Type", (Object)ContentType.APPLICATION_FORM_URLENCODED.getMimeType())), body, null, null, 48, null);
                $continuation.L$0 = loginUri;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v4 = redirectingSession.executeAsync(loginRequest, (Continuation<? super Pair<HttpSession.Request, HttpSession.Response<InputStream>>>)$continuation);
                if (v4 == var16_7) {
                    return var16_7;
                }
                ** GOTO lbl76
            }
            case 2: {
                loginUri = (URI)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl76:
                // 2 sources

                response = (HttpSession.Response)((Pair)v4).component2();
                switch (response.getStatusCode()) {
                    case 200: 
                    case 302: {
                        break;
                    }
                    case 401: 
                    case 403: {
                        v5 = loginUri.toASCIIString();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"toASCIIString(...)");
                        throw new JupyterLoginException(v5, false);
                    }
                    default: {
                        v6 = loginUri.toASCIIString();
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"toASCIIString(...)");
                        throw new JupyterLoginException(v6, false);
                    }
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final URI removeTokenFromQuery$intellij_jupyter_core(@NotNull URI $this$removeTokenFromQuery) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String string;
        char[] cArray;
        Intrinsics.checkNotNullParameter((Object)$this$removeTokenFromQuery, (String)"<this>");
        URIBuilder uRIBuilder = new URIBuilder($this$removeTokenFromQuery);
        String string2 = $this$removeTokenFromQuery.getQuery();
        if (string2 != null) {
            cArray = new char[]{'?'};
            string = StringsKt.trimStart((String)string2, (char[])cArray);
        } else {
            string = null;
        }
        List list = URLEncodedUtils.parse(string, null);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
        Iterable iterable = list;
        URIBuilder uRIBuilder2 = uRIBuilder;
        boolean $i$f$filter = false;
        cArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NameValuePair it = (NameValuePair)element$iv$iv;
            boolean bl = false;
            String string3 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            String string4 = string3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            if (!(!Intrinsics.areEqual((Object)string4, (Object)"token"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        URI uRI = uRIBuilder2.setParameters((List)destination$iv$iv).build();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"build(...)");
        return uRI;
    }

    public final boolean isForbiddenOrNotAuthorized$intellij_jupyter_core(@NotNull HttpSession.Response<?> $this$isForbiddenOrNotAuthorized) {
        Intrinsics.checkNotNullParameter($this$isForbiddenOrNotAuthorized, (String)"<this>");
        int it = $this$isForbiddenOrNotAuthorized.getStatusCode();
        boolean bl = false;
        return it == 403 || it == 401;
    }
}

