/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.execution;

import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterExecutionException;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterWebSocketClient;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterWebSocketClientClosedException;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterWebSocketClientKt;
import com.intellij.jupyter.core.jupyter.connections.execution.message.BytesWebSocketMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessageBase;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterProtocolSchema;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterProtocolSchemaFactory;
import com.intellij.jupyter.core.jupyter.connections.execution.message.StringWebSocketMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.WebSocketMessage;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterHttpSessionRestUtilsKt;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterSSLWrapper;
import com.intellij.jupyter.core.jupyter.execution.JupyterRunningNotebookTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlinx.coroutines.CancellableContinuation;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0014\u0010\u0013\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\b\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\bH\u0016J\u0012\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\"\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\t\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\bH\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\t\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\"H\u0016J\u0014\u0010#\u001a\u00020\f2\n\u0010$\u001a\u00060%j\u0002`&H\u0016J\b\u0010'\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/execution/Delegate;", "Lorg/java_websocket/client/WebSocketClient;", "traceId", "", "uri", "Ljava/net/URI;", "headers", "", "", "onMessage", "Lkotlin/Function1;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "", "<init>", "(JLjava/net/URI;Ljava/util/Map;Lkotlin/jvm/functions/Function1;)V", "continuation", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlinx/coroutines/CancellableContinuation;", "", "connect", "run", "toString", "onOpen", "handshakedata", "Lorg/java_websocket/handshake/ServerHandshake;", "onClose", "code", "reason", "remote", "", "message", "processMessage", "content", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/WebSocketMessage;", "Ljava/nio/ByteBuffer;", "onError", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "close", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterWebSocketClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterWebSocketClient.kt\ncom/intellij/jupyter/core/jupyter/connections/execution/Delegate\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,197:1\n61#2,5:198\n68#2,4:203\n68#2,4:207\n61#2,5:211\n*S KotlinDebug\n*F\n+ 1 JupyterWebSocketClient.kt\ncom/intellij/jupyter/core/jupyter/connections/execution/Delegate\n*L\n144#1:198,5\n161#1:203,4\n182#1:207,4\n192#1:211,5\n*E\n"})
final class Delegate
extends WebSocketClient {
    private final long traceId;
    @NotNull
    private final Function1<JupyterMessage, Unit> onMessage;
    @NotNull
    private final AtomicReference<CancellableContinuation<Integer>> continuation;

    public Delegate(long traceId, @NotNull URI uri, @NotNull Map<String, String> headers, @NotNull Function1<? super JupyterMessage, Unit> onMessage) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter(onMessage, (String)"onMessage");
        super(uri, headers);
        this.traceId = traceId;
        this.onMessage = onMessage;
        this.continuation = new AtomicReference<Object>(null);
    }

    public final void connect(@NotNull CancellableContinuation<? super Integer> continuation) {
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        this.continuation.set(continuation);
        if (Intrinsics.areEqual((Object)this.uri.getScheme(), (Object)"wss")) {
            JupyterSSLWrapper jupyterSSLWrapper = JupyterSSLWrapper.Companion.getInstance();
            String string = this.uri.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
            this.setSocketFactory(jupyterSSLWrapper.sslSocketFactory(string));
        }
        this.connect();
    }

    @Override
    public void run() {
        AppExecutorUtil.getAppScheduledExecutorService().schedule(JupyterRunningNotebookTracker.Companion.getInstance()::refresh, 2L, TimeUnit.SECONDS);
        super.run();
    }

    @NotNull
    public String toString() {
        String string = JupyterWebSocketClient.class.getSimpleName();
        String string2 = this.getClass().getSimpleName();
        URI uRI = this.uri;
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"uri");
        return string + "$" + string2 + "(uri=" + JupyterHttpSessionRestUtilsKt.getObfuscated(uRI) + ")@" + System.identityHashCode(this);
    }

    @Override
    public void onOpen(@Nullable ServerHandshake handshakedata) {
        block1: {
            Logger $this$debug_u24default$iv = JupyterWebSocketClientKt.access$getLOG$p();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("#" + this.traceId + " Received onOpen() for " + this, e$iv);
            }
            CancellableContinuation cancellableContinuation = this.continuation.getAndSet(null);
            if (cancellableContinuation == null) break block1;
            cancellableContinuation.resumeWith(Result.constructor-impl((Object)101));
        }
    }

    @Override
    public void onClose(int code, @Nullable String reason, boolean remote) {
        block4: {
            Object object;
            JupyterWebSocketClientKt.access$getLOG$p().info("#" + this.traceId + " Received onClose(" + code + ", \"" + reason + "\", " + remote + ") for " + this);
            CancellableContinuation cancellableContinuation = this.continuation.getAndSet(null);
            if (cancellableContinuation == null) break block4;
            CancellableContinuation cancellableContinuation2 = cancellableContinuation;
            try {
                boolean bl = false;
                Regex regex = new Regex("Invalid status code received: (\\d+) Status line: .*");
                String string = reason;
                if (string == null) {
                    string = "";
                }
                MatchResult matchResult = regex.matchEntire((CharSequence)string);
                if (matchResult == null) {
                    throw new JupyterExecutionException(JupyterWebSocketClientKt.access$buildOnCloseMessage(code, reason, remote));
                }
                MatchResult match = matchResult;
                object = Result.constructor-impl((Object)Integer.parseInt((String)match.getGroupValues().get(1)));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            cancellableContinuation2.resumeWith(object);
        }
    }

    @Override
    public void onMessage(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        StringWebSocketMessage wsMessage = new StringWebSocketMessage(message2);
        Logger $this$trace$iv = JupyterWebSocketClientKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("#" + this.traceId + " Received from websocket " + this.uri + ": " + wsMessage);
        }
        this.processMessage(wsMessage);
    }

    private final void processMessage(WebSocketMessage content) {
        try {
            JupyterProtocolSchema protocolSchema = JupyterProtocolSchemaFactory.createSchema$default(JupyterProtocolSchemaFactory.INSTANCE, null, 1, null);
            JupyterMessage message2 = JupyterMessageBase.Companion.parse(content, protocolSchema);
            this.onMessage.invoke((Object)message2);
        }
        catch (Throwable e) {
            JupyterWebSocketClientKt.access$getLOG$p().error("#" + this.traceId + " An error happened during processing a message", e);
            throw e;
        }
    }

    @Override
    public void onMessage(@NotNull ByteBuffer message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        BytesWebSocketMessage wsMessage = new BytesWebSocketMessage(message2);
        Logger $this$trace$iv = JupyterWebSocketClientKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("#" + this.traceId + " Received from websocket " + this.uri + ": " + wsMessage);
        }
        this.processMessage(wsMessage);
    }

    @Override
    public void onError(@NotNull Exception exception) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            JupyterWebSocketClientKt.access$getLOG$p().info("#" + this.traceId + " Received onError(" + exception + ") for " + this, (Throwable)exception);
            CancellableContinuation cancellableContinuation = this.continuation.getAndSet(null);
            if (cancellableContinuation == null) break block0;
            cancellableContinuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new JupyterWebSocketClientClosedException(exception.getMessage(), exception))));
        }
    }

    @Override
    public void close() {
        Logger $this$debug_u24default$iv = JupyterWebSocketClientKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("#" + this.traceId + " Close " + this, e$iv);
        }
        super.close();
    }
}

