/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.error;

import com.intellij.execution.filters.Filter;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.editor.outputs.error.JupyterErrorOutputFiltersProvider;
import com.intellij.jupyter.core.jupyter.editor.outputs.text.JupyterOutputConsoleView;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0014J\b\u0010\u0019\u001a\u00020\tH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/error/JupyterErrorOutputConsoleView;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/text/JupyterOutputConsoleView;", "project", "Lcom/intellij/openapi/project/Project;", "notebookLanguage", "Lcom/intellij/lang/Language;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/Language;)V", "exceptionType", "", "getExceptionType", "()Ljava/lang/String;", "setExceptionType", "(Ljava/lang/String;)V", "exceptionValue", "getExceptionValue", "setExceptionValue", "initializeMessageFilters", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "updateFoldings", "startLine", "", "endLine", "getFoldTitle", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterErrorOutputConsoleView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterErrorOutputConsoleView.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/error/JupyterErrorOutputConsoleView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1368#2:65\n1454#2,5:66\n1863#2,2:71\n*S KotlinDebug\n*F\n+ 1 JupyterErrorOutputConsoleView.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/error/JupyterErrorOutputConsoleView\n*L\n22#1:65\n22#1:66,5\n22#1:71,2\n*E\n"})
public final class JupyterErrorOutputConsoleView
extends JupyterOutputConsoleView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Language notebookLanguage;
    public String exceptionType;
    public String exceptionValue;

    public JupyterErrorOutputConsoleView(@NotNull Project project, @Nullable Language notebookLanguage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.notebookLanguage = notebookLanguage;
    }

    @NotNull
    public final String getExceptionType() {
        String string = this.exceptionType;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"exceptionType");
        return null;
    }

    public final void setExceptionType(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.exceptionType = string;
    }

    @NotNull
    public final String getExceptionValue() {
        String string = this.exceptionValue;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"exceptionValue");
        return null;
    }

    public final void setExceptionValue(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.exceptionValue = string;
    }

    /*
     * WARNING - void declaration
     */
    public final void initializeMessageFilters(@NotNull EditorImpl editor) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.clearMessageFilters();
        Iterable $this$flatMap$iv = JupyterErrorOutputFiltersProvider.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JupyterErrorOutputFiltersProvider it = (JupyterErrorOutputFiltersProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFilters(editor, this.getExceptionType(), this.getExceptionValue());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Filter it = (Filter)element$iv;
            boolean bl = false;
            if (it instanceof Disposable) {
                Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)it));
            }
            this.addMessageFilter(it);
        }
    }

    protected void updateFoldings(int startLine, int endLine) {
        block0: {
            super.updateFoldings(startLine, endLine);
            String title = this.getFoldTitle();
            Regex regex = new Regex("\\n\\h*" + Regex.Companion.escape(this.getExceptionType()) + ":");
            MatchResult matchResult = (MatchResult)SequencesKt.lastOrNull((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)this.getText(), (int)0, (int)2, null));
            if (matchResult == null) break block0;
            MatchResult match = matchResult;
            boolean bl = false;
            Editor editor = this.getEditor();
            Intrinsics.checkNotNull((Object)editor);
            FoldingModel $this$updateFoldings_u24lambda_u245_u24lambda_u244 = editor.getFoldingModel();
            boolean bl2 = false;
            $this$updateFoldings_u24lambda_u245_u24lambda_u244.runBatchFoldingOperation(() -> JupyterErrorOutputConsoleView.updateFoldings$lambda$5$lambda$4$lambda$3($this$updateFoldings_u24lambda_u245_u24lambda_u244, match, title, endLine, startLine));
        }
    }

    private final String getFoldTitle() {
        Language language = this.notebookLanguage;
        return Intrinsics.areEqual((Object)(language != null ? language.getID() : null), (Object)"kotlin") ? JupyterBundle.message("notebook.error.output.traceback.kotlin.ellipsis", new Object[0]) : JupyterBundle.message("notebook.error.output.traceback.python.ellipsis", new Object[0]);
    }

    private static final void updateFoldings$lambda$5$lambda$4$lambda$3(FoldingModel $this_with, MatchResult $match, String $title, int $endLine, int $startLine) {
        block0: {
            FoldRegion foldRegion;
            FoldRegion foldRegion2 = $this_with.addFoldRegion(0, $match.getRange().getFirst(), $title);
            if (foldRegion2 == null) break block0;
            FoldRegion $this$updateFoldings_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u242 = foldRegion = foldRegion2;
            boolean bl = false;
            $this$updateFoldings_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u242.setExpanded($endLine - $startLine <= 15);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/error/JupyterErrorOutputConsoleView$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/error/JupyterErrorOutputConsoleView;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterErrorOutputConsoleView create(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Project project = editor.getProject();
            Intrinsics.checkNotNull((Object)project);
            Object object = JupyterEditorExtensionsKt.getNotebookFileOrNull(editor);
            return new JupyterErrorOutputConsoleView(project, object != null && (object = object.getNotebookOrNull()) != null ? object.getLanguage() : null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

