/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.providers.local;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.openapi.util.Key;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/providers/local/ScriptUriConverter;", "", "notebook", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "getNotebook", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "asWebviewUri", "", "resource", "Companion", "intellij.jupyter.core"})
public final class ScriptUriConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BackedNotebookVirtualFile notebook;
    @NotNull
    public static final String BASE_EXTENSION_PATH = "BASE_EXTENSION_PATH";
    @NotNull
    private static final Key<Path> BASE_EXTENSION_PATH_KEY = new Key("BASE_EXTENSION_PATH");

    public ScriptUriConverter(@NotNull BackedNotebookVirtualFile notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        this.notebook = notebook;
    }

    @NotNull
    public final BackedNotebookVirtualFile getNotebook() {
        return this.notebook;
    }

    @NotNull
    public final String asWebviewUri(@NotNull String resource) {
        String string;
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Path path = (Path)this.notebook.getFile().getUserData(BASE_EXTENSION_PATH_KEY);
        if (path == null) {
            return resource;
        }
        Path basePath = path;
        if (basePath.startsWith(basePath)) {
            String pathString;
            Path path2 = Paths.get(resource, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            Path resourcePath = path2;
            Path relativePath = basePath.relativize(resourcePath);
            Path path3 = Paths.get(BASE_EXTENSION_PATH, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            Path path4 = path3.resolve(relativePath);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            string = pathString = ((Object)path4).toString();
        } else {
            string = resource;
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/providers/local/ScriptUriConverter$Companion;", "", "<init>", "()V", "BASE_EXTENSION_PATH", "", "BASE_EXTENSION_PATH_KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/nio/file/Path;", "getBASE_EXTENSION_PATH_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Path> getBASE_EXTENSION_PATH_KEY() {
            return BASE_EXTENSION_PATH_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

