/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.helper;

import com.intellij.jupyter.core.jupyter.actions.ActionDestination;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellView;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.awt.Rectangle;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/core/jupyter/helper/JupyterActionHelper;", "", "<init>", "()V", "performSelectCell", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "direction", "Lcom/intellij/jupyter/core/jupyter/actions/ActionDestination;", "focusFirstOrLastCell", "getNextInterval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "currentInterval", "selectAndFocusOnInterval", "nextInterval", "adjustEditorViewportToFitCell", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "nextIntervalOrdinal", "", "adjustEditorViewToMakeCellVisible", "view", "Lcom/intellij/notebooks/visualization/ui/EditorCellView;", "intellij.jupyter.core"})
public final class JupyterActionHelper {
    @NotNull
    public static final JupyterActionHelper INSTANCE = new JupyterActionHelper();

    private JupyterActionHelper() {
    }

    public final void performSelectCell(@NotNull DataContext dataContext, @NotNull ActionDestination direction) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        NotebookCellLines.Interval interval = this.getNextInterval(dataContext, direction);
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval nextInterval = interval;
        this.selectAndFocusOnInterval(dataContext, nextInterval, direction);
    }

    public final void focusFirstOrLastCell(@NotNull DataContext dataContext, @NotNull ActionDestination direction) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        NotebookCellLines cellLines = NotebookCellLines.Companion.get((Editor)editor);
        NotebookCellLines.Interval interval = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> (NotebookCellLines.Interval)CollectionsKt.firstOrNull((List)cellLines.getIntervals());
            case 2 -> (NotebookCellLines.Interval)CollectionsKt.lastOrNull((List)cellLines.getIntervals());
            default -> throw new NoWhenBranchMatchedException();
        };
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval interval2 = interval;
        this.selectAndFocusOnInterval(dataContext, interval2, direction);
    }

    @Nullable
    public final NotebookCellLines.Interval getNextInterval(@NotNull DataContext dataContext, @NotNull ActionDestination direction) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        NotebookCellLines.Interval interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext);
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval currentInterval = interval;
        return this.getNextInterval(dataContext, currentInterval, direction);
    }

    @Nullable
    public final NotebookCellLines.Interval getNextInterval(@NotNull DataContext dataContext, @NotNull NotebookCellLines.Interval currentInterval, @NotNull ActionDestination direction) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)currentInterval, (String)"currentInterval");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return null;
        }
        EditorImpl editor = editorImpl;
        NotebookCellLines cellLines = NotebookCellLines.Companion.get((Editor)editor);
        int delta = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> -1;
            case 2 -> 1;
            default -> throw new NoWhenBranchMatchedException();
        };
        int nextIntervalOrdinal = currentInterval.getOrdinal() + delta;
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.getOrNull((List)cellLines.getIntervals(), (int)nextIntervalOrdinal);
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval nextInterval = interval;
        return nextInterval;
    }

    private final void selectAndFocusOnInterval(DataContext dataContext, NotebookCellLines.Interval nextInterval, ActionDestination direction) {
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)editor));
        if (notebookCellSelectionModel == null) {
            return;
        }
        NotebookCellSelectionModel selectionModel = notebookCellSelectionModel;
        selectionModel.selectSingleCell(nextInterval);
        this.adjustEditorViewportToFitCell(editor, nextInterval.getOrdinal(), direction);
    }

    private final void adjustEditorViewportToFitCell(EditorImpl editor, int nextIntervalOrdinal, ActionDestination direction) {
        NotebookCellInlayManager notebookCellInlayManager = NotebookCellInlayManager.Companion.get((Editor)editor);
        if (notebookCellInlayManager == null) {
            throw new IllegalStateException("Cell Inlays model is not available".toString());
        }
        NotebookCellInlayManager cellInlayManager = notebookCellInlayManager;
        EditorCell cell = cellInlayManager.getCell(nextIntervalOrdinal);
        EditorCellView editorCellView = cell.getView();
        if (editorCellView == null) {
            throw new IllegalStateException(("Cell " + nextIntervalOrdinal + " view is not available").toString());
        }
        EditorCellView cellView = editorCellView;
        this.adjustEditorViewToMakeCellVisible(editor, cellView, direction);
    }

    private final void adjustEditorViewToMakeCellVisible(EditorImpl editor, EditorCellView view, ActionDestination direction) {
        Rectangle cellBounds = view.calculateBounds();
        Rectangle viewRect = editor.getScrollPane().getViewport().getViewRect();
        Rectangle bounds = view.calculateBounds();
        if (viewRect.contains(cellBounds)) {
            return;
        }
        int newY = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> bounds.y;
            case 2 -> bounds.y - Math.max(0, viewRect.height - bounds.height);
            default -> throw new NoWhenBranchMatchedException();
        };
        editor.getScrollingModel().scroll(editor.getScrollingModel().getHorizontalScrollOffset(), newY);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ActionDestination.values().length];
            try {
                nArray[ActionDestination.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionDestination.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

