/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.helper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.helper.OtherKt;
import com.intellij.jupyter.core.jupyter.index.JupyterIndexRegistry;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCellBuilder;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookConverter;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookSchema;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookSchemaFactory;
import com.intellij.jupyter.core.jupyter.nbformat.schema.JupyterNotebookSchemaVersion;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.indexing.FileContent;
import java.io.IOException;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/core/jupyter/helper/JupyterFileUtils;", "", "<init>", "()V", "readNotebookOrNull", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "text", "", "fileName", "", "readNotebook", "createEmptyNotebook", "schemaVersion", "Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookSchemaVersion;", "restoreJupyterNotebookFromSource", "virtualFile", "getOriginalFile", "getSourceForIndex", "inputData", "Lcom/intellij/util/indexing/FileContent;", "initFromJson", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterFileUtils.kt\ncom/intellij/jupyter/core/jupyter/helper/JupyterFileUtils\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,178:1\n24#2:179\n24#2:180\n24#2:181\n*S KotlinDebug\n*F\n+ 1 JupyterFileUtils.kt\ncom/intellij/jupyter/core/jupyter/helper/JupyterFileUtils\n*L\n33#1:179\n35#1:180\n45#1:181\n*E\n"})
public final class JupyterFileUtils {
    @NotNull
    public static final JupyterFileUtils INSTANCE = new JupyterFileUtils();

    private JupyterFileUtils() {
    }

    @Nullable
    public final JupyterNotebookBase readNotebookOrNull(@NotNull VirtualFile file) {
        JupyterNotebookBase jupyterNotebookBase;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            jupyterNotebookBase = this.readNotebook(file);
        }
        catch (Throwable t) {
            if (ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode()) {
                JupyterFileUtils $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(JupyterFileUtils.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Cannot read file " + file.getPath(), t);
            } else {
                JupyterFileUtils $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(JupyterFileUtils.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Cannot read file " + file.getPath(), t);
            }
            jupyterNotebookBase = null;
        }
        return jupyterNotebookBase;
    }

    @Nullable
    public final JupyterNotebookBase readNotebookOrNull(@NotNull CharSequence text, @NotNull String fileName) {
        JupyterNotebookBase jupyterNotebookBase;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        try {
            jupyterNotebookBase = this.readNotebook(text);
        }
        catch (Throwable t) {
            JupyterFileUtils $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterFileUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Cannot read file " + fileName, t);
            jupyterNotebookBase = null;
        }
        return jupyterNotebookBase;
    }

    public static /* synthetic */ JupyterNotebookBase readNotebookOrNull$default(JupyterFileUtils jupyterFileUtils, CharSequence charSequence, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "unknown";
        }
        return jupyterFileUtils.readNotebookOrNull(charSequence, string);
    }

    @NotNull
    public final JupyterNotebookBase readNotebook(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        long fileSize = file.getLength();
        if (fileSize == 0L) {
            JupyterNotebookBase notebookBase = JupyterFileUtils.createEmptyNotebook$default(this, null, 1, null);
            notebookBase.addCell((Function1<? super JupyterCellBuilder, Unit>)((Function1)JupyterFileUtils::readNotebook$lambda$0));
            return notebookBase;
        }
        byte[] cachedBytes = file.getInputStream().readNBytes(FileUtilRt.LARGE_FOR_CONTENT_LOADING);
        CharSequence charSequence = LoadTextUtil.getTextByBinaryPresentation((byte[])cachedBytes, (VirtualFile)file, (boolean)true, (boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getTextByBinaryPresentation(...)");
        CharSequence text = charSequence;
        try {
            ObjectNode objectNode;
            if (fileSize < (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
                JsonNode jsonNode = JupyterJsonKt.getJackson().readTree(((Object)text).toString());
                Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                objectNode = (ObjectNode)jsonNode;
            } else {
                JsonNode jsonNode = JupyterJsonKt.getJackson().readTree(file.getInputStream());
                Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                objectNode = (ObjectNode)jsonNode;
            }
            ObjectNode json = objectNode;
            JupyterNotebookBase notebook = this.initFromJson(json);
            return notebook;
        }
        catch (Throwable t) {
            throw new IOException("Cannot read file " + file.getPath(), t);
        }
    }

    @NotNull
    public final JupyterNotebookBase readNotebook(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        JsonNode jsonNode = JupyterJsonKt.getJackson().readTree(((Object)text).toString());
        Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        ObjectNode json = (ObjectNode)jsonNode;
        JupyterNotebookBase notebook = this.initFromJson(json);
        return notebook;
    }

    @NotNull
    public final JupyterNotebookBase createEmptyNotebook(@NotNull JupyterNotebookSchemaVersion schemaVersion) {
        Intrinsics.checkNotNullParameter((Object)schemaVersion, (String)"schemaVersion");
        JupyterNotebookSchema schema = JupyterNotebookSchemaFactory.INSTANCE.createSchema(schemaVersion);
        return new JupyterNotebookBase(schema.createEmptyNotebook(), schema);
    }

    public static /* synthetic */ JupyterNotebookBase createEmptyNotebook$default(JupyterFileUtils jupyterFileUtils, JupyterNotebookSchemaVersion jupyterNotebookSchemaVersion, int n, Object object) {
        if ((n & 1) != 0) {
            jupyterNotebookSchemaVersion = new JupyterNotebookSchemaVersion(5, 9);
        }
        return jupyterFileUtils.createEmptyNotebook(jupyterNotebookSchemaVersion);
    }

    @NotNull
    public final JupyterNotebookBase restoreJupyterNotebookFromSource(@NotNull VirtualFile virtualFile) {
        int n;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            throw new IllegalStateException(("Try to save file " + virtualFile.getPath() + " without cached data and without document").toString());
        }
        NotebookCellLines notebookCellLines = new JupyterCellLinesProvider().create(document);
        List intervals = notebookCellLines.getIntervals();
        JupyterNotebookBase jupyterNotebookBase = this.readNotebookOrNull(virtualFile);
        if (jupyterNotebookBase == null) {
            jupyterNotebookBase = JupyterFileUtils.createEmptyNotebook$default(this, null, 1, null);
        }
        JupyterNotebookBase notebook = jupyterNotebookBase;
        for (NotebookCellLines.Interval interval : intervals) {
            int ordinal = interval.getOrdinal();
            JupyterCell cell = notebook.getCellOrNull(ordinal);
            if (cell != null) {
                cell.setSource(interval.getContentText(document));
                continue;
            }
            notebook.addCell(ordinal, (Function1<? super JupyterCellBuilder, Unit>)((Function1)arg_0 -> JupyterFileUtils.restoreJupyterNotebookFromSource$lambda$1(interval, document, arg_0)));
        }
        int i = intervals.size();
        if (i <= (n = notebook.cellsCount())) {
            while (notebook.getCellOrNull(i) != null) {
                JupyterCell cell;
                cell.setSource("");
                if (i == n) break;
                ++i;
            }
        }
        return notebook;
    }

    @NotNull
    public final VirtualFile getOriginalFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!ApplicationManager.getApplication().isUnitTestMode() && virtualFile instanceof LightVirtualFile && !Intrinsics.areEqual((Object)((LightVirtualFile)virtualFile).getOriginalFile(), (Object)virtualFile)) {
            CharSequence charSequence = ((LightVirtualFile)virtualFile).getContent();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getContent(...)");
            if (!StringsKt.startsWith$default((CharSequence)charSequence, (CharSequence)"{", (boolean)false, (int)2, null)) {
                VirtualFile virtualFile2 = ((LightVirtualFile)virtualFile).getOriginalFile();
                if (Intrinsics.areEqual((Object)(virtualFile2 != null ? virtualFile2.getFileType() : null), (Object)JupyterFileType.INSTANCE)) {
                    VirtualFile virtualFile3 = ((LightVirtualFile)virtualFile).getOriginalFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getOriginalFile(...)");
                    return this.getOriginalFile(virtualFile3);
                }
            }
        }
        return virtualFile;
    }

    @Deprecated(message="Will be removed with double file system implementation")
    @Nullable
    public final CharSequence getSourceForIndex(@NotNull FileContent inputData) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        if (!JupyterIndexRegistry.INSTANCE.isEnabled()) {
            return null;
        }
        VirtualFile virtualFile = inputData.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        BackedNotebookVirtualFile frontFile = BackedNotebookVirtualFile.Companion.takeFront(virtualFile);
        if (frontFile != null) {
            charSequence = inputData.getContentAsText();
        } else {
            CharSequence text;
            CharSequence charSequence2;
            String cachedText;
            VirtualFile virtualFile2 = inputData.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
            Document document = VirtualFileUtil.findDocument((VirtualFile)virtualFile2);
            String string = cachedText = document != null ? document.getText() : null;
            if (string != null) {
                charSequence2 = string;
            } else {
                CharSequence charSequence3 = inputData.getContentAsText();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"getContentAsText(...)");
                String string2 = inputData.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFileName(...)");
                JupyterNotebookBase jupyterNotebookBase = this.readNotebookOrNull(charSequence3, string2);
                charSequence2 = jupyterNotebookBase != null ? jupyterNotebookBase.asSource() : null;
            }
            charSequence = text = charSequence2;
        }
        CharSequence source = charSequence;
        return source;
    }

    private final JupyterNotebookBase initFromJson(ObjectNode json) {
        JupyterNotebookSchema schema = JupyterNotebookSchemaFactory.INSTANCE.createSchema(json);
        JupyterNotebookBase notebook = new JupyterNotebookBase(json, schema);
        JupyterNotebookConverter.Companion.convertAfterLoading(notebook);
        return notebook;
    }

    private static final Unit readNotebook$lambda$0(JupyterCellBuilder $this$addCell) {
        Intrinsics.checkNotNullParameter((Object)$this$addCell, (String)"$this$addCell");
        $this$addCell.setCellType(JupyterCellType.CODE);
        return Unit.INSTANCE;
    }

    private static final Unit restoreJupyterNotebookFromSource$lambda$1(NotebookCellLines.Interval $interval, Document $document, JupyterCellBuilder $this$addCell) {
        Intrinsics.checkNotNullParameter((Object)$this$addCell, (String)"$this$addCell");
        $this$addCell.setSource($interval.getContentText($document));
        $this$addCell.setCellType(OtherKt.toJupyterCellType($interval.getType()));
        return Unit.INSTANCE;
    }
}

