/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.trust;

import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.XCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="It should be removed after 1-2 years of migration", replaceWith=@ReplaceWith(expression="JupyterTrustManager", imports={}))
@Service(value={Service.Level.PROJECT})
@State(name="JupyterTrust", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0001\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001f !B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bJ\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\bJ\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u00002\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\bH\u0002R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/jupyter/core/jupyter/trust/JupyterFileTrustManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/jupyter/core/jupyter/trust/JupyterFileTrustManager$Trust;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "installationID", "", "Lorg/jetbrains/annotations/NotNull;", "trust", "basePathFile", "Ljava/io/File;", "getPath", "fullPath", "getState", "loadState", "", "state", "fileMoved", "fromFullPath", "toFullPath", "fileCopied", "fileCreated", "fileDeleted", "asFileSpecificView", "Lcom/intellij/jupyter/core/jupyter/trust/JupyterFileTrustManager$FileSpecificView;", "addFileInternal", "relativePath", "removeFileInternal", "", "Trust", "FileSpecificView", "Companion", "intellij.jupyter.core"})
@ApiStatus.ScheduledForRemoval
@SourceDebugExtension(value={"SMAP\nJupyterFileTrustManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterFileTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterFileTrustManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n774#2:115\n865#2,2:116\n*S KotlinDebug\n*F\n+ 1 JupyterFileTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterFileTrustManager\n*L\n52#1:115\n52#1:116,2\n*E\n"})
public final class JupyterFileTrustManager
implements PersistentStateComponent<Trust> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String installationID;
    @NotNull
    private final Trust trust;
    @NotNull
    private final File basePathFile;

    public JupyterFileTrustManager(@NotNull Project project) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = PermanentInstallationID.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        this.installationID = string;
        this.trust = new Trust(this.installationID, null, 2, null);
        String string2 = project.getBasePath();
        if (string2 == null) {
            string2 = "";
        }
        this.basePathFile = new File(string2);
        boolean bl2 = bl = !project.isDefault();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
    }

    private final String getPath(String fullPath) {
        File basePathFile = this.basePathFile;
        File fullPathFile = new File(fullPath);
        if (FileUtil.isAncestor((File)basePathFile, (File)fullPathFile, (boolean)true)) {
            String string = FileUtil.getRelativePath((File)basePathFile, (File)fullPathFile);
            if (string == null) {
                string = fullPath;
            }
            return string;
        }
        return fullPath;
    }

    @NotNull
    public Trust getState() {
        return this.trust;
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull Trust state) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!Intrinsics.areEqual((Object)state.getId(), (Object)this.installationID)) {
            return;
        }
        this.trust.getFiles().clear();
        Iterable iterable = state.getFiles();
        Set<String> set = this.trust.getFiles();
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String path = (String)element$iv$iv;
            boolean bl = false;
            if (!(new File(path).exists() || new File(this.basePathFile, path).exists())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        set.addAll((List)destination$iv$iv);
    }

    public final void fileMoved(@NotNull String fromFullPath, @NotNull String toFullPath) {
        Intrinsics.checkNotNullParameter((Object)fromFullPath, (String)"fromFullPath");
        Intrinsics.checkNotNullParameter((Object)toFullPath, (String)"toFullPath");
        String fromRelativePath = this.getPath(fromFullPath);
        if (this.removeFileInternal(fromRelativePath)) {
            this.fileCreated(toFullPath);
        }
    }

    public final void fileCopied(@NotNull String fromFullPath, @NotNull String toFullPath) {
        Intrinsics.checkNotNullParameter((Object)fromFullPath, (String)"fromFullPath");
        Intrinsics.checkNotNullParameter((Object)toFullPath, (String)"toFullPath");
        String fromRelativePath = this.getPath(fromFullPath);
        if (this.trust.getFiles().contains(fromRelativePath)) {
            this.fileCreated(toFullPath);
        }
    }

    public final void fileCreated(@NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        String relativePath = this.getPath(fullPath);
        if (!this.trust.getFiles().contains(relativePath)) {
            this.addFileInternal(relativePath);
        }
    }

    public final void fileDeleted(@NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        String relativePath = this.getPath(fullPath);
        this.removeFileInternal(relativePath);
    }

    @NotNull
    public final FileSpecificView asFileSpecificView(@NotNull String fullPath) {
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        return new FileSpecificView(this.getPath(fullPath));
    }

    private final void addFileInternal(String relativePath) {
        this.trust.getFiles().add(relativePath);
    }

    private final boolean removeFileInternal(String relativePath) {
        return this.trust.getFiles().remove(relativePath);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\b\u0018\u00010\tR\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/trust/JupyterFileTrustManager$Companion;", "", "<init>", "()V", "getTrustManager", "Lcom/intellij/jupyter/core/jupyter/trust/JupyterFileTrustManager;", "project", "Lcom/intellij/openapi/project/Project;", "getForEditor", "Lcom/intellij/jupyter/core/jupyter/trust/JupyterFileTrustManager$FileSpecificView;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterFileTrustManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterFileTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterFileTrustManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n31#2,2:115\n1#3:117\n*S KotlinDebug\n*F\n+ 1 JupyterFileTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterFileTrustManager$Companion\n*L\n105#1:115,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterFileTrustManager getTrustManager(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JupyterFileTrustManager> serviceClass$iv = JupyterFileTrustManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JupyterFileTrustManager)object;
        }

        @Nullable
        public final FileSpecificView getForEditor(@NotNull Editor editor) {
            Object object;
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    object = editor.getProject();
                    if (object == null) break block4;
                    Project it = object;
                    boolean bl = false;
                    JupyterFileTrustManager jupyterFileTrustManager = Companion.getTrustManager(it);
                    object = jupyterFileTrustManager;
                    if (jupyterFileTrustManager != null) break block5;
                }
                return null;
            }
            Object manager = object;
            VirtualFile virtualFile = editor.getVirtualFile();
            if (virtualFile == null && (virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            String string = virtualFile2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return ((JupyterFileTrustManager)manager).asFileSpecificView(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/trust/JupyterFileTrustManager$FileSpecificView;", "", "relativePath", "", "<init>", "(Lcom/intellij/jupyter/core/jupyter/trust/JupyterFileTrustManager;Ljava/lang/String;)V", "value", "", "trusted", "getTrusted", "()Z", "setTrusted", "(Z)V", "intellij.jupyter.core"})
    public final class FileSpecificView {
        @NotNull
        private final String relativePath;

        public FileSpecificView(String relativePath) {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            this.relativePath = relativePath;
        }

        public final boolean getTrusted() {
            return JupyterFileTrustManager.this.trust.getFiles().contains(this.relativePath);
        }

        public final void setTrusted(boolean value) {
            if (value) {
                JupyterFileTrustManager.this.addFileInternal(this.relativePath);
            } else {
                JupyterFileTrustManager.this.removeFileInternal(this.relativePath);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/core/jupyter/trust/JupyterFileTrustManager$Trust;", "", "id", "", "files", "", "<init>", "(Ljava/lang/String;Ljava/util/Set;)V", "getId", "()Ljava/lang/String;", "getFiles", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.jupyter.core"})
    public static final class Trust {
        @Attribute
        @NotNull
        private final String id;
        @XCollection
        @NotNull
        private final Set<String> files;

        public Trust(@NotNull String id, @NotNull Set<String> files) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            this.id = id;
            this.files = files;
        }

        public /* synthetic */ Trust(String string, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                set = new HashSet();
            }
            this(string, set);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final Set<String> getFiles() {
            return this.files;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final Set<String> component2() {
            return this.files;
        }

        @NotNull
        public final Trust copy(@NotNull String id, @NotNull Set<String> files) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            return new Trust(id, files);
        }

        public static /* synthetic */ Trust copy$default(Trust trust, String string, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                string = trust.id;
            }
            if ((n & 2) != 0) {
                set = trust.files;
            }
            return trust.copy(string, set);
        }

        @NotNull
        public String toString() {
            return "Trust(id=" + this.id + ", files=" + this.files + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + ((Object)this.files).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Trust)) {
                return false;
            }
            Trust trust = (Trust)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)trust.id)) {
                return false;
            }
            return Intrinsics.areEqual(this.files, trust.files);
        }

        public Trust() {
            this(null, null, 3, null);
        }
    }
}

