/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.ui;

import com.intellij.ide.ui.VirtualFileAppearanceListener;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.execution.JupyterRunningNotebookTracker;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteFileSystem;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/core/jupyter/ui/JupyterRunningNotebookFileIconUpdater;", "Lcom/intellij/jupyter/core/jupyter/execution/JupyterRunningNotebookTracker$Listener;", "<init>", "()V", "sessionStarted", "", "connParameters", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters;", "path", "", "sessionStopped", "updateIcon", "findLocalNotebookFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "basePath", "intellij.jupyter.core"})
final class JupyterRunningNotebookFileIconUpdater
implements JupyterRunningNotebookTracker.Listener {
    @Override
    public void sessionStarted(@NotNull JupyterConnectionParameters connParameters, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)connParameters, (String)"connParameters");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.updateIcon(connParameters, path);
    }

    @Override
    public void sessionStopped(@NotNull JupyterConnectionParameters connParameters, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)connParameters, (String)"connParameters");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.updateIcon(connParameters, path);
    }

    private final void updateIcon(JupyterConnectionParameters connParameters, String path) {
        block2: {
            VirtualFile originFile;
            Object object = JupyterRunningNotebookTracker.Companion.getInstance().getRoot(connParameters.getLocation().getUri());
            if (object == null || (object = object.getPath()) == null) {
                return;
            }
            Object basePath = object;
            VirtualFile virtualFile = this.findLocalNotebookFile((String)basePath, path);
            if (virtualFile == null) {
                JupyterRemoteFileSystem jupyterRemoteFileSystem = JupyterRemoteFileSystem.Companion.getInstanceOrNull();
                virtualFile = (VirtualFile)(jupyterRemoteFileSystem != null ? jupyterRemoteFileSystem.findFileByPath((String)basePath + "/" + path) : null);
            }
            VirtualFile virtualFile2 = originFile = virtualFile;
            if (virtualFile2 == null) break block2;
            VirtualFile it = virtualFile2;
            boolean bl = false;
            ActionsKt.invokeLater$default(null, () -> JupyterRunningNotebookFileIconUpdater.updateIcon$lambda$1$lambda$0(it), (int)1, null);
        }
    }

    private final VirtualFile findLocalNotebookFile(String basePath, String path) {
        String[] stringArray;
        try {
            stringArray = new String[]{path};
            stringArray = VfsUtil.findFile((Path)Paths.get(basePath, stringArray), (boolean)true);
        }
        catch (InvalidPathException e) {
            stringArray = null;
        }
        return stringArray;
    }

    private static final Unit updateIcon$lambda$1$lambda$0(VirtualFile $it) {
        VirtualFileAppearanceListener.fireVirtualFileAppearanceChanged((VirtualFile)$it);
        return Unit.INSTANCE;
    }
}

