/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.core.jupyter.remote.vfs;

import com.intellij.notebooks.core.NotebooksCoreBundle;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteFileStrategy;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteFileSystem;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteVirtualFileWriteQueue;
import com.intellij.notebooks.core.jupyter.remote.vfs.UploadingTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ui.update.Update;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/notebooks/core/jupyter/remote/vfs/UploadingTask;", "Lcom/intellij/util/ui/update/Update;", "virtualFile", "Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;", "content", "", "createdOnServer", "Ljava/util/concurrent/atomic/AtomicBoolean;", "strategy", "Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteFileStrategy;", "<init>", "(Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;[BLjava/util/concurrent/atomic/AtomicBoolean;Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteFileStrategy;)V", "getVirtualFile", "()Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;", "modificationStampAtTaskCreation", "", "run", "", "canEat", "", "update", "toString", "", "intellij.notebooks.core"})
@SourceDebugExtension(value={"SMAP\nUploadingTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadingTask.kt\ncom/intellij/notebooks/core/jupyter/remote/vfs/UploadingTask\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,74:1\n61#2,5:75\n*S KotlinDebug\n*F\n+ 1 UploadingTask.kt\ncom/intellij/notebooks/core/jupyter/remote/vfs/UploadingTask\n*L\n22#1:75,5\n*E\n"})
public final class UploadingTask
extends Update {
    @NotNull
    private final JupyterRemoteVirtualFile virtualFile;
    @NotNull
    private final byte[] content;
    @NotNull
    private final AtomicBoolean createdOnServer;
    @NotNull
    private final JupyterRemoteFileStrategy strategy;
    private final long modificationStampAtTaskCreation;

    public UploadingTask(@NotNull JupyterRemoteVirtualFile virtualFile, @NotNull byte[] content, @NotNull AtomicBoolean createdOnServer, @NotNull JupyterRemoteFileStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)((Object)virtualFile), (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)createdOnServer, (String)"createdOnServer");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        super((Object)virtualFile, false, 0, 6, null);
        this.virtualFile = virtualFile;
        this.content = content;
        this.createdOnServer = createdOnServer;
        this.strategy = strategy;
        this.modificationStampAtTaskCreation = this.virtualFile.getModificationStamp();
    }

    @NotNull
    public final JupyterRemoteVirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    public void run() {
        if (JupyterRemoteVirtualFileWriteQueue.Companion.getActiveUploads().putIfAbsent(this.virtualFile, this) != null) {
            Logger $this$debug_u24default$iv = JupyterRemoteFileSystem.Companion.getJUPYTER_VFS_LOG();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("The file is uploading right now, so putting " + this + " back in the queue.", e$iv);
            }
            JupyterRemoteVirtualFileWriteQueue.Companion.queue(this);
            return;
        }
        Object[] objectArray = new Object[]{this.virtualFile.getPath()};
        String string = NotebooksCoreBundle.INSTANCE.message("Jupyter.remote.uploading.to.jupyter", objectArray);
        Task.Backgroundable task2 = new Task.Backgroundable(this, string){
            final /* synthetic */ UploadingTask this$0;
            {
                this.this$0 = $receiver;
                super(null, $super_call_param$1, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    void $this$debug_u24default$iv;
                    void var9_10;
                    void $this$debug_u24default$iv2;
                    Logger logger = JupyterRemoteFileSystem.Companion.getJUPYTER_VFS_LOG();
                    UploadingTask uploadingTask = this.this$0;
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv2.isDebugEnabled()) {
                        var9_10 = $this$debug_u24default$iv2;
                        boolean bl = false;
                        var9_10.debug(uploadingTask + " have started.", e$iv);
                    }
                    int chunkSize = 131072;
                    indicator.setIndeterminate(false);
                    indicator.checkCanceled();
                    UploadingTask.access$getStrategy$p(this.this$0).fileWriter(this.this$0.getVirtualFile().getRemotePath(), UploadingTask.access$getStrategy$p(this.this$0).virtualFileIsNotebook(this.this$0.getVirtualFile()), (Function1<? super OutputStream, Unit>)((Function1)arg_0 -> run.task.1.run$lambda$1(this.this$0, chunkSize, indicator, arg_0)));
                    boolean createdOnServer = !UploadingTask.access$getCreatedOnServer$p(this.this$0).getAndSet(true);
                    uploadingTask = JupyterRemoteFileSystem.Companion.getJUPYTER_VFS_LOG();
                    UploadingTask uploadingTask2 = this.this$0;
                    Throwable e$iv2 = null;
                    boolean $i$f$debug2 = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        var9_10 = $this$debug_u24default$iv;
                        boolean bl = false;
                        var9_10.debug(uploadingTask2 + " have finished." + (createdOnServer ? " Most likely, the file have been created on the server." : ""), e$iv2);
                    }
                    if (createdOnServer) {
                        CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ UploadingTask this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        VirtualFileSystem virtualFileSystem = this.this$0.getVirtualFile().getFileSystem();
                                        Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteFileSystem");
                                        ((JupyterRemoteFileSystem)virtualFileSystem)._vfs_private_fileCreatedOnServer$intellij_notebooks_core(this.this$0.getVirtualFile());
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }));
                    }
                }
                finally {
                    JupyterRemoteVirtualFileWriteQueue.Companion.getActiveUploads().compute(this.this$0.getVirtualFile(), (arg_0, arg_1) -> run.task.1.run$lambda$4((arg_0, arg_1) -> run.task.1.run$lambda$3(this.this$0, arg_0, arg_1), arg_0, arg_1));
                    VirtualFileSystem virtualFileSystem = this.this$0.getVirtualFile().getFileSystem();
                    Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteFileSystem");
                    ((JupyterRemoteFileSystem)virtualFileSystem)._vfs_private_fileUploadFinished$intellij_notebooks_core(this.this$0.getVirtualFile().getRemotePath());
                }
            }

            private static final Unit run$lambda$1(UploadingTask this$0, int $chunkSize, ProgressIndicator $indicator, OutputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                int n = UploadingTask.access$getContent$p(this$0).length + -1;
                if ($chunkSize <= 0) {
                    throw new IllegalArgumentException("Step must be positive, was: " + $chunkSize + ".");
                }
                int offset = 0;
                int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)$chunkSize);
                if (offset <= n2) {
                    while (true) {
                        $indicator.checkCanceled();
                        $indicator.setFraction((double)offset / (double)UploadingTask.access$getContent$p(this$0).length);
                        it.write(UploadingTask.access$getContent$p(this$0), offset, Math.min(UploadingTask.access$getContent$p(this$0).length - offset, $chunkSize));
                        if (offset == n2) break;
                        offset += $chunkSize;
                    }
                }
                $indicator.setFraction(1.0);
                return Unit.INSTANCE;
            }

            private static final UploadingTask run$lambda$3(UploadingTask this$0, JupyterRemoteVirtualFile jupyterRemoteVirtualFile, UploadingTask old) {
                Intrinsics.checkNotNullParameter((Object)((Object)jupyterRemoteVirtualFile), (String)"<unused var>");
                return old == this$0 ? null : old;
            }

            private static final UploadingTask run$lambda$4(Function2 $tmp0, Object p0, Object p1) {
                return (UploadingTask)((Object)$tmp0.invoke(p0, p1));
            }
        };
        task2.queue();
    }

    public boolean canEat(@NotNull Update update) {
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        return update instanceof UploadingTask && Intrinsics.areEqual((Object)((UploadingTask)update).virtualFile.getPath(), (Object)this.virtualFile.getPath()) && ((UploadingTask)update).modificationStampAtTaskCreation < this.modificationStampAtTaskCreation;
    }

    @NotNull
    public String toString() {
        return "UploadTask(\"" + this.virtualFile.getPath() + "\", modification stamp " + this.modificationStampAtTaskCreation + ")";
    }

    public static final /* synthetic */ JupyterRemoteFileStrategy access$getStrategy$p(UploadingTask $this) {
        return $this.strategy;
    }

    public static final /* synthetic */ AtomicBoolean access$getCreatedOnServer$p(UploadingTask $this) {
        return $this.createdOnServer;
    }

    public static final /* synthetic */ byte[] access$getContent$p(UploadingTask $this) {
        return $this.content;
    }
}

