/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.ui.visualization.markerRenderers;

import com.intellij.notebooks.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.ui.visualization.NotebookEditorAppearance;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.ui.visualization.markerRenderers.NotebookLineMarkerRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \b\u0002\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/notebooks/ui/visualization/markerRenderers/NotebookCodeCellBackgroundLineMarkerRenderer;", "Lcom/intellij/notebooks/ui/visualization/markerRenderers/NotebookLineMarkerRenderer;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "boundsProvider", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/Editor;", "Lkotlin/Pair;", "", "presentationModeMasking", "", "<init>", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lkotlin/jvm/functions/Function1;Z)V", "paint", "", "editor", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "intellij.notebooks.ui"})
@SourceDebugExtension(value={"SMAP\nNotebookCodeCellBackgroundLineMarkerRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCodeCellBackgroundLineMarkerRenderer.kt\ncom/intellij/notebooks/ui/visualization/markerRenderers/NotebookCodeCellBackgroundLineMarkerRenderer\n+ 2 NotebookUtil.kt\ncom/intellij/notebooks/ui/visualization/NotebookUtil\n*L\n1#1,34:1\n28#2,31:35\n*S KotlinDebug\n*F\n+ 1 NotebookCodeCellBackgroundLineMarkerRenderer.kt\ncom/intellij/notebooks/ui/visualization/markerRenderers/NotebookCodeCellBackgroundLineMarkerRenderer\n*L\n30#1:35,31\n*E\n"})
public final class NotebookCodeCellBackgroundLineMarkerRenderer
extends NotebookLineMarkerRenderer {
    @NotNull
    private final RangeHighlighter highlighter;
    @NotNull
    private final Function1<Editor, Pair<Integer, Integer>> boundsProvider;
    private final boolean presentationModeMasking;

    public NotebookCodeCellBackgroundLineMarkerRenderer(@NotNull RangeHighlighter highlighter, @NotNull Function1<? super Editor, Pair<Integer, Integer>> boundsProvider, boolean presentationModeMasking) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter(boundsProvider, (String)"boundsProvider");
        super(null, 1, null);
        this.highlighter = highlighter;
        this.boundsProvider = boundsProvider;
        this.presentationModeMasking = presentationModeMasking;
    }

    public /* synthetic */ NotebookCodeCellBackgroundLineMarkerRenderer(RangeHighlighter rangeHighlighter, Function1 function1, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = arg_0 -> NotebookCodeCellBackgroundLineMarkerRenderer._init_$lambda$0(rangeHighlighter, arg_0);
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(rangeHighlighter, (Function1<? super Editor, Pair<Integer, Integer>>)function1, bl);
    }

    /*
     * WARNING - void declaration
     */
    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
        Triple triple;
        void editor$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        EditorImpl cfr_ignored_0 = (EditorImpl)editor;
        IntRange lines = new IntRange(((EditorImpl)editor).getDocument().getLineNumber(this.highlighter.getStartOffset()), ((EditorImpl)editor).getDocument().getLineNumber(this.highlighter.getEndOffset()));
        Pair pair = (Pair)this.boundsProvider.invoke((Object)editor);
        int top = ((Number)pair.component1()).intValue();
        int height = ((Number)pair.component2()).intValue();
        NotebookUtil notebookUtil = NotebookUtil.INSTANCE;
        EditorImpl editorImpl = (EditorImpl)editor;
        boolean presentationModeMasking$iv = this.presentationModeMasking;
        boolean $i$f$paintNotebookCellBackgroundGutter = false;
        int diffViewOffset$iv = 6;
        NotebookEditorAppearance appearance$iv = this_$iv.getNotebookAppearance((Editor)editor$iv);
        Color stripe$iv = appearance$iv.getCellStripeColor((EditorImpl)editor$iv, lines);
        Color stripeHover$iv = appearance$iv.getCellStripeHoverColor((EditorImpl)editor$iv, lines);
        int borderWidth$iv = appearance$iv.getLeftBorderWidth();
        int gutterWidth$iv = editor$iv.getGutterComponentEx().getWidth();
        if (presentationModeMasking$iv) {
            triple = new Triple((Object)(r.width - borderWidth$iv - gutterWidth$iv), (Object)gutterWidth$iv, (Object)editor$iv.getColorsScheme().getDefaultBackground());
        } else {
            Integer n = r.width - borderWidth$iv;
            Integer n2 = borderWidth$iv;
            EditorColorsScheme editorColorsScheme = editor$iv.getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
            triple = new Triple((Object)n, (Object)n2, (Object)appearance$iv.getCodeCellBackground(editorColorsScheme));
        }
        Triple triple2 = triple;
        int fillX$iv = ((Number)triple2.component1()).intValue();
        int fillWidth$iv = ((Number)triple2.component2()).intValue();
        Color fillColor$iv = (Color)triple2.component3();
        g.setColor(fillColor$iv);
        if (editor$iv.getEditorKind() == EditorKind.DIFF) {
            g.fillRect(fillX$iv + diffViewOffset$iv, top, fillWidth$iv - diffViewOffset$iv, height);
        } else {
            g.fillRect(fillX$iv, top, fillWidth$iv, height);
        }
        boolean bl = false;
        NotebookUtil.INSTANCE.paintCaretRow((EditorImpl)editor, g, lines);
        if (!Intrinsics.areEqual((Object)editor$iv.getUserData(NotebookEditorUiUtilKt.isFoldingEnabledKey()), (Object)true) && editor$iv.getEditorKind() != EditorKind.DIFF) {
            if (stripe$iv != null) {
                this_$iv.paintCellStripe(appearance$iv, g, r, stripe$iv, top, height, (Editor)editor$iv);
            }
            if (stripeHover$iv != null) {
                g.setColor(stripeHover$iv);
                g.fillRect(r.width - appearance$iv.getLeftBorderWidth(), top, appearance$iv.getCellLeftLineHoverWidth(), height);
            }
        }
    }

    private static final Pair _init_$lambda$0(RangeHighlighter $highlighter, Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        IntRange lines = new IntRange(editor.getDocument().getLineNumber($highlighter.getStartOffset()), editor.getDocument().getLineNumber($highlighter.getEndOffset()));
        int top = editor.offsetToXY((int)editor.getDocument().getLineStartOffset((int)lines.getFirst())).y;
        int height = editor.offsetToXY((int)editor.getDocument().getLineEndOffset((int)lines.getLast())).y + editor.getLineHeight() - top;
        return TuplesKt.to((Object)top, (Object)height);
    }
}

