/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellEventListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0014\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellSelectionModel;", "", "manager", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "<init>", "(Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;)V", "_selection", "", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "selection", "", "getSelection", "()Ljava/util/List;", "removeCell", "", "selectedCell", "replaceSelection", "cells", "", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorCellSelectionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellSelectionModel.kt\ncom/intellij/notebooks/visualization/ui/EditorCellSelectionModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1053#2:43\n1863#2,2:44\n1863#2,2:46\n*S KotlinDebug\n*F\n+ 1 EditorCellSelectionModel.kt\ncom/intellij/notebooks/visualization/ui/EditorCellSelectionModel\n*L\n10#1:43\n31#1:44,2\n34#1:46,2\n*E\n"})
public final class EditorCellSelectionModel {
    @NotNull
    private final Set<EditorCell> _selection;

    public EditorCellSelectionModel(@NotNull NotebookCellInlayManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this._selection = new LinkedHashSet();
        manager.addCellEventsListener(new EditorCellEventListener(){

            @Override
            public void onEditorCellEvents(List<? extends EditorCellEventListener.EditorCellEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                for (EditorCellEventListener.EditorCellEvent editorCellEvent : events) {
                    if (!(editorCellEvent instanceof EditorCellEventListener.CellRemoved)) continue;
                    this.removeCell(((EditorCellEventListener.CellRemoved)editorCellEvent).getCell());
                }
            }
        }, manager);
    }

    @NotNull
    public final List<EditorCell> getSelection() {
        Iterable $this$sortedBy$iv = this._selection;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                EditorCell it = (EditorCell)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getInterval().getOrdinal());
                it = (EditorCell)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getInterval().getOrdinal()));
            }
        });
    }

    private final void removeCell(EditorCell selectedCell) {
        this._selection.remove(selectedCell);
        selectedCell.getSelected().set(false);
    }

    public final void replaceSelection(@NotNull Collection<EditorCell> cells) {
        EditorCell it;
        Intrinsics.checkNotNullParameter(cells, (String)"cells");
        Set selectionSet = CollectionsKt.toSet((Iterable)cells);
        Set toRemove = SetsKt.minus(this._selection, (Iterable)selectionSet);
        Set toAdd = SetsKt.minus((Set)selectionSet, (Iterable)this._selection);
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (EditorCell)element$iv;
            boolean bl = false;
            it.getSelected().set(false);
        }
        $this$forEach$iv = toAdd;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (EditorCell)element$iv;
            boolean bl = false;
            it.getSelected().set(true);
        }
        this._selection.removeAll(toRemove);
        this._selection.addAll(toAdd);
    }
}

