/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.DomainWrapper;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDomainRegistry
implements DomainRegistry {
    private final Set<Domain> mySet = new LinkedHashSet<Domain>();
    protected static final Logger LOG = Logger.getInstance(BaseDomainRegistry.class);

    protected BaseDomainRegistry() {
    }

    @Override
    @Nullable
    public Domain getDomain(@NotNull ColumnDescriptor descriptor2) {
        List suitable;
        List sorted;
        if (descriptor2 == null) {
            BaseDomainRegistry.$$$reportNull$$$0(0);
        }
        if ((sorted = ContainerUtil.sorted((Collection)(suitable = ContainerUtil.filter(this.mySet, domain -> domain.isSuitable(descriptor2))), Comparator.comparing(o -> o.getVersionRange() == null ? null : o.getVersionRange().getUntilVersion(), Comparator.nullsLast(Comparator.naturalOrder())).reversed())).size() > 1 && ((Domain)sorted.get(sorted.size() - 1)).getVersionRange() == null) {
            LOG.warn("There are several domains to choose, but at least one of them doesn't have version range: " + suitable);
        }
        return sorted.isEmpty() ? null : (Domain)sorted.get(0);
    }

    @Override
    @NotNull
    public Collection<Domain> getDomains() {
        Set<Domain> set = Collections.unmodifiableSet(this.mySet);
        if (set == null) {
            BaseDomainRegistry.$$$reportNull$$$0(1);
        }
        return set;
    }

    protected final void add(@NotNull Domain domain) {
        if (domain == null) {
            BaseDomainRegistry.$$$reportNull$$$0(2);
        }
        this.mySet.add(domain);
    }

    @NotNull
    public static Domain getMostRecentDomain(@NotNull Domain domain, @NotNull Dbms dbms, @Nullable Version version) {
        if (domain == null) {
            BaseDomainRegistry.$$$reportNull$$$0(3);
        }
        if (dbms == null) {
            BaseDomainRegistry.$$$reportNull$$$0(4);
        }
        DomainRegistry registry = BaseDomainRegistry.get(dbms, version);
        Collection<Domain> domains = registry.getDomains();
        Domain unwrapped = DomainWrapper.unwrap(domain);
        Comparator domainComparator = (Comparator)COMPARATOR_GENERATOR.fun((Object)unwrapped);
        List filtered = ContainerUtil.sorted((Collection)ContainerUtil.filter(domains, current -> current.contains(unwrapped)), (Comparator)domainComparator);
        if (filtered.isEmpty()) {
            Domain domain2 = Domain.EMPTY;
            if (domain2 == null) {
                BaseDomainRegistry.$$$reportNull$$$0(5);
            }
            return domain2;
        }
        for (int i2 = 0; i2 < filtered.size() - 1; ++i2) {
            Domain item = (Domain)filtered.get(i2);
            if (domain.isSuitable(new TypeNameColumnDescriptor(item.simpleName()))) {
                Domain domain3 = item.narrow(unwrapped);
                if (domain3 == null) {
                    BaseDomainRegistry.$$$reportNull$$$0(6);
                }
                return domain3;
            }
            if (domainComparator.compare(item, (Domain)filtered.get(i2 + 1)) != 0) break;
        }
        Domain domain4 = ((Domain)filtered.get(0)).narrow(unwrapped);
        if (domain4 == null) {
            BaseDomainRegistry.$$$reportNull$$$0(7);
        }
        return domain4;
    }

    @NotNull
    public static DomainRegistry get(@NotNull Dbms dbms, @Nullable Version version) {
        if (dbms == null) {
            BaseDomainRegistry.$$$reportNull$$$0(8);
        }
        DomainRegistry registry = (DomainRegistry)EP.forDbms(dbms);
        return version == null ? registry : new DomainRegistry.VersionedDomainRegistry(registry, version);
    }

    @Nullable
    public static Domain getDomain(@NotNull Dbms dbms, @Nullable Version version, @NotNull ColumnDescriptor descriptor2, boolean raw) {
        DomainRegistry registry;
        Domain domain;
        if (dbms == null) {
            BaseDomainRegistry.$$$reportNull$$$0(9);
        }
        if (descriptor2 == null) {
            BaseDomainRegistry.$$$reportNull$$$0(10);
        }
        return (domain = (registry = BaseDomainRegistry.get(dbms, version)).getDomain(descriptor2)) == null ? null : (!raw && descriptor2 instanceof SizeProvider ? domain.narrow((SizeProvider)descriptor2) : domain);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/BaseDomainRegistry";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/BaseDomainRegistry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomains";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMostRecentDomain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDomain";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMostRecentDomain";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

