/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.database;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dbimport.ui.component.TableEditorComponent;
import com.intellij.database.dbimport.ui.csv.CsvFormatComponent;
import com.intellij.database.dbimport.ui.database.CachedDatabaseTableEditorComponent;
import com.intellij.database.dbimport.ui.database.DatabaseDataPreviewComponent;
import com.intellij.database.dbimport.ui.database.TargetSchemaForm;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbNamespace;
import com.intellij.database.targetChooser.DataSourceSchemaComboBox;
import com.intellij.database.targetChooser.DataSourceTargetItem;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.ObjectUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetSchemaComponent
implements ImportComponent<ImportEditorContext, TableEditorComponent.TableEditorComponentInfo> {
    private ImportEditorContext myContext;
    private final TargetSchemaForm myTargetSchemaForm;
    private final Project myProject;
    private boolean myDisableListener;
    private Consumer<ImportEditorContext> mySchemaChangeListener;

    public TargetSchemaComponent(@NotNull Project project, boolean multipleSources) {
        if (project == null) {
            TargetSchemaComponent.$$$reportNull$$$0(0);
        }
        this.myDisableListener = false;
        this.myProject = project;
        this.myTargetSchemaForm = new TargetSchemaForm(project, multipleSources);
    }

    private void setSelectedSchema(@Nullable DbNamespace s, @NotNull DasDataSource dataSource) {
        ObjectPath schemaPath;
        if (dataSource == null) {
            TargetSchemaComponent.$$$reportNull$$$0(1);
        }
        if ((schemaPath = ObjectPaths.of(s)) == null) {
            return;
        }
        for (int i2 = 0; i2 < this.myTargetSchemaForm.getDataSourceSchemaComboBox().getModel().getSize(); ++i2) {
            DataSourceTargetItem item = (DataSourceTargetItem)this.myTargetSchemaForm.getDataSourceSchemaComboBox().getModel().getElementAt(i2);
            ObjectPath itemPath = item.getPath();
            LocalDataSource itemDataSource = item.getDs();
            if (itemPath == null || itemDataSource == null || !itemPath.equals(schemaPath) || !itemDataSource.getUniqueId().equals(dataSource.getUniqueId())) continue;
            this.myTargetSchemaForm.getDataSourceSchemaComboBox().setSelectedItem(item);
            break;
        }
    }

    @Override
    @Nullable
    public ValidationInfo validate() {
        if (this.myContext != null && this.myTargetSchemaForm.getDataSourceSchemaComboBox().getSelectedItem() == null) {
            return new ValidationInfo(DatabaseBundle.message("database.data.import.empty.schema.error", new Object[0]), (JComponent)((Object)this.myTargetSchemaForm.getDataSourceSchemaComboBox()));
        }
        return null;
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener<?> listener2) {
        if (listener2 == null) {
            TargetSchemaComponent.$$$reportNull$$$0(2);
        }
        this.myTargetSchemaForm.getDataSourceSchemaComboBox().addItemListener(e -> {
            DbNamespace dbSchema;
            if (this.myDisableListener) {
                return;
            }
            DataSourceTargetItem item = (DataSourceTargetItem)ObjectUtils.tryCast((Object)this.myTargetSchemaForm.getDataSourceSchemaComboBox().getSelectedItem(), DataSourceTargetItem.class);
            if (item == null) {
                return;
            }
            LocalDataSource dataSource = item.getDs();
            DbDataSource dbDataSource = dataSource == null ? null : DbImplUtilCore.getDbDataSource(this.myProject, dataSource);
            ObjectPath schemaPath = item.getPath();
            BasicSchema schema = schemaPath == null || dbDataSource == null ? null : (BasicSchema)DbSqlUtilCore.findObjects(dbDataSource, schemaPath).filter(BasicSchema.class).first();
            DbNamespace dbNamespace = dbSchema = schema == null ? null : (DbNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.findElement(dbDataSource, schema), DbNamespace.class);
            if (dbSchema != null) {
                this.myContext = ImportAction.createContext(dbSchema, this.myProject, dbSchema.getDbms());
                listener2.changed(this, TableEditorComponent.TableEditorComponentInfo.create(null, this.myContext));
                this.mySchemaChangeListener.accept(this.myContext);
            }
        });
    }

    @Override
    @NotNull
    public CompletionStage<TableEditorComponent.TableEditorComponentInfo> notifyChanged(@NotNull ImportEditorContext object) {
        if (object == null) {
            TargetSchemaComponent.$$$reportNull$$$0(3);
        }
        this.myContext = object;
        try {
            this.myDisableListener = true;
            if (object.getNamespace() != null) {
                this.setSelectedSchema(object.getNamespace(), object.getNamespace().getDataSource());
            } else {
                this.myTargetSchemaForm.getDataSourceSchemaComboBox().setSelectedItem(null);
            }
        }
        finally {
            this.myDisableListener = false;
        }
        CompletableFuture<TableEditorComponent.TableEditorComponentInfo> completableFuture = CompletableFuture.completedFuture(TableEditorComponent.TableEditorComponentInfo.create(null, object));
        if (completableFuture == null) {
            TargetSchemaComponent.$$$reportNull$$$0(4);
        }
        return completableFuture;
    }

    @Override
    public boolean isParentFor(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            TargetSchemaComponent.$$$reportNull$$$0(5);
        }
        return observer instanceof CsvFormatComponent || observer instanceof CachedDatabaseTableEditorComponent || observer instanceof DatabaseDataPreviewComponent;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myTargetSchemaForm.getPanel();
        if (jPanel == null) {
            TargetSchemaComponent.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @Override
    public void build(@NotNull ImportInfo.Builder builder, @NotNull ImportEditorContext context) {
        if (builder == null) {
            TargetSchemaComponent.$$$reportNull$$$0(7);
        }
        if (context == null) {
            TargetSchemaComponent.$$$reportNull$$$0(8);
        }
        builder.context(this.myContext != null ? this.myContext : context);
    }

    @Override
    public boolean isVisible(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            TargetSchemaComponent.$$$reportNull$$$0(9);
        }
        return true;
    }

    @Nullable
    public ImportEditorContext getContext() {
        return this.myContext;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        DataSourceSchemaComboBox dataSourceSchemaComboBox = this.myTargetSchemaForm.getDataSourceSchemaComboBox();
        if (dataSourceSchemaComboBox == null) {
            TargetSchemaComponent.$$$reportNull$$$0(10);
        }
        return dataSourceSchemaComboBox;
    }

    public void addSchemaChangedListener(@NotNull Consumer<ImportEditorContext> listener2) {
        if (listener2 == null) {
            TargetSchemaComponent.$$$reportNull$$$0(11);
        }
        this.mySchemaChangeListener = listener2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/database/TargetSchemaComponent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observer";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/database/TargetSchemaComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyChanged";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedSchema";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notifyChanged";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isParentFor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addSchemaChangedListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 10 -> new IllegalStateException(string);
        };
    }
}

