/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.producers;

import com.intellij.database.dialects.base.generator.ElementProducer;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.Producer;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.basic.BasicLikeTable;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0019\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0010\u00a8\u0006\u0007"}, d2={"outsideTableOperation", "Lcom/intellij/database/dialects/base/generator/Operation;", "operation", "tableElement", "Lcom/intellij/database/model/basic/BasicColumniation;", "table", "Lcom/intellij/database/model/basic/BasicLikeTable;", "intellij.database.dialects.base"})
@JvmName(name="ScriptingUtils")
public final class ScriptingUtils {
    @NotNull
    public static final Operation outsideTableOperation(@NotNull Operation operation, @NotNull BasicColumniation tableElement) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)tableElement, (String)"tableElement");
        BasicLikeTable table = tableElement.getLikeTable();
        if (table == null) {
            Operation operation2 = (Operation)operation.getParent();
            if (operation2 == null) {
                operation2 = operation;
            }
            return operation2;
        }
        return ScriptingUtils.outsideTableOperation(operation, table);
    }

    @NotNull
    public static final Operation outsideTableOperation(@NotNull Operation operation, @NotNull BasicLikeTable table) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Operation parentOperation;
        while ((parentOperation = (Operation)operation.getParent()) != null) {
            Producer producer = operation.getProducer();
            if (producer instanceof ElementProducer && Intrinsics.areEqual(((ElementProducer)producer).getElement(), (Object)table)) {
                return parentOperation;
            }
            BasicLikeTable basicLikeTable = table;
            operation = parentOperation;
            table = basicLikeTable;
        }
        return operation;
    }
}

