/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2.introspector.jdbc;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcSourceLoader;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Db2BaseJdbcSourceLoader
extends JdbcSourceLoader {
    private Db2BaseJdbcSourceLoader(@NotNull Dbms dbms) {
        if (dbms == null) {
            Db2BaseJdbcSourceLoader.$$$reportNull$$$0(0);
        }
        super(dbms);
    }

    @Override
    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        Dbms dbms;
        if (element == null) {
            Db2BaseJdbcSourceLoader.$$$reportNull$$$0(1);
        }
        String query = (dbms = this.guessExactDbms(element)) == Dbms.DB2_IS ? "SELECT 'CREATE VIEW ' || TABLE_NAME || ' AS ' || VIEW_DEFINITION FROM QSYS2.SYSVIEWS WHERE TABLE_SCHEMA = '" + DasUtil.getSchema(element) + "' AND UPPER(TABLE_NAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "'" : (dbms == Dbms.DB2_ZOS ? "SELECT STATEMENT FROM SYSIBM.SYSVIEWS WHERE CREATOR = '" + DasUtil.getSchema(element) + "' AND UPPER(NAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "'" : "SELECT TEXT FROM SYSCAT.VIEWS WHERE VIEWSCHEMA = '" + DasUtil.getSchema(element) + "' AND UPPER(VIEWNAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "'");
        return Pair.create((Object)query, (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
    }

    @Override
    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            Db2BaseJdbcSourceLoader.$$$reportNull$$$0(2);
        }
        DasRoutine.Kind type = element.getRoutineKind();
        Dbms dbms = this.guessExactDbms(element);
        String query = dbms == Dbms.DB2_IS ? "SELECT ROUTINE_DEFINITION FROM QSYS2.SYSROUTINES  WHERE ROUTINE_SCHEMA='" + DasUtil.getSchema(element) + "' AND UPPER(ROUTINE_NAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "' AND ROUTINE_TYPE = '" + (type == DasRoutine.Kind.FUNCTION ? "FUNCTION" : "PROCEDURE") + "'" : (dbms == Dbms.DB2_ZOS ? "SELECT TEXT FROM SYSIBM.ROUTINES WHERE SCHEMA='" + DasUtil.getSchema(element) + "' AND UPPER(NAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "' AND ROUTINETYPE = '" + (type == DasRoutine.Kind.FUNCTION ? "F" : "P") + "'" : "SELECT TEXT FROM SYSCAT.ROUTINES WHERE ROUTINESCHEMA='" + DasUtil.getSchema(element) + "' AND UPPER(ROUTINENAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "' AND ROUTINETYPE = '" + (type == DasRoutine.Kind.FUNCTION ? "F" : "P") + "'");
        Pair pair = Pair.create((Object)query, (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            Db2BaseJdbcSourceLoader.$$$reportNull$$$0(3);
        }
        return pair;
    }

    public Dbms guessExactDbms(@Nullable DasObject element) {
        if (this.myDbms != Dbms.DB2) {
            return this.myDbms;
        }
        return DbImplUtilCore.getDbms(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/db2/introspector/jdbc/Db2BaseJdbcSourceLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/db2/introspector/jdbc/Db2BaseJdbcSourceLoader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

