/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.dialects.oracle.generator.OraNamingService;
import com.intellij.database.dialects.oracle.model.OraAliasType;
import com.intellij.database.dialects.oracle.model.OraCollectionType;
import com.intellij.database.dialects.oracle.model.OraModelUtils;
import com.intellij.database.dialects.oracle.model.OraObjectType;
import com.intellij.database.dialects.oracle.types.OraIntervalType;
import com.intellij.database.dialects.oracle.types.OraRecordType;
import com.intellij.database.dialects.oracle.types.OraRefCursorType;
import com.intellij.database.dialects.oracle.types.OraRefType;
import com.intellij.database.dialects.oracle.types.OraTimeAwareType;
import com.intellij.database.dialects.oracle.types.OraTypeSystemKt;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicUserDefinedType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbCustomType;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasAliasDefinedType;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasBuiltinTypeClassWithSuffix;
import com.intellij.database.types.DasBuiltinTypeWithLength;
import com.intellij.database.types.DasBuiltinTypeWithLengthImpl;
import com.intellij.database.types.DasBuiltinTypeWithLengthUnits;
import com.intellij.database.types.DasBuiltinTypeWithLengthUnitsImpl;
import com.intellij.database.types.DasBuiltinTypeWithPrecision;
import com.intellij.database.types.DasBuiltinTypeWithPrecisionImpl;
import com.intellij.database.types.DasSimpleBuiltinType;
import com.intellij.database.types.DasSimpleBuiltinTypeClass;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeClass;
import com.intellij.database.types.DasTypeFacade;
import com.intellij.database.types.DasTypeReference;
import com.intellij.database.types.DasTypeReferenceBase;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.oracle.OraCanonicalSignature;
import com.intellij.sql.dialects.oracle.OraCanonicalType;
import com.intellij.sql.dialects.oracle.psi.OraCollectionTypeElementImpl;
import com.intellij.sql.dialects.oracle.psi.OraCreateTypeStatementImpl;
import com.intellij.sql.dialects.oracle.psi.OraRowPatternClause;
import com.intellij.sql.dialects.oracle.psi.OraRowPatternMeasuresClause;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeDefinitionImpl;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 P2\u00020\u0001:\u0001PB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0014\u0010\"\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010)\u001a\u0006\u0012\u0002\b\u00030*2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u001fH\u0016J\u0016\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u001aH\u0002J\u0018\u00106\u001a\u0002072\u0006\u00109\u001a\u00020:2\u0006\u00104\u001a\u000205H\u0002J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010=\u001a\u0002072\u0006\u0010>\u001a\u00020<H\u0002J\u0010\u0010?\u001a\u00020-2\u0006\u0010@\u001a\u00020<H\u0002J\u001c\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020C0B2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020-2\u0006\u0010G\u001a\u00020HH\u0014J&\u0010I\u001a\u00020\u001a2\b\u0010J\u001a\u0004\u0018\u00010K2\b\u0010L\u001a\u0004\u0018\u00010M2\b\u0010N\u001a\u0004\u0018\u00010OH\u0016R\u0018\u0010%\u001a\n '*\u0004\u0018\u00010&0&X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010(\u00a8\u0006Q"}, d2={"Lcom/intellij/database/dialects/oracle/types/OraTypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getIntType", "Lcom/intellij/database/types/DasBuiltinTypeWithLengthImpl;", "getRealType", "Lcom/intellij/database/types/DasBuiltinTypeWithPrecisionImpl;", "getBooleanType", "Lcom/intellij/database/types/DasSimpleBuiltinType;", "getDateType", "getTimestampType", "Lcom/intellij/database/dialects/oracle/types/OraTimeAwareType;", "getStringType", "Lcom/intellij/database/types/DasBuiltinTypeWithLengthUnitsImpl;", "getNormalizedTypeName", "", "name", "getDefaultTypeName", "cat", "Lcom/intellij/database/types/DasTypeCategory;", "getTypeCategoryByName", "typeName", "getSelfDasType", "Lcom/intellij/database/types/DasType;", "element", "Lcom/intellij/database/model/basic/BasicUserDefinedType;", "createDasType", "dataType", "Lcom/intellij/database/model/DataType;", "createTypeReference", "Lcom/intellij/database/types/DasTypeReference;", "adjustCasing", "createPredefinedType", "parsePredefinedType", "NUMBER_REGEX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "adjustBuiltinType", "Lcom/intellij/database/types/DasBuiltinType;", "builtinType", "supportsImplicitConversion", "", "fromType", "toType", "getCanonicalSignature", "Lcom/intellij/sql/dialects/oracle/OraCanonicalSignature;", "routine", "Lcom/intellij/database/model/DasRoutine;", "project", "Lcom/intellij/openapi/project/Project;", "getCanonicalType", "Lcom/intellij/sql/dialects/oracle/OraCanonicalType;", "dasType", "argument", "Lcom/intellij/database/model/DasArgument;", "getTypeDefinition", "Lcom/intellij/database/model/DasUserDefinedType;", "computeCanonicalType", "typeDefinition", "isCollectionType", "type", "getDeprecatedTypes", "", "Lcom/intellij/database/types/DasTypeSystemBase$DeprecatedTypeInfo;", "contextFile", "Lcom/intellij/psi/PsiFile;", "supportsAsteriskArgument", "definition", "Lcom/intellij/sql/dialects/BuiltinFunction;", "getDasType", "ref", "Lcom/intellij/sql/psi/SqlReference;", "resolved", "Lcom/intellij/psi/PsiElement;", "symbol", "Lcom/intellij/database/symbols/DasSymbol;", "Companion", "intellij.database.dialects.oracle"})
@SourceDebugExtension(value={"SMAP\nOraTypeSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraTypeSystem.kt\ncom/intellij/database/dialects/oracle/types/OraTypeSystem\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,653:1\n436#2:654\n66#2,2:655\n436#2:657\n1230#3,4:658\n*S KotlinDebug\n*F\n+ 1 OraTypeSystem.kt\ncom/intellij/database/dialects/oracle/types/OraTypeSystem\n*L\n532#1:654\n535#1:655,2\n537#1:657\n222#1:658,4\n*E\n"})
public final class OraTypeSystem
extends DasTypeSystemImpl {
    @NotNull
    public static final Companion Companion;
    private final Pattern NUMBER_REGEX;
    @JvmField
    @NotNull
    public static final DasBuiltinTypeWithLengthImpl INTEGER;
    @JvmField
    @NotNull
    public static final DasBuiltinTypeWithLengthImpl FLOAT;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType BOOLEAN;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType DATE;
    @JvmField
    @NotNull
    public static final OraTimeAwareType TIME;
    @JvmField
    @NotNull
    public static final OraTimeAwareType TIMESTAMP;
    @JvmField
    @NotNull
    public static final DasBuiltinType<DasBuiltinTypeClassWithSuffix> TIMESTAMP_WITH_TIME_ZONE;
    @JvmField
    @NotNull
    public static final DasBuiltinType<DasBuiltinTypeClassWithSuffix> TIMESTAMP_WITH_LOCAL_TIME_ZONE;
    @JvmField
    @NotNull
    public static final OraIntervalType.YearToMonth INTERVAL_YEAR_TO_MONTH;
    @JvmField
    @NotNull
    public static final OraIntervalType.DayToSecond INTERVAL_DAY_TO_SECOND;
    @JvmField
    @NotNull
    public static final DasBuiltinTypeWithPrecisionImpl NUMBER;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType BINARY_FLOAT;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType BINARY_DOUBLE;
    @JvmField
    @NotNull
    public static final DasBuiltinTypeWithLengthUnitsImpl CHAR;
    @JvmField
    @NotNull
    public static final DasBuiltinTypeWithLengthUnitsImpl NCHAR;
    @JvmField
    @NotNull
    public static final DasBuiltinTypeWithLengthUnitsImpl VARCHAR2;
    @JvmField
    @NotNull
    public static final DasBuiltinType<DasSimpleBuiltinTypeClass> VARCHAR;
    @JvmField
    @NotNull
    public static final DasBuiltinTypeWithLengthImpl NVARCHAR2;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType LONG_VARCHAR;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType NATURAL;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType NATURALN;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType POSITIVE;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType POSITIVEN;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType SIGNTYPE;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType BINARY_INTEGER;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType SIMPLE_INTEGER;
    @JvmField
    @NotNull
    public static final OraRefCursorType SYS_REFCURSOR;
    @JvmField
    @NotNull
    public static final Map<String, DasType> predefinedTypes;
    @JvmField
    @NotNull
    public static final Set<String> predefinedSysTypeNames;
    @JvmField
    @NotNull
    public static final Map<String, String> extraPredefinedTypeSchemas;

    public OraTypeSystem(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        this.NUMBER_REGEX = Pattern.compile("\\d+");
    }

    @Override
    @NotNull
    public DasBuiltinTypeWithLengthImpl getIntType() {
        return INTEGER;
    }

    @Override
    @NotNull
    public DasBuiltinTypeWithPrecisionImpl getRealType() {
        return NUMBER;
    }

    @Override
    @NotNull
    public DasSimpleBuiltinType getBooleanType() {
        return BOOLEAN;
    }

    @Override
    @NotNull
    public DasSimpleBuiltinType getDateType() {
        return DATE;
    }

    @Override
    @NotNull
    public OraTimeAwareType getTimestampType() {
        return TIMESTAMP;
    }

    @Override
    @NotNull
    public DasBuiltinTypeWithLengthUnitsImpl getStringType() {
        return VARCHAR2;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return switch (super.getNormalizedTypeName(name2)) {
            case "LONG VARCHAR" -> "LONG";
            case "NUMERIC" -> "NUMBER";
            case "DECIMAL" -> "NUMBER";
            case "DEC" -> "NUMBER";
            case "INTEGER" -> "NUMBER";
            case "INT" -> "NUMBER";
            case "SMALLINT" -> "NUMBER";
            case "DOUBLE PRECISION" -> "FLOAT";
            case "REAL" -> "FLOAT";
            default -> {
                void var2_2;
                yield var2_2;
            }
        };
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull DasTypeCategory cat) {
        Intrinsics.checkNotNullParameter((Object)((Object)cat), (String)"cat");
        return switch (WhenMappings.$EnumSwitchMapping$0[cat.ordinal()]) {
            case 1 -> "number";
            case 2 -> "float";
            case 3 -> "varchar";
            case 4 -> "boolean";
            case 5 -> "timestamp";
            case 6 -> "date";
            case 7 -> "timestamp";
            case 8 -> "timestamp";
            case 9 -> "interval";
            case 10 -> "blob";
            default -> null;
        };
    }

    @Override
    @NotNull
    public DasTypeCategory getTypeCategoryByName(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return switch (typeName) {
            case "BINARY_FLOAT" -> DasTypeCategory.REAL;
            case "BINARY_DOUBLE" -> DasTypeCategory.REAL;
            case "LONG" -> DasTypeCategory.STRING;
            case "LONG RAW" -> DasTypeCategory.BYTES;
            case "BFILE" -> DasTypeCategory.BYTES;
            case "ROWID" -> DasTypeCategory.INTEGER;
            case "UROWID" -> DasTypeCategory.INTEGER;
            default -> super.getTypeCategoryByName(typeName);
        };
    }

    @Override
    @NotNull
    public DasType getSelfDasType(@NotNull BasicUserDefinedType element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof OraAliasType) {
            return DasTypeUtilsKt.getCacheableDasType(element, (Function0<? extends DasType>)((Function0)() -> OraTypeSystem.getSelfDasType$lambda$0(element)));
        }
        return super.getSelfDasType(element);
    }

    @Override
    @NotNull
    public DasType createDasType(@NotNull DataType dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        if (dataType.custom) {
            if (StringsKt.equals((String)"ref", (String)dataType.suffix, (boolean)true)) {
                DataType dataType2 = DataTypeFactory.dropSuffix(dataType);
                Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"dropSuffix(...)");
                return new OraRefType(this.createTypeReference(dataType2));
            }
            if (StringsKt.equals((String)"ref cursor", (String)dataType.suffix, (boolean)true)) {
                DataType dataType3 = DataTypeFactory.dropSuffix(dataType);
                Intrinsics.checkNotNullExpressionValue((Object)dataType3, (String)"dropSuffix(...)");
                return new OraRefCursorType(this.createTypeReference(dataType3));
            }
            return this.createTypeReference(dataType);
        }
        DasType dasType = this.createPredefinedType(dataType);
        if (dasType == null || (dasType = this.adjustCasing(dasType, dataType)) == null) {
            dasType = DasUnresolvedTypeReference.Companion.of(dataType);
        }
        return dasType;
    }

    private final DasTypeReference createTypeReference(DataType dataType) {
        return new DasTypeReferenceBase(dataType, this){
            final /* synthetic */ DataType $dataType;
            final /* synthetic */ OraTypeSystem this$0;
            {
                this.$dataType = $dataType;
                this.this$0 = $receiver;
                super($dataType);
            }

            public DasType resolve() {
                return this.resolve(null);
            }

            public DasType resolve(DasObject context) {
                return OraTypeSystem.access$adjustCasing(this.this$0, OraModelUtils.resolveTypeReference(this, context instanceof BasicElement ? (BasicElement)context : null), this.$dataType);
            }
        };
    }

    private final DasType adjustCasing(DasType $this$adjustCasing, DataType dataType) {
        if (!($this$adjustCasing instanceof DasBuiltinType)) {
            return $this$adjustCasing;
        }
        DasTypeClass dasTypeClass = ((DasBuiltinType)$this$adjustCasing).getTypeClass();
        Intrinsics.checkNotNullExpressionValue((Object)dasTypeClass, (String)"getTypeClass(...)");
        DasTypeClass typeClass = dasTypeClass;
        DasType dasType = $this$adjustCasing;
        if (StringsKt.equals((String)typeClass.getName(), (String)dataType.typeName, (boolean)true)) {
            DasBuiltinType dasBuiltinType = (DasBuiltinType)dasType;
            String string = dataType.typeName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName");
            dasType = DasTypeUtilsKt.withName(dasBuiltinType, string);
            String suffix = dataType.suffix;
            if (suffix != null && typeClass instanceof DasBuiltinTypeClassWithSuffix) {
                int p2 = StringsKt.indexOf$default((CharSequence)suffix, (char)'(', (int)0, (boolean)false, (int)6, null);
                if (p2 >= 0) {
                    String string2 = suffix.substring(0, p2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    suffix = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                }
                DasType dasType2 = dasType;
                Intrinsics.checkNotNull((Object)dasType2, (String)"null cannot be cast to non-null type com.intellij.database.types.DasBuiltinType<com.intellij.database.types.DasBuiltinTypeClassWithSuffix>");
                dasType = DasTypeUtilsKt.withSuffix((DasBuiltinType)dasType2, suffix);
            }
        }
        return dasType;
    }

    private final DasType createPredefinedType(DataType dataType) {
        DasType dasType = this.parsePredefinedType(dataType);
        if (!(dasType instanceof DasBuiltinType)) {
            return dasType;
        }
        return this.adjustBuiltinType((DasBuiltinType)dasType, dataType);
    }

    private final DasType parsePredefinedType(DataType dataType) {
        return predefinedTypes.get(StringUtil.toUpperCase((String)dataType.typeName));
    }

    private final DasBuiltinType<?> adjustBuiltinType(DasBuiltinType<?> builtinType, DataType dataType) {
        String suffix;
        int size = dataType.size;
        int scale = dataType.scale;
        LengthUnit lengthUnit = dataType.sizeUnit;
        Intrinsics.checkNotNullExpressionValue((Object)lengthUnit, (String)"sizeUnit");
        LengthUnit unit = lengthUnit;
        if (builtinType instanceof DasBuiltinTypeWithPrecision && (size != -1 || scale != 0)) {
            DasBuiltinTypeWithPrecision dasBuiltinTypeWithPrecision = ((DasBuiltinTypeWithPrecision)builtinType).copy(size, scale);
            Intrinsics.checkNotNullExpressionValue(dasBuiltinTypeWithPrecision, (String)"copy(...)");
            return dasBuiltinTypeWithPrecision;
        }
        if (builtinType instanceof DasBuiltinTypeWithLengthUnits && (size != -1 || !Intrinsics.areEqual((Object)unit, (Object)LengthUnit.NONE))) {
            DasBuiltinTypeWithLengthUnits dasBuiltinTypeWithLengthUnits = ((DasBuiltinTypeWithLengthUnits)builtinType).copy(size, unit, dataType.sizeUnitExplicit);
            Intrinsics.checkNotNullExpressionValue(dasBuiltinTypeWithLengthUnits, (String)"copy(...)");
            return dasBuiltinTypeWithLengthUnits;
        }
        if (builtinType instanceof DasBuiltinTypeWithLength && size != -1) {
            DasBuiltinTypeWithLength dasBuiltinTypeWithLength = ((DasBuiltinTypeWithLength)builtinType).copy(size);
            Intrinsics.checkNotNullExpressionValue(dasBuiltinTypeWithLength, (String)"copy(...)");
            return dasBuiltinTypeWithLength;
        }
        String string = StringUtil.toUpperCase((String)dataType.suffix);
        if (string == null) {
            string = suffix = "";
        }
        if (builtinType instanceof OraTimeAwareType && (size != -1 || StringUtil.isNotEmpty((String)dataType.suffix))) {
            OraTimeAwareType oraTimeAwareType = (OraTimeAwareType)builtinType;
            return oraTimeAwareType.copy(((OraTimeAwareType)builtinType).getTypeClass().withSuffix(suffix), size);
        }
        if (builtinType instanceof OraIntervalType.YearToMonth && size != -1) {
            return ((OraIntervalType.YearToMonth)builtinType).copy(size);
        }
        if (builtinType instanceof OraIntervalType.DayToSecond && (size != -1 || scale != 0)) {
            Matcher matcher;
            if (((CharSequence)suffix).length() > 0 && (matcher = this.NUMBER_REGEX.matcher(suffix)).find()) {
                int secondFraction = StringUtil.parseInt((String)matcher.group(), (int)0);
                return ((OraIntervalType.DayToSecond)builtinType).copy(size, secondFraction);
            }
            return ((OraIntervalType.DayToSecond)builtinType).copy(size, scale);
        }
        return builtinType;
    }

    @Override
    public boolean supportsImplicitConversion(@NotNull DataType fromType, @NotNull DataType toType) {
        Intrinsics.checkNotNullParameter((Object)fromType, (String)"fromType");
        Intrinsics.checkNotNullParameter((Object)toType, (String)"toType");
        if (fromType.equals(toType)) {
            return true;
        }
        Case plainCase = OraNamingService.INSTANCE.getDefaultCasing().plain;
        String fromTypeName = plainCase.apply(fromType.typeName);
        String toTypeName = plainCase.apply(toType.typeName);
        if (!OraTypeSystemKt.access$getPREDEFINED_FAMILY_ROOTS$p().containsKey(fromTypeName) || !OraTypeSystemKt.access$getPREDEFINED_FAMILY_ROOTS$p().containsKey(toTypeName)) {
            return true;
        }
        String fromRoot = (String)OraTypeSystemKt.access$getPREDEFINED_FAMILY_ROOTS$p().get(fromTypeName);
        String toRoot = (String)OraTypeSystemKt.access$getPREDEFINED_FAMILY_ROOTS$p().get(toTypeName);
        if (Intrinsics.areEqual((Object)toRoot, (Object)"CHAR")) {
            return !OraTypeSystemKt.access$getBLOB_TYPES$p().contains(fromTypeName);
        }
        if (Intrinsics.areEqual((Object)fromRoot, (Object)"CHAR")) {
            return !OraTypeSystemKt.access$getBLOB_TYPES$p().contains(toTypeName);
        }
        DasTypeCategory fromCategory = this.getTypeCategory(fromType);
        DasTypeCategory toCategory = this.getTypeCategory(toType);
        return switch (WhenMappings.$EnumSwitchMapping$0[fromCategory.ordinal()]) {
            case 1 -> {
                if (toCategory == fromCategory || toCategory == DasTypeCategory.REAL) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (toCategory == fromCategory || toCategory == DasTypeCategory.INTEGER) {
                    yield true;
                }
                yield false;
            }
            case 5, 8, 9 -> {
                if (toCategory == fromCategory || OraTypeSystemKt.access$getLONG_TYPES$p().contains(toTypeName)) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                if (toCategory == fromCategory) {
                    yield true;
                }
                yield false;
            }
            default -> {
                if (Intrinsics.areEqual((Object)fromTypeName, (Object)"RAW")) {
                    if (OraTypeSystemKt.access$getLONG_TYPES$p().contains(toTypeName) || OraTypeSystemKt.access$getBLOB_TYPES$p().contains(toTypeName)) {
                        yield true;
                    }
                    yield false;
                }
                if (OraTypeSystemKt.access$getBLOB_TYPES$p().contains(fromTypeName)) {
                    if (OraTypeSystemKt.access$getBLOB_TYPES$p().contains(toTypeName) || Intrinsics.areEqual((Object)toTypeName, (Object)"RAW")) {
                        yield true;
                    }
                    yield false;
                }
                if (OraTypeSystemKt.access$getLONG_TYPES$p().contains(fromTypeName)) {
                    if (OraTypeSystemKt.access$getCLOB_TYPES$p().contains(toTypeName) || Intrinsics.areEqual((Object)toTypeName, (Object)"RAW")) {
                        yield true;
                    }
                    yield false;
                }
                if (OraTypeSystemKt.access$getCLOB_TYPES$p().contains(fromTypeName)) {
                    if (OraTypeSystemKt.access$getLONG_TYPES$p().contains(toTypeName) || OraTypeSystemKt.access$getCLOB_TYPES$p().contains(toTypeName)) {
                        yield true;
                    }
                    yield false;
                }
                yield false;
            }
        };
    }

    @NotNull
    public final OraCanonicalSignature getCanonicalSignature(@NotNull DasRoutine routine2, @NotNull Project project) {
        DasObject dasParent;
        Intrinsics.checkNotNullParameter((Object)routine2, (String)"routine");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ObjectName name2 = new ObjectName(routine2.getName(), routine2.isQuoted());
        List list = DasUtil.getParameters(routine2).filterMap(arg_0 -> OraTypeSystem.getCanonicalSignature$lambda$2(arg_0 -> OraTypeSystem.getCanonicalSignature$lambda$1(this, project, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List parameterTypes = list;
        DasObject dasObject = dasParent = routine2.getDasParent();
        ObjectKind parentKind = dasObject != null ? dasObject.getKind() : null;
        boolean isHeader = routine2 instanceof SqlRoutineDefinition && ((SqlRoutineDefinition)routine2).getBody().isEmpty() || parentKind == ObjectKind.PACKAGE || parentKind == ObjectKind.OBJECT_TYPE;
        DasRoutine.Kind kind = routine2.getRoutineKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)kind), (String)"getRoutineKind(...)");
        return new OraCanonicalSignature(name2, kind, isHeader, parameterTypes);
    }

    private final OraCanonicalType getCanonicalType(DasType dasType) {
        String typeName = OraNamingService.INSTANCE.getDefaultCasing().plain.apply(DasTypeUtilsKt.getTypeName(dasType));
        String intrinsicRootName = (String)OraTypeSystemKt.access$getPREDEFINED_FAMILY_ROOTS$p().get(typeName);
        String string = intrinsicRootName;
        if (string == null) {
            String string2 = dasType.getSpecification();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSpecification(...)");
        }
        ObjectPath objectPath = ObjectPath.create(string, ObjectKind.OBJECT_TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"create(...)");
        ObjectPath path = objectPath;
        return new OraCanonicalType(path);
    }

    private final OraCanonicalType getCanonicalType(DasArgument argument, Project project) {
        DasUserDefinedType dasUserDefinedType = this.getTypeDefinition(argument);
        if (dasUserDefinedType == null) {
            DasType dasType = argument.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            return this.getCanonicalType(dasType);
        }
        DasUserDefinedType typeDefinition = dasUserDefinedType;
        Object v = ((ConcurrentMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> OraTypeSystem.getCanonicalType$lambda$4(this, project))).get(typeDefinition);
        Intrinsics.checkNotNull(v);
        return (OraCanonicalType)v;
    }

    private final DasUserDefinedType getTypeDefinition(DasArgument argument) {
        DasUserDefinedType dasUserDefinedType;
        if (argument instanceof SqlParameterDefinition) {
            SqlTypeElement sqlTypeElement = ((SqlParameterDefinition)argument).getTypeElement();
            if (sqlTypeElement == null) {
                return null;
            }
            SqlTypeElement typeElement = sqlTypeElement;
            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)typeElement), SqlReferenceExpression.class);
            if (sqlReferenceExpression == null) {
                return null;
            }
            SqlReferenceExpression typeRef = sqlReferenceExpression;
            PsiElement typeDefinition = typeRef.resolve();
            return typeDefinition instanceof DasUserDefinedType ? (DasUserDefinedType)typeDefinition : null;
        }
        if (argument instanceof BasicElement) {
            DasType dasType = ((DasTypedObject)argument).getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            dasUserDefinedType = OraModelUtils.resolveTypeDefinition(dasType, (BasicElement)((Object)argument));
        } else {
            dasUserDefinedType = null;
        }
        return dasUserDefinedType;
    }

    private final OraCanonicalType computeCanonicalType(DasUserDefinedType typeDefinition) {
        DasUserDefinedType type = typeDefinition;
        while (true) {
            if (this.isCollectionType(type) || Companion.isObjectType(type)) {
                ObjectPath objectPath = ObjectPaths.of(type);
                Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"of(...)");
                return new OraCanonicalType(objectPath);
            }
            DasUserDefinedType superType = type.getSuperType();
            if (superType == null) {
                OraCanonicalType oraCanonicalType;
                DasType dasType = type.getSuperDasType();
                if (dasType != null) {
                    dasType = DasTypeFacade.resolve(dasType, typeDefinition);
                }
                if (dasType == null || dasType instanceof DasTableType) {
                    ObjectPath objectPath = ObjectPaths.of(type);
                    Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"of(...)");
                    oraCanonicalType = new OraCanonicalType(objectPath);
                } else {
                    oraCanonicalType = this.getCanonicalType(dasType);
                }
                return oraCanonicalType;
            }
            type = superType;
        }
    }

    private final boolean isCollectionType(DasUserDefinedType type) {
        DasUserDefinedType typeDef = type;
        if (typeDef instanceof DbCustomType) {
            DasUserDefinedType dasUserDefinedType = type;
            Intrinsics.checkNotNull((Object)dasUserDefinedType, (String)"null cannot be cast to non-null type com.intellij.database.psi.DbCustomType");
            Object object = ((DbCustomType)dasUserDefinedType).getDelegate();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.database.model.DasUserDefinedType");
            typeDef = (DasUserDefinedType)object;
        }
        return typeDef instanceof OraCollectionType || typeDef instanceof SqlTypeDefinitionImpl && ((SqlTypeDefinitionImpl)((Object)typeDef)).getAliasedTypeElement() instanceof OraCollectionTypeElementImpl;
    }

    @Override
    @NotNull
    public Map<String, DasTypeSystemBase.DeprecatedTypeInfo> getDeprecatedTypes(@NotNull PsiFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        return OraTypeSystemKt.access$getDEPRECATED_TYPES$p();
    }

    @Override
    protected boolean supportsAsteriskArgument(@NotNull BuiltinFunction definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        return StringsKt.equals((String)definition.getName(), (String)"json_object", (boolean)true) || super.supportsAsteriskArgument(definition);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public DasType getDasType(@Nullable SqlReference ref, @Nullable PsiElement resolved, @Nullable DasSymbol symbol) {
        dasType = super.getDasType(ref, resolved, symbol);
        v0 = ref;
        var6_5 = (OraRowPatternClause)PsiTreeUtil.getChildOfType((PsiElement)(v0 != null ? v0.getElement() : null), OraRowPatternClause.class);
        if (var6_5 == null) ** GOTO lbl-1000
        var8_6 = (PsiElement)var6_5;
        $i$f$childrenOfType = false;
        v1 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, OraRowPatternMeasuresClause.class);
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getChildrenOfTypeAsList(...)");
        var7_10 = v1;
        if (var7_10 != null) {
            v2 = var7_10;
        } else lbl-1000:
        // 2 sources

        {
            v2 = measureClauses = CollectionsKt.emptyList();
        }
        if (((Collection)measureClauses).isEmpty() == false) {
            v3 = dasType instanceof SqlTableType != false ? (SqlTableType)dasType : null;
            if (v3 == null) {
                v3 = tableType = SqlTableTypeBase.EMPTY_TABLE;
            }
            if ((v4 = ref) != null && (v4 = v4.getElement()) != null) {
                $this$parentOfType_u24default$iv = v4;
                withSelf$iv = false;
                $i$f$parentOfType = false;
                v5 = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, SqlQueryExpression.class, (boolean)true);
            } else {
                v5 = null;
            }
            query = v5;
            for (OraRowPatternMeasuresClause measureClause : measureClauses) {
                $this$childrenOfType$iv = (PsiElement)measureClause;
                $i$f$childrenOfType = false;
                v6 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, SqlColumnAliasDefinition.class);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getChildrenOfTypeAsList(...)");
                for (SqlColumnAliasDefinition alias : v6) {
                    tableType = tableType.add(SqlTableTypeBase.createType((PsiElement)alias, alias.getDasType(), alias.getName(), alias.isQuoted(), false, (PsiElement)query, null));
                }
            }
            var8_6 = tableType;
            Intrinsics.checkNotNull((Object)var8_6);
            return (DasType)var8_6;
        }
        return dasType;
    }

    private static final DasType getSelfDasType$lambda$0(BasicUserDefinedType $element) {
        DasType dasType;
        DasType dasType2 = ((OraAliasType)$element).getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getDasType(...)");
        DasType dasType3 = dasType2;
        if (!(dasType3 instanceof OraRecordType) && StringsKt.equals((String)DasTypeUtilsKt.getTypeName(dasType3), (String)"table", (boolean)true) && !dasType3.toDataType().custom) {
            JBIterable jBIterable = ((OraAliasType)$element).getDasChildren(ObjectKind.COLUMN).filter(DasTypedObject.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            dasType = new OraRecordType((Iterable)jBIterable);
        } else {
            dasType = dasType3;
        }
        DasType aliasedType = dasType;
        return new DasAliasDefinedType($element, aliasedType){
            final /* synthetic */ DasType $aliasedType;
            {
                this.$aliasedType = $aliasedType;
                super($element);
            }

            public DasType getInnerType() {
                return this.$aliasedType;
            }
        };
    }

    private static final OraCanonicalType getCanonicalSignature$lambda$1(OraTypeSystem this$0, Project $project, DasArgument argument) {
        DasArgument dasArgument = argument;
        Intrinsics.checkNotNull((Object)dasArgument);
        return this$0.getCanonicalType(dasArgument, $project);
    }

    private static final OraCanonicalType getCanonicalSignature$lambda$2(Function1 $tmp0, Object p0) {
        return (OraCanonicalType)$tmp0.invoke(p0);
    }

    private static final OraCanonicalType getCanonicalType$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        return (OraCanonicalType)$tmp0.invoke(p0);
    }

    private static final CachedValueProvider.Result getCanonicalType$lambda$4(OraTypeSystem this$0, Project $project) {
        Object[] objectArray = new Object[]{DbPsiFacade.getInstance($project), PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.create(arg_0 -> OraTypeSystem.getCanonicalType$lambda$4$lambda$3((Function1)new Function1<DasUserDefinedType, OraCanonicalType>((Object)this$0){

            public final OraCanonicalType invoke(DasUserDefinedType p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return OraTypeSystem.access$computeCanonicalType((OraTypeSystem)this.receiver, p0);
            }
        }, arg_0), ContainerUtil::createConcurrentSoftValueMap), (Object[])objectArray);
    }

    @JvmStatic
    public static final boolean isObjectType(@NotNull DasUserDefinedType type) {
        return Companion.isObjectType(type);
    }

    public static final /* synthetic */ DasType access$adjustCasing(OraTypeSystem $this, DasType $receiver, DataType dataType) {
        return $this.adjustCasing($receiver, dataType);
    }

    public static final /* synthetic */ OraCanonicalType access$computeCanonicalType(OraTypeSystem $this, DasUserDefinedType typeDefinition) {
        return $this.computeCanonicalType(typeDefinition);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv;
        Companion = new Companion(null);
        INTEGER = DasBuiltinTypeWithLengthImpl.Companion.of$default(DasBuiltinTypeWithLengthImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("INTEGER", DasTypeCategory.INTEGER), 0, 2, null);
        FLOAT = DasBuiltinTypeWithLengthImpl.Companion.of$default(DasBuiltinTypeWithLengthImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("FLOAT", DasTypeCategory.REAL), 0, 2, null);
        BOOLEAN = DasSimpleBuiltinType.Companion.of("BOOLEAN", DasTypeCategory.BOOLEAN);
        DATE = DasSimpleBuiltinType.Companion.of("DATE", DasTypeCategory.DATE);
        TIME = OraTimeAwareType.Companion.of$default(OraTimeAwareType.Companion, DasBuiltinTypeClassWithSuffix.Companion.of("TIME", "", DasTypeCategory.TIME), 0, 2, null);
        TIMESTAMP = OraTimeAwareType.Companion.of$default(OraTimeAwareType.Companion, DasBuiltinTypeClassWithSuffix.Companion.of("TIMESTAMP", "", DasTypeCategory.TIMESTAMP), 0, 2, null);
        TIMESTAMP_WITH_TIME_ZONE = DasTypeUtilsKt.withSuffix(TIMESTAMP, "WITH TIME ZONE");
        TIMESTAMP_WITH_LOCAL_TIME_ZONE = DasTypeUtilsKt.withSuffix(TIMESTAMP, "WITH LOCAL TIME ZONE");
        INTERVAL_YEAR_TO_MONTH = OraIntervalType.YearToMonth.Companion.of$default(OraIntervalType.YearToMonth.Companion, DasBuiltinTypeClassWithSuffix.Companion.of("INTERVAL YEAR", "TO MONTH", DasTypeCategory.INTERVAL), 0, 2, null);
        INTERVAL_DAY_TO_SECOND = OraIntervalType.DayToSecond.Companion.of$default(OraIntervalType.DayToSecond.Companion, DasBuiltinTypeClassWithSuffix.Companion.of("INTERVAL DAY", "TO SECOND", DasTypeCategory.INTERVAL), 0, 0, 6, null);
        NUMBER = DasBuiltinTypeWithPrecisionImpl.Companion.of$default(DasBuiltinTypeWithPrecisionImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("NUMBER", DasTypeCategory.REAL), 0, 0, 6, null);
        BINARY_FLOAT = DasSimpleBuiltinType.Companion.of("BINARY_FLOAT", DasTypeCategory.REAL);
        BINARY_DOUBLE = DasSimpleBuiltinType.Companion.of("BINARY_DOUBLE", DasTypeCategory.REAL);
        CHAR = DasBuiltinTypeWithLengthUnitsImpl.Companion.of$default(DasBuiltinTypeWithLengthUnitsImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("CHAR", DasTypeCategory.STRING), 0, null, false, 14, null);
        NCHAR = DasBuiltinTypeWithLengthUnitsImpl.Companion.of$default(DasBuiltinTypeWithLengthUnitsImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("NCHAR", DasTypeCategory.STRING), 0, null, false, 14, null);
        VARCHAR2 = DasBuiltinTypeWithLengthUnitsImpl.Companion.of$default(DasBuiltinTypeWithLengthUnitsImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("VARCHAR2", DasTypeCategory.STRING), 0, null, false, 14, null);
        VARCHAR = DasTypeUtilsKt.withName(VARCHAR2, "VARCHAR");
        NVARCHAR2 = DasBuiltinTypeWithLengthImpl.Companion.of$default(DasBuiltinTypeWithLengthImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("NVARCHAR2", DasTypeCategory.STRING), 0, 2, null);
        LONG_VARCHAR = DasSimpleBuiltinType.Companion.of("LONG VARCHAR", DasTypeCategory.STRING);
        NATURAL = DasSimpleBuiltinType.Companion.of("NATURAL", DasTypeCategory.INTEGER);
        NATURALN = DasSimpleBuiltinType.Companion.of("NATURALN", DasTypeCategory.INTEGER);
        POSITIVE = DasSimpleBuiltinType.Companion.of("POSITIVE", DasTypeCategory.INTEGER);
        POSITIVEN = DasSimpleBuiltinType.Companion.of("POSITIVEN", DasTypeCategory.INTEGER);
        SIGNTYPE = DasSimpleBuiltinType.Companion.of("SIGNTYPE", DasTypeCategory.INTEGER);
        BINARY_INTEGER = DasSimpleBuiltinType.Companion.of("BINARY_INTEGER", DasTypeCategory.INTEGER);
        SIMPLE_INTEGER = DasSimpleBuiltinType.Companion.of("SIMPLE_INTEGER", DasTypeCategory.INTEGER);
        SYS_REFCURSOR = new OraRefCursorType(DasTypeSystemBase.UNKNOWN);
        Object[] objectArray = new DasBuiltinType[]{DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "DATE_BASE", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "NUMBER_BASE", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "CHAR_BASE", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "BLOB_BASE", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "CLOB_BASE", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "BFILE_BASE", null, 2, null), NUMBER, DasTypeUtilsKt.withName(NUMBER, "DECIMAL"), DasTypeUtilsKt.withName(NUMBER, "NUMERIC"), DasTypeUtilsKt.withName(NUMBER, "DEC"), INTEGER, DasTypeUtilsKt.withName(INTEGER, "INT"), DasBuiltinTypeWithLengthImpl.Companion.of$default(DasBuiltinTypeWithLengthImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("SMALLINT", DasTypeCategory.INTEGER), 0, 2, null), FLOAT, DasSimpleBuiltinType.Companion.of("REAL", DasTypeCategory.REAL), DasSimpleBuiltinType.Companion.of("DOUBLE PRECISION", DasTypeCategory.REAL), BINARY_FLOAT, BINARY_DOUBLE, BINARY_INTEGER, DasTypeUtilsKt.withName(BINARY_INTEGER, "PLS_INTEGER"), SIMPLE_INTEGER, NATURAL, NATURALN, POSITIVE, POSITIVEN, SIGNTYPE, BOOLEAN, DATE, TIME, TIMESTAMP, INTERVAL_YEAR_TO_MONTH, INTERVAL_DAY_TO_SECOND, CHAR, DasTypeUtilsKt.withName(CHAR, "CHARACTER"), NCHAR, DasTypeUtilsKt.withName(NCHAR, "NATIONAL CHARACTER"), DasTypeUtilsKt.withName(NCHAR, "NATIONAL CHAR"), VARCHAR, VARCHAR2, DasTypeUtilsKt.withName(VARCHAR2, "CHAR VARYING"), DasTypeUtilsKt.withName(VARCHAR2, "CHARACTER VARYING"), NVARCHAR2, DasTypeUtilsKt.withName(NVARCHAR2, "NCHAR VARYING"), DasTypeUtilsKt.withName(NVARCHAR2, "NATIONAL CHAR VARYING"), DasTypeUtilsKt.withName(NVARCHAR2, "NATIONAL CHARACTER VARYING"), DasBuiltinTypeWithLengthImpl.Companion.of$default(DasBuiltinTypeWithLengthImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("STRING", DasTypeCategory.STRING), 0, 2, null), LONG_VARCHAR, DasTypeUtilsKt.withName(LONG_VARCHAR, "LONG"), DasSimpleBuiltinType.Companion.of("CLOB", DasTypeCategory.STRING), DasBuiltinTypeWithLengthImpl.Companion.of$default(DasBuiltinTypeWithLengthImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("NCLOB", DasTypeCategory.STRING), 0, 2, null), DasSimpleBuiltinType.Companion.of("BLOB", DasTypeCategory.BYTES), DasBuiltinTypeWithLengthImpl.Companion.of$default(DasBuiltinTypeWithLengthImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("RAW", DasTypeCategory.BYTES), 0, 2, null), DasSimpleBuiltinType.Companion.of("LONG RAW", DasTypeCategory.BYTES), DasSimpleBuiltinType.Companion.of("BFILE", DasTypeCategory.BYTES), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "ROWID", null, 2, null), DasBuiltinTypeWithLengthImpl.Companion.of$default(DasBuiltinTypeWithLengthImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of$default(DasSimpleBuiltinTypeClass.Companion, "UROWID", null, 2, null), 0, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "XMLTYPE", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "URITYPE", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "HTTPURITYPE", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "XDBURITYPE", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "DBURITYPE", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "SDO_GEOMETRY", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "SDO_TOPO_GEOMETRY", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "SDO_GEORASTER", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "ORDAUDIO", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "ORDIMAGE", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "ORDVIDEO", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "ORDDOC", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "ORDDICOM", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "SI_STILLIMAGE", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "SI_AVERAGECOLOR", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "SI_POSITIONALCOLOR", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "SI_COLORHISTOGRAM", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "SI_TEXTURE", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "SI_FEATURELIST", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "SI_COLOR", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "EXPRESSION", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "ANYDATASET", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "ANYTYPE", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "ANYDATA", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "XMLTYPE", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "MLSLABEL", null, 2, null)};
        objectArray = CollectionsKt.listOf((Object[])objectArray);
        Map destination$iv = new HashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            void it;
            DasBuiltinType dasBuiltinType = (DasBuiltinType)element$iv;
            Map map2 = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.database.types.DasType");
            map2.put(((DasType)it).getTypeClass().getName(), element$iv);
        }
        objectArray = destination$iv;
        HashMap it = (HashMap)objectArray;
        boolean bl = false;
        ((Map)it).put("SYS_REFCURSOR", SYS_REFCURSOR);
        ((Map)it).put("REF CURSOR", SYS_REFCURSOR);
        predefinedTypes = objectArray;
        objectArray = new String[]{"XMLTYPE", "URITYPE", "HTTPURITYPE", "XDBURITYPE", "DBURITYPE"};
        predefinedSysTypeNames = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"SDO_GEOMETRY", (Object)"MDSYS"), TuplesKt.to((Object)"SDO_TOPO_GEOMETRY", (Object)"MDSYS"), TuplesKt.to((Object)"SDO_GEORASTER", (Object)"MDSYS"), TuplesKt.to((Object)"ORDAUDIO", (Object)"ORDSYS"), TuplesKt.to((Object)"ORDIMAGE", (Object)"ORDSYS"), TuplesKt.to((Object)"ORDVIDEO", (Object)"ORDSYS"), TuplesKt.to((Object)"ORDDOC", (Object)"ORDSYS"), TuplesKt.to((Object)"ORDDICOM", (Object)"ORDSYS"), TuplesKt.to((Object)"SI_STILLIMAGE", (Object)"ORDSYS"), TuplesKt.to((Object)"SI_AVERAGECOLOR", (Object)"ORDSYS"), TuplesKt.to((Object)"SI_POSITIONALCOLOR", (Object)"ORDSYS"), TuplesKt.to((Object)"SI_COLORHISTOGRAM", (Object)"ORDSYS"), TuplesKt.to((Object)"SI_TEXTURE", (Object)"ORDSYS"), TuplesKt.to((Object)"SI_FEATURELIST", (Object)"ORDSYS"), TuplesKt.to((Object)"SI_COLOR", (Object)"ORDSYS")};
        extraPredefinedTypeSchemas = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001a8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001a8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u001a8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e0\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u00020*8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0,8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020-008\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00101\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-0,8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/database/dialects/oracle/types/OraTypeSystem$Companion;", "", "<init>", "()V", "INTEGER", "Lcom/intellij/database/types/DasBuiltinTypeWithLengthImpl;", "FLOAT", "BOOLEAN", "Lcom/intellij/database/types/DasSimpleBuiltinType;", "DATE", "TIME", "Lcom/intellij/database/dialects/oracle/types/OraTimeAwareType;", "TIMESTAMP", "TIMESTAMP_WITH_TIME_ZONE", "Lcom/intellij/database/types/DasBuiltinType;", "Lcom/intellij/database/types/DasBuiltinTypeClassWithSuffix;", "TIMESTAMP_WITH_LOCAL_TIME_ZONE", "INTERVAL_YEAR_TO_MONTH", "Lcom/intellij/database/dialects/oracle/types/OraIntervalType$YearToMonth;", "INTERVAL_DAY_TO_SECOND", "Lcom/intellij/database/dialects/oracle/types/OraIntervalType$DayToSecond;", "NUMBER", "Lcom/intellij/database/types/DasBuiltinTypeWithPrecisionImpl;", "BINARY_FLOAT", "BINARY_DOUBLE", "CHAR", "Lcom/intellij/database/types/DasBuiltinTypeWithLengthUnitsImpl;", "NCHAR", "VARCHAR2", "VARCHAR", "Lcom/intellij/database/types/DasSimpleBuiltinTypeClass;", "kotlin.jvm.PlatformType", "NVARCHAR2", "LONG_VARCHAR", "NATURAL", "NATURALN", "POSITIVE", "POSITIVEN", "SIGNTYPE", "BINARY_INTEGER", "SIMPLE_INTEGER", "SYS_REFCURSOR", "Lcom/intellij/database/dialects/oracle/types/OraRefCursorType;", "predefinedTypes", "", "", "Lcom/intellij/database/types/DasType;", "predefinedSysTypeNames", "", "extraPredefinedTypeSchemas", "isObjectType", "", "type", "Lcom/intellij/database/model/DasUserDefinedType;", "intellij.database.dialects.oracle"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isObjectType(@NotNull DasUserDefinedType type) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            DasUserDefinedType typeDef = type;
            if (typeDef instanceof DbCustomType) {
                Object object = ((DbCustomType)type).getDelegate();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.database.model.DasUserDefinedType");
                typeDef = (DasUserDefinedType)object;
            }
            if (typeDef instanceof OraObjectType) {
                bl = true;
            } else {
                DasUserDefinedType dasUserDefinedType = typeDef;
                OraCreateTypeStatementImpl oraCreateTypeStatementImpl = dasUserDefinedType instanceof OraCreateTypeStatementImpl ? (OraCreateTypeStatementImpl)((Object)dasUserDefinedType) : null;
                bl = oraCreateTypeStatementImpl != null ? oraCreateTypeStatementImpl.isObject() : false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasTypeCategory.values().length];
            try {
                nArray[DasTypeCategory.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.REAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BOOLEAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE_TIME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIMESTAMP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.INTERVAL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BYTES.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

