/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.model.properties;

import com.intellij.database.dialects.postgresbase.model.properties.PgCastContext;
import com.intellij.database.dialects.postgresbase.model.properties.PgCastMethod;
import com.intellij.database.dialects.postgresbase.model.properties.PgDataTypeSubKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgDateInputStyle;
import com.intellij.database.dialects.postgresbase.model.properties.PgObjectGrant;
import com.intellij.database.dialects.postgresbase.model.properties.PgObjectGrantController;
import com.intellij.database.dialects.postgresbase.model.properties.PgOperatorKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgRoutineKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgTimeZone;
import com.intellij.database.dialects.postgresbase.model.properties.PgVolatilityKind;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.openapi.util.text.StringUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PgBasePropertyConverter
extends PropertyConverter {
    public static final BasicMetaType<Grants<PgObjectGrant>> T_GRANTS_PG_OBJECT_GRANT = BasicMetaType.createGrantsType(PgBasePropertyConverter::importGrantsPgObjectGrant, PropertyConverter::export);
    public static final BasicMetaType.EnumMetaType<PgDataTypeSubKind> T_PG_DATA_TYPE_SUB_KIND = BasicMetaType.createEnumType(PgDataTypeSubKind.class, PgBasePropertyConverter::importPgDataTypeSubKind, PropertyConverter::export);
    public static final BasicMetaType.EnumMetaType<PgOperatorKind> T_PG_OPERATOR_KIND = BasicMetaType.createEnumType(PgOperatorKind.class, PgBasePropertyConverter::importPgOperatorKind, PropertyConverter::export);
    public static final BasicMetaType.EnumMetaType<PgDateInputStyle> T_PG_DATE_INPUT_STYLE = BasicMetaType.createEnumType(PgDateInputStyle.class, PgBasePropertyConverter::importPgDateInputStyle, PropertyConverter::export);
    public static final BasicMetaType.EnumMetaType<PgRoutineKind> T_PG_ROUTINE_KIND = BasicMetaType.createEnumType(PgRoutineKind.class, PgBasePropertyConverter::importPgRoutineKind, PgBasePropertyConverter::exportPgRoutineKind);
    public static final BasicMetaType.EnumMetaType<PgVolatilityKind> T_PG_VOLATILITY_KIND = BasicMetaType.createEnumType(PgVolatilityKind.class, PgBasePropertyConverter::importPgVolatilityKind, PropertyConverter::export);
    public static final BasicMetaType<PgTimeZone> T_PG_TIME_ZONE = BasicMetaType.createType(PgTimeZone.class, PgBasePropertyConverter::importPgTimeZone, PgBasePropertyConverter::export);
    public static final BasicMetaType<Map<String, PgTimeZone>> T_MAP_OF_STRING_PG_TIME_ZONE = new BasicMetaType.MapMetaType<String, PgTimeZone>(T_STRING, T_PG_TIME_ZONE, PgBasePropertyConverter::importMapOfStringPgTimeZone, PgBasePropertyConverter::exportMapOfStringPgTimeZone);
    public static final BasicMetaType.EnumMetaType<PgCastMethod> T_PG_CAST_METHOD = BasicMetaType.createEnumType(PgCastMethod.class, PgBasePropertyConverter::importPgCastMethod, PropertyConverter::export);
    public static final BasicMetaType.EnumMetaType<PgCastContext> T_PG_CAST_CONTEXT = BasicMetaType.createEnumType(PgCastContext.class, PgBasePropertyConverter::importPgCastContext, PropertyConverter::export);

    public static String exportPgRoutineKind(@NotNull PgRoutineKind routineKind) {
        if (routineKind == null) {
            PgBasePropertyConverter.$$$reportNull$$$0(0);
        }
        return routineKind.exportValue();
    }

    @Nullable
    public static PgRoutineKind importPgRoutineKind(String text2) {
        return PgRoutineKind.importValue(text2);
    }

    public static PgOperatorKind importPgOperatorKind(String text2) {
        return PropertyConverter.importEnum(PgOperatorKind.class, text2);
    }

    public static PgDataTypeSubKind importPgDataTypeSubKind(String text2) {
        return PropertyConverter.importEnum(PgDataTypeSubKind.class, text2);
    }

    public static PgDateInputStyle importPgDateInputStyle(String text2) {
        return PropertyConverter.importEnum(PgDateInputStyle.class, text2);
    }

    @Nullable
    public static PgVolatilityKind importPgVolatilityKind(String kind) {
        return PropertyConverter.importEnum(PgVolatilityKind.class, kind);
    }

    public static String exportMapOfStringPgTimeZone(Map<String, PgTimeZone> timeZones) {
        StringBuilder sb = new StringBuilder();
        for (PgTimeZone timeZone : timeZones.values()) {
            sb.append(timeZone.export()).append("\n");
        }
        return sb.toString();
    }

    public static String export(PgTimeZone timeZone) {
        return timeZone == null ? null : timeZone.export();
    }

    @NotNull
    public static Map<String, PgTimeZone> importMapOfStringPgTimeZone(String text2) {
        String[] lines;
        LinkedHashMap<String, PgTimeZone> timeZones = new LinkedHashMap<String, PgTimeZone>();
        for (String line : lines = StringUtil.splitByLines((String)text2)) {
            PgTimeZone timeZone = PgTimeZone.read(line);
            timeZones.put(StringUtil.toLowerCase((String)timeZone.getName()), timeZone);
        }
        LinkedHashMap<String, PgTimeZone> linkedHashMap = timeZones;
        if (linkedHashMap == null) {
            PgBasePropertyConverter.$$$reportNull$$$0(1);
        }
        return linkedHashMap;
    }

    @Nullable
    public static PgTimeZone importPgTimeZone(String text2) {
        return text2 == null ? null : PgTimeZone.read(text2);
    }

    public static Grants<PgObjectGrant> importGrantsPgObjectGrant(String text2) {
        return new Grants<PgObjectGrant>(PgObjectGrantController.INSTANCE, text2);
    }

    public static PgCastMethod importPgCastMethod(String text2) {
        return PropertyConverter.importEnum(PgCastMethod.class, text2);
    }

    public static PgCastContext importPgCastContext(String text2) {
        return PropertyConverter.importEnum(PgCastContext.class, text2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routineKind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgresbase/model/properties/PgBasePropertyConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgresbase/model/properties/PgBasePropertyConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "importMapOfStringPgTimeZone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "exportPgRoutineKind";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

