/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite.plan;

import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.sqlite.plan.SqliteRawPlanData;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlitePlanModelBuilder
extends AbstractPlanModelBuilder<SqliteRawPlanData, MetaNode> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING = new HashMap<String, PlanModel.NodeType>();
    public final Int2ObjectMap<MetaNode> myStructure = new Int2ObjectOpenHashMap();
    public int myMaxId = 0;

    public SqlitePlanModelBuilder() {
        super(EnumSet.of(PlanModel.Feature.TOTAL_COST, PlanModel.Feature.STARTUP_COST, PlanModel.Feature.NUM_ROWS));
    }

    @Override
    @NotNull
    public SqliteRawPlanData createData() {
        return new SqliteRawPlanData();
    }

    @Override
    protected void parseData() {
        this.parseStructure();
        this.cacheNodes();
        this.openNode(null);
        MetaNode root = (MetaNode)this.myStructure.get(0);
        this.parseStatement(root);
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
    }

    private void cacheNodes() {
        this.openNode(null);
        this.myStructure.values().forEach(it -> this.parseSubPlans((MetaNode)it));
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        this.resetRoot();
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(0);
        }
        return "";
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(3);
        }
        return null;
    }

    @NotNull
    private PlanModel.GenericNode buildConstantScanNode(@NotNull ListIterator<String> tok2) {
        if (tok2 == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(4);
        }
        if (!SqlitePlanModelBuilder.checkOrRecover(tok2, "ROW")) {
            this.consumeToken(tok2, "ROWS");
        }
        PlanModel.GenericNode genericNode = this.createNode(null, PlanModel.NodeType.VALUE, "CONSTANT ROWS");
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(5);
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericAccessNode buildTableScanNode(@NotNull ListIterator<String> tok2) {
        PlanModel.GenericAccessNode res2;
        if (tok2 == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(6);
        }
        String tableName = tok2.next();
        if (SqlitePlanModelBuilder.checkOrRecover(tok2, "AS")) {
            tok2.next();
        }
        if (SqlitePlanModelBuilder.checkOrRecover(tok2, "USING")) {
            PlanModel.IndexScanNode node = (PlanModel.IndexScanNode)this.createNode(null, PlanModel.NodeType.INDEX_SCAN, null);
            res2 = node;
            if (SqlitePlanModelBuilder.checkOrRecover(tok2, "INTEGER")) {
                this.consumeTokens(tok2, "PRIMARY", "KEY");
            } else if (SqlitePlanModelBuilder.checkOrRecover(tok2, "PRIMARY")) {
                this.consumeTokens(tok2, "KEY");
            } else {
                String token = tok2.next();
                if ("AUTOMATIC".equals(token)) {
                    token = tok2.next();
                }
                if ("COVERING".equals(token)) {
                    token = tok2.next();
                }
                this.checkToken(token, "INDEX");
                String indexName = tok2.next();
                node.setIndex(indexName);
            }
            if (SqlitePlanModelBuilder.checkPrefSufAndRecover(tok2, "(", "=?)")) {
                tok2.next();
            }
        } else {
            res2 = (PlanModel.GenericAccessNode)this.createNode(null, PlanModel.NodeType.SEQ_SCAN, null);
        }
        res2.setRelation(tableName);
        PlanModel.GenericAccessNode genericAccessNode = res2;
        if (genericAccessNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(7);
        }
        return genericAccessNode;
    }

    @NotNull
    private PlanModel.GenericNode buildScanNode(@NotNull ListIterator<String> tok2) {
        String token;
        if (tok2 == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(8);
        }
        if (ObjectPaths.isNumber(token = tok2.next())) {
            this.consumeToken(tok2, "CONSTANT");
            return this.buildConstantScanNode(tok2);
        }
        if (token.equals("CONSTANT")) {
            return this.buildConstantScanNode(tok2);
        }
        if (token.equals("TABLE")) {
            return this.buildTableScanNode(tok2);
        }
        if (!token.equals("SUBQUERY")) {
            tok2.previous();
            return this.buildTableScanNode(tok2);
        }
        this.checkToken("SUBQUERY", token);
        return this.buildSubqueryScanNode(tok2);
    }

    @NotNull
    private PlanModel.GenericNode buildSubqueryScanNode(@NotNull ListIterator<String> tok2) {
        if (tok2 == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(9);
        }
        if (!((SqliteRawPlanData)this.myData).newFmt) {
            this.parseSubquery(Integer.parseInt(tok2.next()), true);
        }
        PlanModel.GenericNode genericNode = this.createNode(null, PlanModel.NodeType.SUBQUERY, null);
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(10);
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericNode buildNode(@NotNull MetaNode state, @NotNull ListIterator<String> tok2) {
        PlanModel.GenericNode genericNode;
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(11);
        }
        if (tok2 == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(12);
        }
        try {
            PlanModel.GenericNode node;
            String token = tok2.next();
            if ("SCAN".equals(token) || "SEARCH".equals(token)) {
                node = this.buildScanNode(tok2);
            } else if ("EXECUTE".equals(token) || "LEFT-MOST".equals(token)) {
                node = this.buildSubqueryNode(tok2);
            } else if (((SqliteRawPlanData)this.myData).newFmt && ("CORRELATED".equals(token) || "SCALAR".equals(token) || "LIST".equals(token) || "SUBQUERY".equals(token))) {
                tok2.previous();
                node = this.buildSubqueryNode(tok2);
            } else if ("COMPOUND".equals(token)) {
                node = this.buildCompoundNode(tok2);
            } else if ("USE".equals(token)) {
                node = this.buildUseNode(tok2);
            } else {
                PlanRow row = state.rowId == -1 ? null : ((SqliteRawPlanData)this.myData).rows.get(state.rowId);
                PlanModel.GenericNode genericNode2 = node = ((SqliteRawPlanData)this.myData).newFmt && row != null ? this.buildOperationNode(row.detail) : this.createNode(null, PlanModel.NodeType.UNKNOWN, null);
            }
            if (SqlitePlanModelBuilder.checkPrefSufAndRecover(tok2, "(~", null)) {
                node.setPlanNumRows(new BigDecimal(tok2.next().substring(2)));
                this.consumeToken(tok2, "rows)");
            }
            genericNode = node;
        }
        catch (NumberFormatException | NoSuchElementException e) {
            this.unsupportedFormat(e, null);
            PlanModel.GenericNode genericNode3 = this.createNode(null, PlanModel.NodeType.UNKNOWN, null);
            if (genericNode3 == null) {
                SqlitePlanModelBuilder.$$$reportNull$$$0(14);
            }
            return genericNode3;
        }
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(13);
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericNode buildNewCompoundNode(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(15);
        }
        return this.buildNewCompoundChildNode(state, state.children.size() - 1);
    }

    @NotNull
    private PlanModel.GenericNode buildNewCompoundChildNode(@NotNull MetaNode compound, int idx) {
        if (compound == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(16);
        }
        MetaNode node = compound.children.get(idx);
        PlanModel.GenericNode res2 = this.buildNode(node);
        if (idx > 1) {
            this.addLazyNode(() -> this.buildNewCompoundChildNode(compound, idx - 1), false);
        } else {
            this.buildNewCompoundOneChildNode(compound.children.get(0));
        }
        this.buildNewCompoundOneChildNode(node);
        PlanModel.GenericNode genericNode = res2;
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(17);
        }
        return genericNode;
    }

    private void buildNewCompoundOneChildNode(MetaNode node) {
        if (node.children.size() != 1) {
            this.unsupportedFormat("Expected one child, got " + node.children.size());
        }
        this.parsePlan(node.children.get(0));
    }

    @NotNull
    private PlanModel.GenericNode buildUseNode(@NotNull ListIterator<String> tok2) {
        if (tok2 == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(18);
        }
        this.consumeTokens(tok2, "TEMP", "B-TREE", "FOR");
        Object op = tok2.next();
        while (tok2.hasNext()) {
            op = (String)op + " " + tok2.next();
        }
        PlanModel.NodeType type = TYPE_MAPPING.get(op);
        if (type == null) {
            type = PlanModel.NodeType.TRANSFORM;
        }
        PlanModel.GenericNode genericNode = this.createNode(null, type, (String)(type == PlanModel.NodeType.TRANSFORM ? op : null));
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(19);
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericNode buildCompoundNode(@NotNull ListIterator<String> tok2) {
        PlanModel.NodeType type;
        if (tok2 == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(20);
        }
        this.consumeToken(tok2, "SUBQUERIES");
        this.parseSubquery(Integer.parseInt(tok2.next()), false);
        this.consumeToken(tok2, "AND");
        this.parseSubquery(Integer.parseInt(tok2.next()), false);
        if (SqlitePlanModelBuilder.checkOrRecover(tok2, "USING")) {
            this.consumeTokens(tok2, "TEMP", "B-TREE");
        }
        Object token = "";
        while (tok2.hasNext()) {
            token = (String)token + " " + tok2.next();
        }
        if (!((String)(token = ((String)token).trim())).startsWith("(") && ((String)token).endsWith(")")) {
            this.unsupportedFormat((String)token);
        }
        if ((type = TYPE_MAPPING.get(token = ((String)token).substring(1, ((String)token).length() - 1))) == null) {
            type = PlanModel.NodeType.SET_OP;
        }
        PlanModel.GenericNode genericNode = this.createNode(null, type, (String)(type == PlanModel.NodeType.SET_OP ? token : null));
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(21);
        }
        return genericNode;
    }

    private PlanModel.GenericNode buildSubqueryNode(@NotNull ListIterator<String> tok2) {
        if (tok2 == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(22);
        }
        boolean scalar = false;
        boolean correlated = false;
        if (SqlitePlanModelBuilder.checkOrRecover(tok2, "CORRELATED")) {
            correlated = true;
        }
        if (SqlitePlanModelBuilder.checkOrRecover(tok2, "SCALAR")) {
            scalar = true;
        }
        if (SqlitePlanModelBuilder.checkOrRecover(tok2, "LIST")) {
            // empty if block
        }
        this.consumeToken(tok2, "SUBQUERY");
        if (!((SqliteRawPlanData)this.myData).newFmt) {
            this.parseSubquery(Integer.parseInt(tok2.next()), false);
        }
        PlanModel.SubQueryNode res2 = (PlanModel.SubQueryNode)this.createNode(null, PlanModel.NodeType.SUBQUERY, null);
        res2.setCorrelated(correlated);
        res2.setScalar(scalar);
        return res2;
    }

    private PlanModel.GenericNode buildOperationNode(@NotNull String details) {
        int idx;
        String desc;
        PlanModel.NodeType op;
        if (details == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(23);
        }
        if ((op = TYPE_MAPPING.get(desc = (idx = details.indexOf("USING")) < 1 ? details : details.substring(0, idx - 1))) == null && (idx = details.indexOf(" ")) != -1) {
            desc = details.substring(0, idx);
            op = TYPE_MAPPING.get(desc);
        }
        return this.createNode(null, (PlanModel.NodeType)((Object)ObjectUtils.chooseNotNull((Object)((Object)op), (Object)((Object)PlanModel.NodeType.UNKNOWN))), op == null ? null : desc);
    }

    private static boolean checkOrRecover(@NotNull ListIterator<String> tok2, @NotNull String token) {
        if (tok2 == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(24);
        }
        if (token == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(25);
        }
        if (tok2.hasNext()) {
            if (tok2.next().equals(token)) {
                return true;
            }
            tok2.previous();
        }
        return false;
    }

    private static boolean checkPrefSufAndRecover(@NotNull ListIterator<String> tok2, @Nullable String prefix, @Nullable String suffix) {
        if (tok2 == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(26);
        }
        if (tok2.hasNext()) {
            String token = tok2.next();
            tok2.previous();
            if ((prefix == null || token.startsWith(prefix)) && (suffix == null || token.endsWith(suffix))) {
                return true;
            }
        }
        return false;
    }

    private void checkToken(@NotNull String current, @NotNull String token) {
        if (current == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(27);
        }
        if (token == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(28);
        }
        if (!token.equals(current)) {
            this.unsupportedFormat("unexpected " + current + " != " + token);
        }
    }

    private void consumeToken(@NotNull ListIterator<String> tok2, @NotNull String token) {
        if (tok2 == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(29);
        }
        if (token == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(30);
        }
        this.checkToken(tok2.next(), token);
    }

    private void consumeTokens(@NotNull ListIterator<String> tok2, String ... tokens) {
        if (tok2 == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(31);
        }
        if (tokens == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(32);
        }
        for (String s : tokens) {
            this.consumeToken(tok2, s);
        }
    }

    @Nullable
    private MetaNode removeSubquery(int id, boolean byteOverflow) {
        MetaNode node;
        MetaNode metaNode = node = id == 0 && byteOverflow ? null : (MetaNode)this.myStructure.get(id);
        if (byteOverflow) {
            while (node == null && id < this.myMaxId) {
                node = (MetaNode)this.myStructure.get(id += 256);
            }
        }
        return node != null ? (MetaNode)this.myStructure.remove(id) : null;
    }

    private void parseSubquery(int id, boolean byteOverflow) {
        MetaNode node = this.removeSubquery(id, byteOverflow);
        if (node == null) {
            node = new MetaNode(id, MetaNode.Type.DUMMY);
            node.children.add(new MetaNode(-1, MetaNode.Type.SIMPLE));
            this.myMaxId = Math.max(this.myMaxId, id);
        }
        this.parseSubPlans(node);
    }

    @Override
    protected void parsePlan(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(33);
        }
        assert (state.type != MetaNode.Type.DUMMY);
        this.addLazyNode(() -> {
            PlanModel.GenericNode node;
            if (state.cache != null) {
                return state.cache;
            }
            boolean compound = this.isCompound(state);
            if (compound) {
                node = this.buildNewCompoundNode(state);
            } else if (state.type == MetaNode.Type.NESTED) {
                node = this.createNode(state, PlanModel.NodeType.NESTED_LOOPS, null);
            } else if (state.type == MetaNode.Type.TEMP) {
                node = this.createNode(state, PlanModel.NodeType.TEMPORARY, null);
            } else if (state.type == MetaNode.Type.SIMPLE) {
                node = this.createNode(state, PlanModel.NodeType.VALUE, null);
            } else {
                assert (state.type == MetaNode.Type.ROW);
                node = this.buildNode(state);
            }
            if (!compound) {
                this.parseSubPlans(state);
            }
            state.cache = node;
            return node;
        }, this.isScan(state));
    }

    private boolean isCompound(@NotNull @NotNull @NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(34);
        }
        boolean compound = false;
        if (state.rowId != -1) {
            PlanRow row = ((SqliteRawPlanData)this.myData).rows.get(state.rowId);
            compound = row.detail.startsWith("COMPOUND");
        }
        return compound;
    }

    @NotNull
    private PlanModel.GenericNode buildNode(@NotNull MetaNode state) {
        PlanModel.GenericNode node;
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(35);
        }
        PlanRow curRow = ((SqliteRawPlanData)this.myData).rows.get(state.rowId);
        try {
            node = this.buildNode(state, Arrays.asList(curRow.detail.split(" ")).listIterator());
        }
        catch (PlanRetrievalException e) {
            throw new PlanRetrievalException("while building for" + curRow.detail, e);
        }
        node.setRawDescription(curRow.detail);
        PlanModel.GenericNode genericNode = node;
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(36);
        }
        return genericNode;
    }

    private boolean isScan(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(37);
        }
        if (state.type != MetaNode.Type.ROW) {
            return false;
        }
        PlanRow curRow = ((SqliteRawPlanData)this.myData).rows.get(state.rowId);
        return StringUtil.startsWithIgnoreCase((String)curRow.detail, (String)"SCAN") || StringUtil.startsWithIgnoreCase((String)curRow.detail, (String)"SEARCH");
    }

    @Override
    protected void parseSubPlans(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(38);
        }
        for (MetaNode child : state.children) {
            this.parsePlan(child);
        }
    }

    private void parseStructure() {
        if (!((SqliteRawPlanData)this.myData).rows.isEmpty()) {
            if (((SqliteRawPlanData)this.myData).newFmt) {
                for (int i2 = 0; i2 < ((SqliteRawPlanData)this.myData).rows.size(); ++i2) {
                    MetaNode node = new MetaNode(i2, MetaNode.Type.ROW);
                    this.myStructure.put(((SqliteRawPlanData)this.myData).rows.get((int)i2).subqueryId, (Object)node);
                }
                for (PlanRow row : ((SqliteRawPlanData)this.myData).rows) {
                    MetaNode parent = (MetaNode)this.myStructure.get(row.order);
                    if (parent == null) {
                        parent = new MetaNode(-1, MetaNode.Type.DUMMY);
                        this.myStructure.put(row.order, (Object)parent);
                    }
                    parent.children.add((MetaNode)this.myStructure.get(row.subqueryId));
                }
            } else {
                for (PlanRow row : ((SqliteRawPlanData)this.myData).rows) {
                    if (this.myStructure.containsKey(row.subqueryId)) continue;
                    MetaNode node = new MetaNode(-1, MetaNode.Type.DUMMY);
                    node.children.addAll(this.parseSubqueryStructure(row.subqueryId));
                    this.myStructure.put(row.subqueryId, (Object)node);
                    this.myMaxId = Math.max(this.myMaxId, row.subqueryId);
                }
            }
        } else {
            MetaNode value = new MetaNode(0, MetaNode.Type.DUMMY);
            value.children.add(new MetaNode(-1, MetaNode.Type.SIMPLE));
            this.myStructure.put(0, (Object)value);
        }
    }

    @NotNull
    private MetaNode expandStructure(@NotNull MetaNode node) {
        if (node == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(39);
        }
        if (node.type == MetaNode.Type.ROW && ((SqliteRawPlanData)this.myData).rows.get((int)node.rowId).detail.contains("TEMP B-TREE")) {
            boolean child = ((SqliteRawPlanData)this.myData).rows.get((int)node.rowId).detail.startsWith("USING");
            MetaNode temp = new MetaNode(-1, MetaNode.Type.TEMP);
            if (child) {
                temp.children.addAll(node.children);
                node.children.clear();
                node.children.add(temp);
            } else {
                temp.children.add(node);
                node = temp;
            }
        }
        MetaNode metaNode = node;
        if (metaNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(40);
        }
        return metaNode;
    }

    private List<MetaNode> parseSubqueryStructure(int id) {
        ArrayList<MetaNode> res2 = new ArrayList<MetaNode>();
        List<MetaNode> toPutScalarSubqueries = res2;
        for (int i2 = 0; i2 < ((SqliteRawPlanData)this.myData).rows.size(); ++i2) {
            if (((SqliteRawPlanData)this.myData).rows.get((int)i2).subqueryId != id || ((SqliteRawPlanData)this.myData).rows.get((int)i2).order != 0) continue;
            MetaNode node = this.parseNestedStructure(i2);
            if (!res2.isEmpty() && ((SqliteRawPlanData)this.myData).rows.get((int)i2).detail.startsWith("EXECUTE")) {
                toPutScalarSubqueries.add(node);
                continue;
            }
            node.children.addAll(res2);
            if (toPutScalarSubqueries == res2) {
                toPutScalarSubqueries = node.children;
            }
            res2.clear();
            res2.add(this.expandStructure(node));
        }
        return res2;
    }

    private MetaNode parseNestedStructure(int idx) {
        ArrayList<MetaNode> res2 = new ArrayList<MetaNode>();
        int i2 = idx;
        int depth = 0;
        while (i2 < ((SqliteRawPlanData)this.myData).rows.size() && ((SqliteRawPlanData)this.myData).rows.get((int)i2).subqueryId == ((SqliteRawPlanData)this.myData).rows.get((int)idx).subqueryId) {
            if (depth != ((SqliteRawPlanData)this.myData).rows.get((int)i2).order) {
                if (((SqliteRawPlanData)this.myData).rows.get((int)i2).order == 0) break;
                this.unsupportedFormat(null);
            }
            res2.add(new MetaNode(i2, MetaNode.Type.ROW));
            ++i2;
            ++depth;
        }
        if (res2.size() == 1) {
            return (MetaNode)res2.get(0);
        }
        MetaNode nested = new MetaNode(-1, MetaNode.Type.NESTED);
        nested.children.addAll(res2);
        return nested;
    }

    @Override
    protected void parseStatement(@NotNull MetaNode s) {
        String[] split;
        if (s == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(41);
        }
        if (!this.openNode(s)) {
            return;
        }
        PlanModel.NodeType type = PlanModel.NodeType.STATEMENT;
        if (StringUtil.startsWithIgnoreCase((String)((SqliteRawPlanData)this.myData).statement, (String)"select") || StringUtil.startsWithIgnoreCase((String)((SqliteRawPlanData)this.myData).statement, (String)"with")) {
            type = PlanModel.NodeType.SELECT;
        } else if (StringUtil.startsWithIgnoreCase((String)((SqliteRawPlanData)this.myData).statement, (String)"update")) {
            type = PlanModel.NodeType.UPDATE;
        } else if (StringUtil.startsWithIgnoreCase((String)((SqliteRawPlanData)this.myData).statement, (String)"insert")) {
            type = PlanModel.NodeType.INSERT;
        } else if (StringUtil.startsWithIgnoreCase((String)((SqliteRawPlanData)this.myData).statement, (String)"delete")) {
            type = PlanModel.NodeType.DELETE;
        }
        if (!((SqliteRawPlanData)this.myData).rows.isEmpty()) {
            this.parseSubPlans(s);
        }
        String title = null;
        if (type == PlanModel.NodeType.STATEMENT && (split = ((SqliteRawPlanData)this.myData).statement.split(" ")).length > 0) {
            title = StringUtil.toLowerCase((String)split[0]);
        }
        this.closeNode(this.createNode(s, type, title));
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull MetaNode node) {
        if (node == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(42);
        }
        return null;
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull MetaNode node) {
        if (node == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(43);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull MetaNode node) {
        if (node == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(44);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull MetaNode node) {
        if (node == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(45);
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("UNION", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("UNION ALL", PlanModel.NodeType.UNION_ALL);
        TYPE_MAPPING.put("EXCEPT", PlanModel.NodeType.EXCEPT);
        TYPE_MAPPING.put("INTERSECT", PlanModel.NodeType.INTERSECT);
        TYPE_MAPPING.put("GROUP BY", PlanModel.NodeType.GROUP_BY);
        TYPE_MAPPING.put("ORDER BY", PlanModel.NodeType.ORDER_BY);
        TYPE_MAPPING.put("DISTINCT", PlanModel.NodeType.UNIQUE);
        TYPE_MAPPING.put("MATERIALIZE", PlanModel.NodeType.OPERATION);
        TYPE_MAPPING.put("CO-ROUTINE", PlanModel.NodeType.OPERATION);
        TYPE_MAPPING.put("SETUP", PlanModel.NodeType.OPERATION);
        TYPE_MAPPING.put("RECURSIVE STEP", PlanModel.NodeType.OPERATION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 10, 13, 14, 17, 19, 21, 36, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tok";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/sqlite/plan/SqlitePlanModelBuilder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compound";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 25: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/sqlite/plan/SqlitePlanModelBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildConstantScanNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTableScanNode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSubqueryScanNode";
                break;
            }
            case 13: 
            case 14: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNode";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNewCompoundChildNode";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildUseNode";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCompoundNode";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "expandStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildConstantScanNode";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 36: 
            case 40: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildTableScanNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildScanNode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildSubqueryScanNode";
                break;
            }
            case 11: 
            case 12: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "buildNode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildNewCompoundNode";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildNewCompoundChildNode";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildUseNode";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "buildCompoundNode";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildSubqueryNode";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "buildOperationNode";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkOrRecover";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkPrefSufAndRecover";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkToken";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "consumeToken";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "consumeTokens";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isCompound";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isScan";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "expandStructure";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 10, 13, 14, 17, 19, 21, 36, 40 -> new IllegalStateException(string);
        };
    }

    public static class MetaNode {
        public final int rowId;
        public final Type type;
        public final List<MetaNode> children = new ArrayList<MetaNode>(0);
        public PlanModel.GenericNode cache = null;

        public MetaNode(int id, Type type) {
            this.rowId = id;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetaNode node = (MetaNode)o;
            return this.rowId == node.rowId && this.type == node.type && Objects.equals(this.children, node.children) && Objects.equals(this.cache, node.cache);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.rowId, this.type, this.children, this.cache});
        }

        static enum Type {
            ROW,
            NESTED,
            DUMMY,
            TEMP,
            SIMPLE;

        }
    }

    public static class PlanRow {
        public final int subqueryId;
        public final int order;
        public final int from;
        public final String detail;

        public PlanRow(int subqueryId, int order, int from, String detail) {
            this.subqueryId = subqueryId;
            this.order = order;
            this.from = from;
            this.detail = detail;
        }
    }
}

