/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.extractors.DbObjectFormatterUtil;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.CompositeFormatter;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtilCore;
import com.intellij.database.run.ui.grid.editors.DatabaseBoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.NumberFormatter;
import com.intellij.database.run.ui.grid.editors.ShortZonedTimestampDelegate;
import com.intellij.database.run.ui.grid.editors.ZonedTimeDelegate;
import com.intellij.database.run.ui.grid.editors.ZonedTimestampDelegate;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseFormatterCreator
extends FormatterCreator {
    private final Dbms myDbms;

    public DatabaseFormatterCreator(@NotNull Dbms dbms) {
        if (dbms == null) {
            DatabaseFormatterCreator.$$$reportNull$$$0(0);
        }
        this.myDbms = dbms;
    }

    protected int calculateScale(@Nullable GridColumn column2, @Nullable ObjectFormatterConfig config) {
        return DatabaseFormatterCreator.calculateScale(column2, this.myDbms, config);
    }

    @NotNull
    protected BoundaryValueResolver resolver(@Nullable GridColumn column2) {
        BoundaryValueResolver boundaryValueResolver = DatabaseBoundaryValueResolver.getResolver(this.myDbms, column2);
        if (boundaryValueResolver == null) {
            DatabaseFormatterCreator.$$$reportNull$$$0(1);
        }
        return boundaryValueResolver;
    }

    protected boolean omitEmptyTime(@Nullable GridColumn column2) {
        return this.myDbms.is(Dbms.ORACLE) && (column2 == null || StringUtil.equalsIgnoreCase((CharSequence)"date", (CharSequence)column2.getTypeName()));
    }

    @NotNull
    public Formatter newDateFormatter(@Nullable GridColumn column2, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        if (formatsCache == null) {
            DatabaseFormatterCreator.$$$reportNull$$$0(2);
        }
        Formatter formatter = DatabaseFormatterCreator.supportsEra(this.myDbms) ? this.newEraDateFormatter(config, formatsCache, this.resolver(column2)) : super.newDateFormatter(column2, config, formatsCache);
        if (formatter == null) {
            DatabaseFormatterCreator.$$$reportNull$$$0(3);
        }
        return formatter;
    }

    public static boolean supportsEra(@NotNull Dbms family) {
        if (family == null) {
            DatabaseFormatterCreator.$$$reportNull$$$0(4);
        }
        return family.in(Dbms.POSTGRES_LIKE) || family.is(Dbms.ORACLE);
    }

    @NotNull
    protected NumberFormatter newDecimalFormat(@Nullable GridColumn column2, @Nullable ObjectFormatterConfig config) {
        if (this.myDbms.is(Dbms.MONGO)) {
            NumberFormatter numberFormatter = DatabaseFormatterCreator.newBigDecimalFormat((ObjectFormatterConfig)config);
            if (numberFormatter == null) {
                DatabaseFormatterCreator.$$$reportNull$$$0(5);
            }
            return numberFormatter;
        }
        JdbcColumnDescriptor c2 = (JdbcColumnDescriptor)ObjectUtils.tryCast((Object)column2, JdbcColumnDescriptor.class);
        NumberFormatter result2 = c2 != null && JdbcUtil.isFloat(c2.getJavaClassName()) ? super.newFloatFormat(config) : super.newDecimalFormat(column2, config);
        int fractionDigits = c2 != null ? c2.getScale() : 0;
        result2.setParseBigDecimal(c2 != null && JdbcUtil.isBigDecimal(c2.getJavaClassName()));
        result2.setMinimumFractionDigits(column2 == null || DbObjectFormatterUtil.isFloatingPoint(column2) || DbObjectFormatterUtil.isH2DecimalWithUnspecifiedPrecision(column2) ? 0 : fractionDigits);
        result2.setMaximumFractionDigits(340);
        if (c2 != null && c2.getAttributes().contains(ColumnDescriptor.Attribute.ZERO_PADDING) && c2.getSize() > 0) {
            result2.setMinimumIntegerDigits(c2.getSize());
        }
        NumberFormatter numberFormatter = result2;
        if (numberFormatter == null) {
            DatabaseFormatterCreator.$$$reportNull$$$0(6);
        }
        return numberFormatter;
    }

    @NotNull
    protected Formatter newIntrinsicTimestampFormat(@Nullable GridColumn column2, int scale, @NotNull BoundaryValueResolver resolver, @Nullable ObjectFormatterConfig config, @NotNull FormatsCache formatsCache) {
        if (resolver == null) {
            DatabaseFormatterCreator.$$$reportNull$$$0(7);
        }
        if (formatsCache == null) {
            DatabaseFormatterCreator.$$$reportNull$$$0(8);
        }
        Formatter formatter = DatabaseFormatterCreator.supportsEra(this.myDbms) ? this.newEraTimestampFormat(column2, config, formatsCache) : (this.myDbms.is(Dbms.MONGO) ? this.newDateFormatWithTime(column2, config, formatsCache) : super.newIntrinsicTimestampFormat(column2, scale, resolver, config, formatsCache));
        if (formatter == null) {
            DatabaseFormatterCreator.$$$reportNull$$$0(9);
        }
        return formatter;
    }

    @NotNull
    protected ZonedTimeDelegate<?> newZonedTimeDelegate(final @Nullable ObjectFormatterConfig config) {
        return new ZonedTimeDelegate<Object>(){

            protected TemporalAccessor toTemporalAccessor(@NotNull Object value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(value instanceof TimeZonedTime)) {
                    throw new IllegalArgumentException("Value must be of type TimeZonedTime");
                }
                return DataGridFormattersUtilCore.adjustOffset((OffsetTime)((OffsetTime)((TimeZonedTime)value).getValue()), (ZoneId)DataGridFormattersUtilCore.getZoneId((ObjectFormatterConfig)config));
            }

            protected TimeZonedTime createFromTemporal(@NotNull TemporalAccessor value) {
                if (value == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new TimeZonedTime(DataGridFormattersUtilCore.adjustOffset((OffsetTime)OffsetTime.from(value), (ZoneId)DataGridFormattersUtilCore.getZoneId((ObjectFormatterConfig)config)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/database/extractors/DatabaseFormatterCreator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toTemporalAccessor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createFromTemporal";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public CompositeFormatter newZonedTimestampFormat(@NotNull BoundaryValueResolver resolver, int scale, @NotNull FormatsCache formatsCache, @Nullable ObjectFormatterConfig config) {
        if (resolver == null) {
            DatabaseFormatterCreator.$$$reportNull$$$0(10);
        }
        if (formatsCache == null) {
            DatabaseFormatterCreator.$$$reportNull$$$0(11);
        }
        CompositeFormatter compositeFormatter = this.newZonedTimestampFormat((DateAndTimeFormatterDelegate)new ZonedTimestampDelegate<TimeZonedTimestamp>(){

            protected OffsetDateTime toTemporalAccessor(@NotNull Object value) {
                if (value == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!(value instanceof TimeZonedTimestamp)) {
                    throw new IllegalArgumentException("Value must be type of TimeZonedTimestamp");
                }
                TimeZonedTimestamp zonedTimestamp = (TimeZonedTimestamp)value;
                return (OffsetDateTime)zonedTimestamp.getValue();
            }

            protected TimeZonedTimestamp createFromTemporal(@NotNull OffsetDateTime value) {
                if (value == null) {
                    2.$$$reportNull$$$0(1);
                }
                return new TimeZonedTimestamp(value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/database/extractors/DatabaseFormatterCreator$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toTemporalAccessor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createFromTemporal";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, resolver, scale, config);
        if (compositeFormatter == null) {
            DatabaseFormatterCreator.$$$reportNull$$$0(12);
        }
        return compositeFormatter;
    }

    @NotNull
    protected ShortZonedTimestampDelegate<?> newShortZonedTimestampDelegate(final @Nullable ObjectFormatterConfig config) {
        return new ShortZonedTimestampDelegate<TimeZonedTimestamp>(){

            protected TemporalAccessor toTemporalAccessor(@NotNull Object value) {
                if (value == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!(value instanceof TimeZonedTimestamp)) {
                    throw new IllegalArgumentException("Value must be of type TimeZonedTimestamp");
                }
                TimeZonedTimestamp timestamp = (TimeZonedTimestamp)value;
                return DataGridFormattersUtilCore.adjustTimeZone((OffsetDateTime)((OffsetDateTime)timestamp.getValue()), (ZoneId)DataGridFormattersUtilCore.getZoneId((ObjectFormatterConfig)config));
            }

            protected TimeZonedTimestamp createFromTemporal(@NotNull TemporalAccessor value) {
                if (value == null) {
                    3.$$$reportNull$$$0(1);
                }
                return new TimeZonedTimestamp(DataGridFormattersUtilCore.toOffsetDateTime((TemporalAccessor)value, (ZoneId)DataGridFormattersUtilCore.getZoneId((ObjectFormatterConfig)config)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/database/extractors/DatabaseFormatterCreator$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toTemporalAccessor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createFromTemporal";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static int calculateScale(@Nullable GridColumn column2, @NotNull Dbms dbms, @Nullable ObjectFormatterConfig config) {
        if (dbms == null) {
            DatabaseFormatterCreator.$$$reportNull$$$0(13);
        }
        if (!(column2 instanceof DataConsumer.Column)) {
            return 0;
        }
        DataConsumer.Column c2 = (DataConsumer.Column)column2;
        int scale = c2.getScale();
        String typeName = StringUtil.notNullize((String)column2.getTypeName());
        if ((dbms.isSnowflake() || dbms.isPostgres() || dbms.isHsqldb() && typeName.equals("TIME")) && column2.getType() == 92) {
            return 0;
        }
        if (dbms.isMysql() && column2.getType() == 93 && (StringUtil.equalsIgnoreCase((CharSequence)"datetime", (CharSequence)typeName) || StringUtil.equalsIgnoreCase((CharSequence)"timestamp", (CharSequence)typeName))) {
            boolean isNormalize;
            scale = c2.getSize() - 20;
            boolean bl = isNormalize = config != null && config.getMode() == ObjectFormatterMode.NORMALIZE;
            if (isNormalize && (dbms == Dbms.MYSQL_AURORA || dbms == Dbms.MARIA)) {
                scale = Math.max(scale, 1);
            }
        }
        if (dbms.isSqlite() || dbms.in(Dbms.PRESTO_LIKE) || scale == 0 && dbms.isExasol()) {
            scale = 3;
        }
        return MathUtil.clamp((int)scale, (int)0, (int)9);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 6, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/DatabaseFormatterCreator";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatsCache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/DatabaseFormatterCreator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "resolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newDateFormatter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "newDecimalFormat";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "newIntrinsicTimestampFormat";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newZonedTimestampFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "newDateFormatter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "supportsEra";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "newIntrinsicTimestampFormat";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newZonedTimestampFormat";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calculateScale";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 6, 9, 12 -> new IllegalStateException(string);
        };
    }
}

