/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.diff;

import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffModelHolder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsActions;
import org.jetbrains.annotations.NotNull;

public class DbDiffCheckOption
extends ToggleAction
implements DumbAware,
DirDiffModelHolder,
ShortcutProvider {
    private final String myKey;
    private final String myShortcut;
    private DirDiffModel myModel;

    public DbDiffCheckOption(String key2, @NlsActions.ActionText String title, String shortcut) {
        super(title);
        this.myKey = key2;
        this.myShortcut = shortcut;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DbDiffCheckOption.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public String getKey() {
        return this.myKey;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            DbDiffCheckOption.$$$reportNull$$$0(1);
        }
        return Boolean.TRUE.equals(this.myModel.getSettings().customSettings.get(this.myKey));
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            DbDiffCheckOption.$$$reportNull$$$0(2);
        }
        this.myModel.getSettings().customSettings.put(this.myKey, state);
        DbDiffCheckOption.putOption(this.myKey, state);
        this.myModel.applySettings();
        this.myModel.reloadModel(true);
    }

    public void setModel(DirDiffModel model) {
        this.myModel = model;
    }

    public ShortcutSet getShortcut() {
        return CustomShortcutSet.fromString((String[])new String[]{this.myShortcut});
    }

    public static boolean getOption(@NotNull String key2) {
        if (key2 == null) {
            DbDiffCheckOption.$$$reportNull$$$0(3);
        }
        return PropertiesComponent.getInstance().getBoolean("DbDiff." + key2, DbDiffCheckOption.getDefaultValue(key2));
    }

    public static void putOption(@NotNull String key2, boolean val) {
        if (key2 == null) {
            DbDiffCheckOption.$$$reportNull$$$0(4);
        }
        PropertiesComponent.getInstance().setValue("DbDiff." + key2, val, DbDiffCheckOption.getDefaultValue(key2));
    }

    private static boolean getDefaultValue(@NotNull String key2) {
        if (key2 == null) {
            DbDiffCheckOption.$$$reportNull$$$0(5);
        }
        if (key2.equals("IGNORE_IMPLICIT_OBJECTS")) {
            return true;
        }
        return !key2.equals("IGNORE_SOURCE_CODE");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/diff/DbDiffCheckOption";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/diff/DbDiffCheckOption";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOption";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putOption";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

