/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.Dbms;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.SimpleErrorInfo;
import com.intellij.database.console.ExecutionConcession;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.script.translator.TranslateException;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConsoleDataRequest
extends DataRequest.QueryRequest
implements DataRequest.CoupledWithEditor {
    @RegExp
    private static final String TITLE_PREFIX_PATTERN = "(--|/\\*|//)?\\s*%s([^\\s].+(\\*[^/]?|[^*/]))\\s*($|\\*/)";
    public static final DataKey<ConsoleDataRequest> CONSOLE_DATA_REQUEST = DataKey.create((String)"ConsoleDataRequest");
    private final Shared shared;
    private final TextRange myInitialRange;
    public final int queryIndex;
    public final boolean hasNext;
    public final boolean newTab;
    public final Set<ExecutionConcession> concessions;
    private final SubQueriesInfo mySubQueriesInfo;

    @Nullable
    public static ConsoleDataRequest newConsoleRequest(@NotNull JdbcConsoleBase console, @NotNull Editor editor2, @NotNull ScriptModel<?> model, boolean newTab) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ConsoleDataRequest.$$$reportNull$$$0(1);
        }
        if (model == null) {
            ConsoleDataRequest.$$$reportNull$$$0(2);
        }
        DataRequest.Constraints constraints = ConsoleDataRequest.newConstraints(DbImplUtil.getDbms(console));
        Shared shared = new Shared(editor2, model, constraints);
        shared.queries.advance();
        return ConsoleDataRequest.newConsoleRequest(console, shared, 0, newTab, EnumSet.noneOf(ExecutionConcession.class));
    }

    @Nullable
    private static ConsoleDataRequest newConsoleRequest(@NotNull JdbcConsoleBase console, @NotNull Shared shared, int queryIndex, boolean newTab, @NotNull Set<ExecutionConcession> concessions) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(3);
        }
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(4);
        }
        if (concessions == null) {
            ConsoleDataRequest.$$$reportNull$$$0(5);
        }
        QueryTextResult queryTextResult = ConsoleDataRequest.currentQueryTextResult(console, shared);
        ConsoleDataRequest newRequest = new ConsoleDataRequest(console, queryTextResult.getText(), shared, queryIndex, newTab, concessions);
        TranslateException translateException = queryTextResult.getTranslateException();
        if (translateException != null) {
            DataRequest.CoupledWithEditor.ErrorNavigator navigator = newRequest.onError(SimpleErrorInfo.create((Throwable)translateException));
            SwingUtilities.invokeLater(() -> {
                if (navigator != null && navigator.canNavigate()) {
                    navigator.navigate();
                }
            });
            return null;
        }
        return newRequest;
    }

    private ConsoleDataRequest(@NotNull JdbcConsoleBase console, @NotNull String query, @NotNull Shared shared, int queryIndex, boolean newTab, @NotNull Set<ExecutionConcession> concessions) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(6);
        }
        if (query == null) {
            ConsoleDataRequest.$$$reportNull$$$0(7);
        }
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(8);
        }
        if (concessions == null) {
            ConsoleDataRequest.$$$reportNull$$$0(9);
        }
        super(console, query, shared.constraints, null);
        this.shared = shared;
        this.queryIndex = queryIndex;
        this.newTab = newTab;
        this.concessions = concessions;
        ScriptModel.StatementIt currentQuery = (ScriptModel.StatementIt)shared.queries.current();
        this.mySubQueriesInfo = ConsoleDataRequest.computeSubQueriesInfo(currentQuery, console, shared.scriptModel.getLanguage(), shared.scriptModel.getTextRange());
        this.hasNext = shared.queries.hasNext();
        this.myInitialRange = this.getRange();
    }

    @Nullable
    public static <E> String computeTitle(@Nullable E object, @NotNull SyntaxTraverser.Api<E> api, @NotNull Project project) {
        String[] lines;
        String commentText;
        if (api == null) {
            ConsoleDataRequest.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ConsoleDataRequest.$$$reportNull$$$0(11);
        }
        DatabaseSettings settings = DatabaseSettings.getSettings();
        if (object == null || !settings.resultsTitlePrefixEnabled) {
            return null;
        }
        Object comment = SqlPsiFacade.getInstance((Project)project).getNotebookManager().getPrecedingComment(object, api);
        String string = commentText = comment == null ? null : api.textOf(comment).toString();
        if (commentText == null) {
            return null;
        }
        String patternText = StringUtil.isEmptyOrSpaces((String)settings.resultsTitlePrefix) ? "" : Pattern.quote(settings.resultsTitlePrefix) + "\\s+";
        Pattern pattern = Pattern.compile(String.format(TITLE_PREFIX_PATTERN, patternText));
        for (String line : lines = StringUtil.splitByLines((String)commentText)) {
            Matcher lineMatcher = pattern.matcher(line);
            if (!lineMatcher.matches()) continue;
            return lineMatcher.group(2);
        }
        return null;
    }

    @NotNull
    private static <E> SubQueriesInfo computeSubQueriesInfo(@NotNull ScriptModel.StatementIt<E> statementIt, @NotNull JdbcConsoleBase console, @NotNull Language scriptLanguage, @Nullable TextRange scriptRange) {
        if (statementIt == null) {
            ConsoleDataRequest.$$$reportNull$$$0(12);
        }
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(13);
        }
        if (scriptLanguage == null) {
            ConsoleDataRequest.$$$reportNull$$$0(14);
        }
        Object object = statementIt.object();
        long offset = statementIt.rangeOffset();
        SyntaxTraverser.Api api = statementIt.api();
        EvaluationHelper helper = (EvaluationHelper)EvaluationHelper.EP.forLanguage(scriptLanguage);
        boolean canContainStatements = helper.canContainStatements(statementIt.api()).value(object) && ScriptModelUtilCore.getSelectionOption(scriptRange) != 1;
        SyntaxTraverser s = canContainStatements ? (SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.syntaxTraverser(api).withRoot(object)).expand(helper.canContainStatements(api))).filter(helper.isStatement(api)) : (SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.syntaxTraverser(api).withRoot(object)).expand(Conditions.alwaysFalse());
        boolean justOne = s.traverse().take(2).size() == 1;
        List resultSetSubQueries = s.traverse().map(st -> {
            String query = api.textOf(st).toString();
            TextRange range = api.rangeOf(st).shiftRight((int)offset);
            String title = ConsoleDataRequest.computeTitle(st, api, console.getProject());
            SqlTableType resultType = DbSqlUtil.parseQueryTableType(console, scriptLanguage, query);
            return resultType != null || justOne ? new ResultSetSubQuery(query, range, title, resultType) : null;
        }).filter(Objects::nonNull).toList();
        return new SubQueriesInfo(justOne, resultSetSubQueries);
    }

    @NotNull
    private static String handleQueryText(@NotNull JdbcConsoleBase console, String text2) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(15);
        }
        String lineSeparator = (String)ObjectUtils.notNull((Object)console.getVirtualFile().getDetectedLineSeparator(), (Object)LineSeparator.getSystemLineSeparator().getSeparatorString());
        String string = StringUtil.convertLineSeparators((String)text2, (String)lineSeparator);
        if (string == null) {
            ConsoleDataRequest.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static QueryTextResult currentQueryTextResult(@NotNull JdbcConsoleBase console, @NotNull Shared shared) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(17);
        }
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(18);
        }
        ScriptModel.PStorage storage = console.getPStorage();
        try {
            String currentText = ((ScriptModel.StatementIt)shared.queries.current()).consoleQuery(storage, Conditions.alwaysFalse());
            return new QueryTextResult(ConsoleDataRequest.handleQueryText(console, currentText), null);
        }
        catch (TranslateException e) {
            String currentRawText = ((ScriptModel.StatementIt)shared.queries.current()).query();
            return new QueryTextResult(ConsoleDataRequest.handleQueryText(console, currentRawText), e);
        }
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.shared.sourceEditor;
    }

    @Override
    @NotNull
    public GridDataRequest getRequest() {
        ConsoleDataRequest consoleDataRequest = this;
        if (consoleDataRequest == null) {
            ConsoleDataRequest.$$$reportNull$$$0(19);
        }
        return consoleDataRequest;
    }

    @NotNull
    public JdbcConsoleBase getConsole() {
        JdbcConsoleBase jdbcConsoleBase = (JdbcConsoleBase)this.owner;
        if (jdbcConsoleBase == null) {
            ConsoleDataRequest.$$$reportNull$$$0(20);
        }
        return jdbcConsoleBase;
    }

    @NotNull
    private DataProducer getDataProducer() {
        DataProducer dataProducer = this.getConsole().getMessageBus().getDataProducer();
        if (dataProducer == null) {
            ConsoleDataRequest.$$$reportNull$$$0(21);
        }
        return dataProducer;
    }

    @NotNull
    public UserDataHolder getSharedDataHolder() {
        Shared shared = this.shared;
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(22);
        }
        return shared;
    }

    public boolean produceResultSet() {
        ResultSetSubQuery subQuery = this.getResultSetSubquery(1);
        return subQuery != null && subQuery.resultType != null;
    }

    public boolean containSingleSubQuery() {
        return this.mySubQueriesInfo.containSingleSubQuery();
    }

    @Nullable
    public ResultSetSubQuery getResultSetSubquery(int queryIndex) {
        return this.mySubQueriesInfo.getResultSetSubQuery(queryIndex);
    }

    @NotNull
    public List<ResultSetSubQuery> getResultSetSubQueries() {
        List<ResultSetSubQuery> list = this.mySubQueriesInfo.getResultSetSubQueries();
        if (list == null) {
            ConsoleDataRequest.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Override
    @Nullable
    public DataRequest.CoupledWithEditor.ErrorNavigator onError(@NotNull ErrorInfo errorInfo) {
        if (errorInfo == null) {
            ConsoleDataRequest.$$$reportNull$$$0(24);
        }
        return DatabaseUiService.getInstance().reportError(this, errorInfo);
    }

    @Override
    public void onWarning(@NotNull JdbcEngineUtils.EngineWarningExceptionInfo info2) {
        if (info2 == null) {
            ConsoleDataRequest.$$$reportNull$$$0(25);
        }
        DatabaseUiService.getInstance().reportWarning(this, info2);
    }

    public void onFinished() {
        if (!this.isExecutionStopper()) {
            this.processNextRequest();
        }
    }

    public boolean isExecutionStopper() {
        return this.isLastInChain() || this.hasPendingProblems();
    }

    public boolean isLastInChain() {
        return !this.hasNext;
    }

    private boolean hasPendingProblems() {
        return JBIterable.of((Object[])new ProblemSolver[]{this.shared.errorsSolver, this.shared.warningsSolver}).filter(ProblemSolver::isEnabled).isNotEmpty();
    }

    private void processNextRequest() {
        ConsoleDataRequest nextRequest = this.nextRequest();
        if (nextRequest != null) {
            this.getDataProducer().processRequest((GridDataRequest)nextRequest);
        }
    }

    @Nullable
    private ConsoleDataRequest nextRequest() {
        this.shared.queries.advance();
        JdbcConsoleBase console = this.getConsole();
        return ConsoleDataRequest.newConsoleRequest(console, this.shared, this.queryIndex + 1, this.newTab, EnumSet.copyOf(this.shared.warningsSolver.getConcessions()));
    }

    private void processClonedRequest() {
        ConsoleDataRequest clonedRequest = this.cloneRequest();
        if (clonedRequest != null) {
            this.getDataProducer().processRequest((GridDataRequest)clonedRequest);
        }
    }

    @Nullable
    private ConsoleDataRequest cloneRequest() {
        JdbcConsoleBase console = this.getConsole();
        EnumSet<ExecutionConcession> concessions = EnumSet.copyOf(this.concessions);
        concessions.addAll(this.shared.warningsSolver.getConcessions());
        return ConsoleDataRequest.newConsoleRequest(console, this.shared, this.queryIndex, this.newTab, concessions);
    }

    public void onStarted() {
        SwingUtilities.invokeLater(() -> {
            if (!this.hasNext || this.shared.lastUpdateTime < 0L || System.currentTimeMillis() - this.shared.lastUpdateTime > 100L) {
                DatabaseUiService.getInstance().updateConsoleUI(this, false);
            }
        });
        this.shared.lastUpdateTime = System.currentTimeMillis();
    }

    public TextRange getInitialRange() {
        return this.myInitialRange;
    }

    @Override
    @Nullable
    public TextRange getRange() {
        return this.shared.adjustedRange(this.queryIndex);
    }

    public int computeErrorPosition(@NotNull ErrorInfo errorInfo) {
        if (errorInfo == null) {
            ConsoleDataRequest.$$$reportNull$$$0(26);
        }
        Project project = this.getConsole().getProject();
        Dbms dbms = this.getConsole().getTarget().getDbms();
        return DatabaseErrorHandler.EP.forDbms(dbms).getErrorOffset(project, errorInfo, this.query);
    }

    public int getErrorOffsetInEditor(int errorPosition) {
        int offset;
        TextRange currentRange = this.getRange();
        if (currentRange == null || this.getInitialRange() != null && !this.getInitialRange().equals((Object)currentRange)) {
            return -1;
        }
        int n = offset = errorPosition >= 0 ? errorPosition + currentRange.getStartOffset() : -1;
        if (offset >= currentRange.getEndOffset()) {
            return currentRange.getEndOffset();
        }
        if (offset < currentRange.getStartOffset()) {
            return currentRange.getStartOffset();
        }
        return offset;
    }

    public WarningsSolver getWarningSolver() {
        return this.shared.warningsSolver;
    }

    public ErrorsSolver getErrorSolver() {
        return this.shared.errorsSolver;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 19, 20, 21, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shared";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "concessions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "api";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementIt";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptLanguage";
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ConsoleDataRequest";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "handleQueryText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequest";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataProducer";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedDataHolder";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultSetSubQueries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newConsoleRequest";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeTitle";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeSubQueriesInfo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handleQueryText";
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "currentQueryTextResult";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "onError";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "onWarning";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "computeErrorPosition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 19, 20, 21, 22, 23 -> new IllegalStateException(string);
        };
    }

    public static class Shared
    extends UserDataHolderBase {
        final Editor sourceEditor;
        final ScriptModel<?> scriptModel;
        final DataRequest.Constraints constraints;
        final JBIterator<? extends ScriptModel.StatementIt<?>> queries;
        final List<RangeMarker> rangeMarkers;
        long lastUpdateTime = -1L;
        ErrorsSolver errorsSolver = new ErrorsSolver();
        WarningsSolver warningsSolver = new WarningsSolver();

        public Shared(Editor sourceEditor, ScriptModel<?> scriptModel, DataRequest.Constraints constraints) {
            this.queries = JBIterator.from((Iterator)scriptModel.statements().iterator());
            this.sourceEditor = sourceEditor;
            this.scriptModel = scriptModel;
            this.constraints = constraints;
            Document document = sourceEditor.getDocument();
            this.rangeMarkers = scriptModel.statements().transform(it -> {
                TextRange range = it.range().shiftRight((int)it.rangeOffset());
                return range.getEndOffset() <= document.getTextLength() ? document.createRangeMarker(range) : null;
            }).toList();
        }

        @Nullable
        TextRange adjustedRange(int idx) {
            return (TextRange)ReadAction.compute(() -> {
                RangeMarker marker = this.rangeMarkers.get(idx);
                return marker != null && marker.isValid() ? marker.getTextRange() : null;
            });
        }
    }

    private static class QueryTextResult {
        private final String myText;
        private final TranslateException myTranslateException;

        QueryTextResult(@NotNull String text2, @Nullable TranslateException translateException) {
            if (text2 == null) {
                QueryTextResult.$$$reportNull$$$0(0);
            }
            this.myText = text2;
            this.myTranslateException = translateException;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                QueryTextResult.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public TranslateException getTranslateException() {
            return this.myTranslateException;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ConsoleDataRequest$QueryTextResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest$QueryTextResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class SubQueriesInfo {
        private final boolean myContainSingleSubQuery;
        private final List<ResultSetSubQuery> myResultSetSubQueries;

        SubQueriesInfo(boolean containSingleSubQuery, @NotNull List<ResultSetSubQuery> resultSetSubQueries) {
            if (resultSetSubQueries == null) {
                SubQueriesInfo.$$$reportNull$$$0(0);
            }
            this.myContainSingleSubQuery = containSingleSubQuery;
            this.myResultSetSubQueries = resultSetSubQueries;
        }

        public boolean containSingleSubQuery() {
            return this.myContainSingleSubQuery;
        }

        @Nullable
        public ResultSetSubQuery getResultSetSubQuery(int subQueryIndex) {
            return this.myResultSetSubQueries.size() >= subQueryIndex ? this.myResultSetSubQueries.get(subQueryIndex - 1) : null;
        }

        @NotNull
        public List<ResultSetSubQuery> getResultSetSubQueries() {
            List<ResultSetSubQuery> list = this.myResultSetSubQueries;
            if (list == null) {
                SubQueriesInfo.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultSetSubQueries";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ConsoleDataRequest$SubQueriesInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest$SubQueriesInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultSetSubQueries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class ResultSetSubQuery {
        public final String query;
        public final TextRange range;
        public final String title;
        public final SqlTableType resultType;

        ResultSetSubQuery(@NotNull String query, @NotNull TextRange range, @Nullable String title, @Nullable SqlTableType resultType) {
            if (query == null) {
                ResultSetSubQuery.$$$reportNull$$$0(0);
            }
            if (range == null) {
                ResultSetSubQuery.$$$reportNull$$$0(1);
            }
            this.query = query;
            this.range = range;
            this.title = title;
            this.resultType = resultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "query";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ConsoleDataRequest$ResultSetSubQuery";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ProblemSolver {
        public boolean isEnabled();
    }

    public static class ErrorsSolver
    implements ProblemSolver {
        private boolean myEnabled = true;
        private int myCount;

        public void solve(@NotNull Decision decision, @NotNull ConsoleDataRequest request2) {
            if (decision == null) {
                ErrorsSolver.$$$reportNull$$$0(0);
            }
            if (request2 == null) {
                ErrorsSolver.$$$reportNull$$$0(1);
            }
            --this.myCount;
            switch (decision) {
                case RETRY: {
                    request2.processClonedRequest();
                    break;
                }
                case IGNORE_ALL: {
                    this.myEnabled = false;
                    request2.processNextRequest();
                    break;
                }
                case IGNORE: {
                    request2.processNextRequest();
                    break;
                }
            }
        }

        public void newProblem() {
            if (this.myEnabled) {
                ++this.myCount;
            }
        }

        @Override
        public boolean isEnabled() {
            return this.myCount > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "decision";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "request";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ConsoleDataRequest$ErrorsSolver";
            objectArray[2] = "solve";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class WarningsSolver
    implements ProblemSolver {
        private final EnumSet<ExecutionConcession> myConcessions = EnumSet.noneOf(ExecutionConcession.class);
        private final EnumSet<ExecutionConcession> myRequiredConcessions = EnumSet.noneOf(ExecutionConcession.class);
        private final EnumSet<ExecutionConcession> myIgnoredConcessions = EnumSet.noneOf(ExecutionConcession.class);

        public void solve(@NotNull Decision decision, @NotNull ConsoleDataRequest request2, @NotNull ExecutionConcession concession) {
            if (decision == null) {
                WarningsSolver.$$$reportNull$$$0(0);
            }
            if (request2 == null) {
                WarningsSolver.$$$reportNull$$$0(1);
            }
            if (concession == null) {
                WarningsSolver.$$$reportNull$$$0(2);
            }
            this.myRequiredConcessions.remove((Object)concession);
            switch (decision) {
                case FORCE_EXECUTE: {
                    request2.concessions.add(concession);
                    request2.processClonedRequest();
                    break;
                }
                case FORCE_EXECUTE_ALL: {
                    this.myConcessions.add(concession);
                    request2.processClonedRequest();
                    break;
                }
                case RETRY: {
                    request2.processClonedRequest();
                    break;
                }
                case IGNORE: {
                    request2.processNextRequest();
                    break;
                }
                case IGNORE_ALL: {
                    this.myIgnoredConcessions.add(concession);
                    request2.processNextRequest();
                    break;
                }
            }
        }

        public void newProblem(@NotNull ExecutionConcession concession) {
            if (concession == null) {
                WarningsSolver.$$$reportNull$$$0(3);
            }
            if (!this.myIgnoredConcessions.contains((Object)concession)) {
                this.myRequiredConcessions.add(concession);
            }
        }

        @Override
        public boolean isEnabled() {
            return !this.myConcessions.containsAll(this.myRequiredConcessions);
        }

        @NotNull
        EnumSet<ExecutionConcession> getConcessions() {
            EnumSet<ExecutionConcession> enumSet = this.myConcessions;
            if (enumSet == null) {
                WarningsSolver.$$$reportNull$$$0(4);
            }
            return enumSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "decision";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "concession";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ConsoleDataRequest$WarningsSolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest$WarningsSolver";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConcessions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "solve";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "newProblem";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static enum Decision {
        STOP,
        RETRY,
        IGNORE,
        IGNORE_ALL,
        FORCE_EXECUTE,
        FORCE_EXECUTE_ALL;

    }
}

