/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.DbObjectFormatterUtil;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.DatabaseBoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.FakeRangeFormatter;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.RangeFormatResolver;
import com.intellij.database.run.ui.grid.editors.lexers.PgRangeLexerAdapter;
import com.intellij.database.run.ui.grid.editors.lexers.PgRangeTokens;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultRangeEditorFactory
extends FormatBasedGridCellEditorFactory {
    private static final char ELLIPSIS = '\u2026';

    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        if (grid == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(2);
        }
        GridColumn c2 = Objects.requireNonNull((GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column2));
        Dbms dbms = DataGridUtil.getDbms(grid);
        return dbms.isPostgres() && DbObjectFormatterUtil.isPostgresRangeType(c2) ? 1 : 0;
    }

    @NotNull
    protected Formatter getFormatInner(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        if (grid == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(3);
        }
        if (row == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(4);
        }
        if (column2 == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(5);
        }
        GridColumn c2 = Objects.requireNonNull((GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column2));
        Dbms dbms = DataGridUtil.getDbms(grid);
        FakeRangeFormatter fakeRangeFormatter = RangeFormatResolver.resolveFormatter(grid.getObjectFormatter(), c2, dbms, FormatterCreator.get((CoreGrid)grid), FormatsCache.get((CoreGrid)grid));
        if (fakeRangeFormatter == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(6);
        }
        return fakeRangeFormatter;
    }

    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(@NotNull Project project, final @NotNull DataGrid grid, final @NotNull Formatter format, @Nullable ReservedCellValue nullValue, EventObject initiator, @Nullable TextCompletionProvider provider, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
        if (project == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(7);
        }
        if (grid == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(8);
        }
        if (format == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(9);
        }
        if (row == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(10);
        }
        if (column2 == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(11);
        }
        if (valueParser == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(12);
        }
        if (valueFormatter == null) {
            DefaultRangeEditorFactory.$$$reportNull$$$0(13);
        }
        return new FormatBasedGridCellEditor.BoundedFormatBasedGridCellEditor<FakeRangeFormatter.ParsedRange>(project, grid, format, nullValue, initiator, row, column2, provider, valueParser, valueFormatter){
            private final FakeRangeFormatter myFormatter;
            {
                super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
                this.myFormatter = (FakeRangeFormatter)format;
            }

            @NotNull
            protected Object convertInternalValue(@NotNull FakeRangeFormatter.ParsedRange internalValue) {
                if (internalValue == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = this.myFormatter.rebuild(internalValue);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            protected FakeRangeFormatter.ParsedRange getInternalValue() {
                return this.myFormatter.parseHonestly(this.getTextField().getText());
            }

            protected String getInfinityString(@NotNull FakeRangeFormatter.ParsedRange internalValue) {
                Pair<String, String> values;
                if (internalValue == null) {
                    1.$$$reportNull$$$0(2);
                }
                return (values = this.getRangeValues(internalValue)) == null ? null : 1.buildRangeString(internalValue, values);
            }

            protected boolean isSameValueInEditor(@NotNull FakeRangeFormatter.ParsedRange internalValue, @NotNull String boundaryString) {
                if (internalValue == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (boundaryString == null) {
                    1.$$$reportNull$$$0(4);
                }
                PgRangeLexerAdapter lexer = new PgRangeLexerAdapter();
                Pair<String, String> rangeValues = Objects.requireNonNull(this.getRangeValues(internalValue));
                lexer.start(this.getTextField().getText());
                return !(1.hasNextSuitableToken((Lexer)lexer, PgRangeTokens.COMMA) && !this.itWasInfinity((String)rangeValues.getFirst(), (Lexer)lexer) || 1.hasNextSuitableToken((Lexer)lexer, PgRangeTokens.RIGHT_BRACKET) && !this.itWasInfinity((String)rangeValues.getSecond(), (Lexer)lexer));
            }

            private static boolean hasNextSuitableToken(@NotNull Lexer lexer, @NotNull IElementType endToken) {
                if (lexer == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (endToken == null) {
                    1.$$$reportNull$$$0(6);
                }
                while (lexer.getTokenType() != null && lexer.getTokenType() != PgRangeTokens.VALUE && lexer.getTokenType() != endToken) {
                    lexer.advance();
                }
                return lexer.getTokenType() == PgRangeTokens.VALUE;
            }

            private boolean itWasInfinity(String rangeValue, Lexer lexer) {
                GridModel model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
                BoundaryValueResolver resolver = DatabaseBoundaryValueResolver.getResolver(DataGridUtil.getDbms(grid), (GridColumn)model.getColumn(this.myColumn));
                Object infinity = resolver.createFromInfinityString(lexer.getTokenText());
                lexer.advance();
                return infinity != null || rangeValue == null;
            }

            private static String buildRangeString(@NotNull FakeRangeFormatter.ParsedRange internalValue, @NotNull Pair<String, String> rangeValues) {
                if (internalValue == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (rangeValues == null) {
                    1.$$$reportNull$$$0(8);
                }
                return internalValue.getLeftBrace() + (rangeValues.getFirst() == null ? Character.valueOf('\u2026') : (Serializable)rangeValues.getFirst()) + "," + (rangeValues.getSecond() == null ? Character.valueOf('\u2026') : (Serializable)rangeValues.getSecond()) + internalValue.getRightBrace();
            }

            private Pair<String, String> getRangeValues(@NotNull FakeRangeFormatter.ParsedRange internalValue) {
                if (internalValue == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (internalValue == FakeRangeFormatter.ParsedRange.EMPTY) {
                    return null;
                }
                Object start2 = internalValue.getStart();
                Object end = internalValue.getEnd();
                GridModel model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
                BoundaryValueResolver resolver = DatabaseBoundaryValueResolver.getResolver(DataGridUtil.getDbms(grid), (GridColumn)model.getColumn(this.myColumn));
                String startString = start2 == null ? null : resolver.resolve(start2);
                String endString = end == null ? null : resolver.resolve(end);
                return startString == null && endString == null ? null : Pair.create((Object)startString, (Object)endString);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "internalValue";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "boundaryString";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lexer";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "endToken";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rangeValues";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convertInternalValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convertInternalValue";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getInfinityString";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "isSameValueInEditor";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "hasNextSuitableToken";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "buildRangeString";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "getRangeValues";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParser";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultRangeEditorFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatInner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFormatInner";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEditorImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

