/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbSingleValueModelState;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbVisualEditorBase;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class DbComboBoxEditor<E extends BasicElement, V, S extends DbSingleValueModelState<V>>
extends DbVisualEditorBase<E, S> {
    protected final ComboBox<Object> myBox;

    protected DbComboBoxEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> model) {
        if (controller == null) {
            DbComboBoxEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DbComboBoxEditor.$$$reportNull$$$0(1);
        }
        super(controller, model);
        this.myBox = new ComboBox<Object>(this.getItems()){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(DbVisualEditorBase.columnsToWidth((JComponent)((Object)this), DbComboBoxEditor.this.getColumns()), size.height);
            }
        };
        this.myBox.addItemListener(e -> this.modified());
        this.myBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Object>(){

            protected void customizeCellRenderer(@NotNull JList<?> list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                DbComboBoxEditor.this.renderItem(value, (SimpleColoredComponent)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/schemaEditor/ui/DbComboBoxEditor$2", "customizeCellRenderer"));
            }
        });
    }

    protected int getColumns() {
        return 8 * this.getFieldSize().getScale();
    }

    protected void updateModel() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.myBox.getModel();
        Object selection = model.getSelectedItem();
        model.removeAllElements();
        model.addAll(Arrays.asList(this.getItems()));
        model.setSelectedItem(selection);
    }

    protected void renderItem(Object value, SimpleColoredComponent renderer2) {
        if (value == null) {
            renderer2.append(DatabaseBundle.message("status.text.different.values", new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else if (DbComboBoxEditor.isNull(value)) {
            this.renderNullValue(renderer2);
        } else {
            this.renderValue((ColoredTextContainer)renderer2, value);
        }
    }

    protected void renderNullValue(SimpleColoredComponent renderer2) {
        renderer2.append("");
    }

    protected void renderValue(ColoredTextContainer renderer2, V value) {
        renderer2.append(value.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    private Object[] getItems() {
        ArrayList<Object> res2 = new ArrayList<Object>();
        if (DbSingleValueModelState.getDefaultValue(this.getApplier()) == null) {
            res2.add(ObjectUtils.NULL);
        }
        this.prepareItems().addAllTo(res2);
        return res2.toArray();
    }

    protected abstract JBIterable<V> prepareItems();

    @Override
    public void applyImpl() {
        Object value = this.myBox.getSelectedItem();
        DbSingleValueModelState state = (DbSingleValueModelState)this.getState();
        state.setValue(DbComboBoxEditor.isNull(value) ? null : value);
        state.setInconsistent(value == null);
    }

    protected static boolean isNull(Object value) {
        return value == ObjectUtils.NULL;
    }

    @Override
    public void resetImpl() {
        DbSingleValueModelState state = (DbSingleValueModelState)this.getState();
        Object value = state.getValue();
        this.myBox.setSelectedItem(state.isInconsistent() ? null : (value == null ? ObjectUtils.NULL : value));
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        ComboBox<Object> comboBox = this.myBox;
        if (comboBox == null) {
            DbComboBoxEditor.$$$reportNull$$$0(2);
        }
        return comboBox;
    }

    @Override
    @NotNull
    public FieldSize getFieldSize() {
        FieldSize fieldSize = FieldSize.MEDIUM;
        if (fieldSize == null) {
            DbComboBoxEditor.$$$reportNull$$$0(3);
        }
        return fieldSize;
    }

    @Override
    public boolean isEmpty() {
        return this.myBox.getSelectedItem() == DbSingleValueModelState.getDefaultValue(this.getApplier());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbComboBoxEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbComboBoxEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

