/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicUserDefinedType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasArrayType;
import com.intellij.database.types.DasArrayTypeImpl;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasDataBuiltinType;
import com.intellij.database.types.DasImplicitUnionType;
import com.intellij.database.types.DasSimpleBuiltinType;
import com.intellij.database.types.DasSimpleBuiltinTypeClass;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystem;
import com.intellij.database.util.Case;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTypedDefinition;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 i2\u00020\u0001:\u0002ijB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\b\u0010\u001e\u001a\u00020\u0019H\u0016J\b\u0010\u001f\u001a\u00020\u0019H\u0016J\b\u0010 \u001a\u00020\u0019H\u0016J\b\u0010!\u001a\u00020\u0019H\u0016J\b\u0010\"\u001a\u00020\u0019H\u0016J\b\u0010#\u001a\u00020\u0019H\u0016J\b\u0010$\u001a\u00020\u0019H\u0016J\b\u0010%\u001a\u00020\u0019H\u0016J\b\u0010&\u001a\u00020\u0019H\u0016J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0018H\u0016J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0018H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0016J\u0012\u00100\u001a\u0004\u0018\u00010+2\u0006\u00101\u001a\u00020\u0018H\u0016J\u000e\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020.J\u0010\u00104\u001a\u00020\u00182\u0006\u00105\u001a\u00020+H\u0016J\u0010\u00106\u001a\u00020+2\u0006\u00107\u001a\u00020+H\u0016J\u0010\u00108\u001a\u00020\u00192\u0006\u00109\u001a\u00020:H\u0016J\b\u0010@\u001a\u00020<H\u0016J\u0010\u0010A\u001a\u00020<2\u0006\u0010B\u001a\u00020\u0019H\u0014J\b\u0010C\u001a\u00020<H\u0014J\u0010\u0010D\u001a\u00020<2\u0006\u0010B\u001a\u00020\u0019H\u0016J\u0016\u0010E\u001a\u00020<2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00190GH\u0016J\u0010\u0010H\u001a\u00020\u00192\u0006\u00103\u001a\u00020.H\u0016J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u0019H\u0016J\u0018\u0010L\u001a\u00020J2\u0006\u0010M\u001a\u00020.2\u0006\u0010N\u001a\u00020.H\u0016J\u001c\u0010O\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020Q0P2\u0006\u0010R\u001a\u00020SH\u0016J&\u0010T\u001a\u00020\u00192\b\u0010U\u001a\u0004\u0018\u00010V2\b\u0010W\u001a\u0004\u0018\u00010X2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0016J\u001a\u0010[\u001a\u00020\u00192\u0006\u0010\\\u001a\u00020]2\b\u0010^\u001a\u0004\u0018\u00010XH\u0016J\u0012\u0010_\u001a\u0004\u0018\u00010\u00192\u0006\u00109\u001a\u00020XH\u0016J.\u0010`\u001a\u0004\u0018\u00010\u00192\u0006\u0010a\u001a\u00020b2\b\u0010c\u001a\u0004\u0018\u00010d2\b\u0010e\u001a\u0004\u0018\u00010X2\u0006\u0010f\u001a\u00020XH\u0016J\u001a\u0010g\u001a\u00020\u00192\u0006\u00109\u001a\u00020X2\b\u0010h\u001a\u0004\u0018\u00010XH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000e\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010;\u001a\u00020<8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010\u000e\u001a\u0004\b=\u0010>\u00a8\u0006k"}, d2={"Lcom/intellij/database/types/DasTypeSystemBase;", "Lcom/intellij/database/types/DasTypeSystem;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "databaseDialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "Lorg/jetbrains/annotations/NotNull;", "getDatabaseDialect", "()Lcom/intellij/database/dialects/DatabaseDialectEx;", "databaseDialect$delegate", "Lkotlin/Lazy;", "namingService", "Lcom/intellij/database/script/generator/NamingService;", "getNamingService", "()Lcom/intellij/database/script/generator/NamingService;", "namingService$delegate", "lock", "", "defaultTypes", "Ljava/util/EnumMap;", "Lcom/intellij/database/types/DasTypeCategory;", "Lcom/intellij/database/types/DasType;", "getDefaultTypes", "()Ljava/util/EnumMap;", "defaultTypes$delegate", "getIntType", "getRealType", "getBooleanType", "getTimeType", "getDateType", "getDateTimeType", "getTimestampType", "getIntervalType", "getStringType", "getBytesType", "getDefaultType", "category", "computeDefaultType", "getNormalizedTypeName", "", "name", "normalizeType", "Lcom/intellij/database/model/DataType;", "type", "getDefaultTypeName", "cat", "getTypeCategory", "dataType", "getTypeCategoryByName", "typeName", "getTableTypeSpecification", "args", "getSelfDasType", "element", "Lcom/intellij/database/model/basic/BasicUserDefinedType;", "_anyArrayType", "Lcom/intellij/database/types/DasArrayType;", "get_anyArrayType", "()Lcom/intellij/database/types/DasArrayType;", "_anyArrayType$delegate", "getAnyArrayType", "doCreateArrayType", "componentType", "doCreateAnyArrayType", "getArrayType", "createUnionArrayType", "variants", "", "createDasType", "isTriggerFunctionType", "", "returnType", "supportsImplicitConversion", "fromType", "toType", "getDeprecatedTypes", "", "Lcom/intellij/database/types/DasTypeSystemBase$DeprecatedTypeInfo;", "contextFile", "Lcom/intellij/psi/PsiFile;", "getDasType", "ref", "Lcom/intellij/sql/psi/SqlReference;", "resolved", "Lcom/intellij/psi/PsiElement;", "symbol", "Lcom/intellij/database/symbols/DasSymbol;", "getDefinitionType", "definition", "Lcom/intellij/sql/psi/SqlTypedDefinition;", "usage", "getUnqualifiedAsteriskType", "getBuiltinFunctionReturnType", "prototype", "Lcom/intellij/sql/dialects/BuiltinFunction$Prototype;", "nameElement", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "params", "routineElement", "createSequenceType", "obj", "Companion", "DeprecatedTypeInfo", "intellij.database.core.impl"})
public abstract class DasTypeSystemBase
implements DasTypeSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Dbms dbms;
    @NotNull
    private final Lazy databaseDialect$delegate;
    @NotNull
    private final Lazy namingService$delegate;
    @NotNull
    private final Object lock;
    @NotNull
    private final Lazy defaultTypes$delegate;
    @NotNull
    private final Lazy _anyArrayType$delegate;
    @JvmField
    @NotNull
    public static final DasBuiltinType<?> NULL = DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "<null>", null, 2, null);
    @JvmField
    @NotNull
    public static final DasBuiltinType<?> VOID = DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "<void>", null, 2, null);
    @JvmField
    @NotNull
    public static final DasBuiltinType<?> UNKNOWN;
    @JvmField
    @NotNull
    public static final DasBuiltinType<?> REFERENCE;

    public DasTypeSystemBase(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
        this.databaseDialect$delegate = LazyKt.lazy(() -> DasTypeSystemBase.databaseDialect_delegate$lambda$0(this));
        this.namingService$delegate = LazyKt.lazy(() -> DasTypeSystemBase.namingService_delegate$lambda$1(this));
        this.lock = new Object();
        this.defaultTypes$delegate = LazyKt.lazy(DasTypeSystemBase::defaultTypes_delegate$lambda$2);
        this._anyArrayType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DasArrayType>((Object)this){

            public final DasArrayType invoke() {
                return ((DasTypeSystemBase)this.receiver).doCreateAnyArrayType();
            }
        }));
    }

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    @NotNull
    public final DatabaseDialectEx getDatabaseDialect() {
        Lazy lazy = this.databaseDialect$delegate;
        return (DatabaseDialectEx)lazy.getValue();
    }

    @NotNull
    public final NamingService getNamingService() {
        Lazy lazy = this.namingService$delegate;
        return (NamingService)lazy.getValue();
    }

    private final EnumMap<DasTypeCategory, DasType> getDefaultTypes() {
        Lazy lazy = this.defaultTypes$delegate;
        return (EnumMap)lazy.getValue();
    }

    @Override
    @NotNull
    public DasType getIntType() {
        return this.getDefaultType(DasTypeCategory.INTEGER);
    }

    @Override
    @NotNull
    public DasType getRealType() {
        return this.getDefaultType(DasTypeCategory.REAL);
    }

    @Override
    @NotNull
    public DasType getBooleanType() {
        return this.getDefaultType(DasTypeCategory.BOOLEAN);
    }

    @Override
    @NotNull
    public DasType getTimeType() {
        return this.getDefaultType(DasTypeCategory.TIME);
    }

    @Override
    @NotNull
    public DasType getDateType() {
        return this.getDefaultType(DasTypeCategory.DATE);
    }

    @Override
    @NotNull
    public DasType getDateTimeType() {
        return this.getDefaultType(DasTypeCategory.DATE_TIME);
    }

    @Override
    @NotNull
    public DasType getTimestampType() {
        return this.getDefaultType(DasTypeCategory.TIMESTAMP);
    }

    @Override
    @NotNull
    public DasType getIntervalType() {
        return this.getDefaultType(DasTypeCategory.INTERVAL);
    }

    @Override
    @NotNull
    public DasType getStringType() {
        return this.getDefaultType(DasTypeCategory.STRING);
    }

    @Override
    @NotNull
    public DasType getBytesType() {
        return this.getDefaultType(DasTypeCategory.BYTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DasType getDefaultType(@NotNull DasTypeCategory category) {
        DasType dasType;
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            DasType dasType2 = this.getDefaultTypes().computeIfAbsent(category, arg_0 -> DasTypeSystemBase.getDefaultType$lambda$5$lambda$4(arg_0 -> DasTypeSystemBase.getDefaultType$lambda$5$lambda$3(this, arg_0), arg_0));
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
            dasType = dasType2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"synchronized(...)");
        return dasType;
    }

    private final DasType computeDefaultType(DasTypeCategory category) {
        if (category == DasTypeCategory.UNKNOWN) {
            return UNKNOWN;
        }
        String string = this.getDefaultTypeName(category);
        if (string == null) {
            return UNKNOWN;
        }
        String name2 = string;
        DataType dataType = DataTypeFactory.of(this.getNormalizedTypeName(name2));
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
        DataType dataType2 = dataType;
        DasTypeCategory actualCategory = this.getTypeCategory(dataType2);
        return DasDataBuiltinType.Companion.of(name2, actualCategory, dataType2);
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (this.getNamingService().isQuoted(name2)) {
            return name2;
        }
        NamingService namingService = this.getNamingService();
        ObjectKind objectKind = ObjectKind.OBJECT_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OBJECT_TYPE");
        Case casing = namingService.getCasing((ObjectKind)objectKind, null).plain;
        if (casing == Case.MIXED) {
            casing = Case.LOWER;
        }
        String string = casing.apply(name2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"apply(...)");
        return string;
    }

    @Override
    @NotNull
    public DataType normalizeType(@NotNull DataType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String string = type.typeName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName");
        String name2 = this.getNormalizedTypeName(string);
        ScriptGenerator scriptGenerator = (ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(this.dbms);
        Version version = Version.INFINITY;
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"INFINITY");
        boolean defSize = scriptGenerator.isDefaultSize(type, version);
        if (Intrinsics.areEqual((Object)type.typeName, (Object)name2) && !defSize) {
            return type;
        }
        DataType dataType = DataTypeFactory.of(type.schemaName, type.packageName, name2, defSize ? -1 : type.size, defSize ? 0 : type.scale, type.sizeUnit, type.suffix, type.sizeUnitExplicit, type.custom, type.jdbcType);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
        return dataType;
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull DasTypeCategory cat) {
        Intrinsics.checkNotNullParameter((Object)((Object)cat), (String)"cat");
        return switch (WhenMappings.$EnumSwitchMapping$0[cat.ordinal()]) {
            case 1 -> "integer";
            case 2 -> "decimal";
            case 3 -> "varchar";
            case 4 -> "boolean";
            case 5 -> "datetime";
            case 6 -> "date";
            case 7 -> "time";
            case 8 -> "timestamp";
            case 9 -> "interval";
            case 10 -> "bytes";
            case 11 -> "record";
            default -> null;
        };
    }

    @NotNull
    public final DasTypeCategory getTypeCategory(@NotNull DataType dataType) {
        int type;
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        String string = dataType.typeName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName");
        String name2 = this.getNormalizedTypeName(string);
        DasTypeCategory cat = this.getTypeCategoryByName(name2);
        if (cat != DasTypeCategory.UNKNOWN) {
            return cat;
        }
        int n = type = dataType.jdbcType == 0 ? this.getDatabaseDialect().getJavaTypeForNativeType(name2) : dataType.jdbcType;
        if (type != 1111) {
            DasTypeCategory dasTypeCategory = DasTypeCategory.findByJdbcType(type);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)dasTypeCategory), (String)"findByJdbcType(...)");
            return dasTypeCategory;
        }
        return StringUtil.isEmpty((String)name2) ? DasTypeCategory.UNKNOWN : cat;
    }

    @NotNull
    public DasTypeCategory getTypeCategoryByName(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        String fixed = StringUtil.toUpperCase((String)typeName);
        Intrinsics.checkNotNull((Object)fixed);
        return StringsKt.contains$default((CharSequence)fixed, (CharSequence)"BINARY", (boolean)false, (int)2, null) ? DasTypeCategory.BYTES : (StringsKt.contains$default((CharSequence)fixed, (CharSequence)"BOOL", (boolean)false, (int)2, null) ? DasTypeCategory.BOOLEAN : (Intrinsics.areEqual((Object)fixed, (Object)"DATE") ? DasTypeCategory.DATE : (Intrinsics.areEqual((Object)fixed, (Object)"TIME") ? DasTypeCategory.TIME : (Intrinsics.areEqual((Object)fixed, (Object)"TIMESTAMP") ? DasTypeCategory.TIMESTAMP : (StringsKt.contains$default((CharSequence)fixed, (CharSequence)"DATE", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fixed, (CharSequence)"TIME", (boolean)false, (int)2, null) ? DasTypeCategory.DATE_TIME : (StringsKt.contains$default((CharSequence)fixed, (CharSequence)"REAL", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fixed, (CharSequence)"DOUBLE", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fixed, (CharSequence)"FLOAT", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fixed, (CharSequence)"NUMBER", (boolean)false, (int)2, null) ? DasTypeCategory.REAL : (StringsKt.contains$default((CharSequence)fixed, (CharSequence)"INTERVAL", (boolean)false, (int)2, null) ? DasTypeCategory.INTERVAL : (StringsKt.contains$default((CharSequence)fixed, (CharSequence)"INT", (boolean)false, (int)2, null) ? DasTypeCategory.INTEGER : (StringsKt.contains$default((CharSequence)fixed, (CharSequence)"CHAR", (boolean)false, (int)2, null) ? DasTypeCategory.STRING : (StringsKt.contains$default((CharSequence)fixed, (CharSequence)"TEXT", (boolean)false, (int)2, null) ? DasTypeCategory.STRING : (StringsKt.contains$default((CharSequence)fixed, (CharSequence)"REFERENCE", (boolean)false, (int)2, null) ? DasTypeCategory.REFERENCE : (StringsKt.contains$default((CharSequence)fixed, (CharSequence)"RECORD", (boolean)false, (int)2, null) ? DasTypeCategory.RECORD : DasTypeCategory.UNKNOWN))))))))))));
    }

    @Override
    @NotNull
    public String getTableTypeSpecification(@NotNull String args2) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        return "table(" + args2 + ")";
    }

    @NotNull
    public DasType getSelfDasType(@NotNull BasicUserDefinedType element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return UNKNOWN;
    }

    private final DasArrayType get_anyArrayType() {
        Lazy lazy = this._anyArrayType$delegate;
        return (DasArrayType)lazy.getValue();
    }

    @Override
    @NotNull
    public DasArrayType getAnyArrayType() {
        return this.get_anyArrayType();
    }

    @NotNull
    protected DasArrayType doCreateArrayType(@NotNull DasType componentType) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        return new DasArrayTypeImpl(componentType);
    }

    @NotNull
    protected DasArrayType doCreateAnyArrayType() {
        return this.doCreateArrayType(UNKNOWN);
    }

    @Override
    @NotNull
    public DasArrayType getArrayType(@NotNull DasType componentType) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        return Intrinsics.areEqual((Object)componentType, UNKNOWN) ? this.getAnyArrayType() : this.doCreateArrayType(componentType);
    }

    @NotNull
    public DasArrayType createUnionArrayType(@NotNull List<? extends DasType> variants) {
        Intrinsics.checkNotNullParameter(variants, (String)"variants");
        DasType componentType = switch (variants.size()) {
            case 0 -> UNKNOWN;
            case 1 -> (DasType)CollectionsKt.first(variants);
            default -> new DasImplicitUnionType(variants);
        };
        return this.getArrayType(componentType);
    }

    @NotNull
    public DasType createDasType(@NotNull DataType dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        return DasDataBuiltinType.Companion.of(this.getTypeCategory(dataType), dataType);
    }

    public boolean isTriggerFunctionType(@NotNull DasType returnType) {
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        return false;
    }

    public boolean supportsImplicitConversion(@NotNull DataType fromType, @NotNull DataType toType) {
        Intrinsics.checkNotNullParameter((Object)fromType, (String)"fromType");
        Intrinsics.checkNotNullParameter((Object)toType, (String)"toType");
        return true;
    }

    @NotNull
    public Map<String, DeprecatedTypeInfo> getDeprecatedTypes(@NotNull PsiFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        return MapsKt.emptyMap();
    }

    @NotNull
    public DasType getDasType(@Nullable SqlReference ref2, @Nullable PsiElement resolved, @Nullable DasSymbol symbol) {
        return UNKNOWN;
    }

    @NotNull
    public DasType getDefinitionType(@NotNull SqlTypedDefinition definition, @Nullable PsiElement usage) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        return UNKNOWN;
    }

    @Nullable
    public DasType getUnqualifiedAsteriskType(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    @Nullable
    public DasType getBuiltinFunctionReturnType(@NotNull BuiltinFunction.Prototype prototype, @Nullable SqlReferenceExpression nameElement, @Nullable PsiElement params, @NotNull PsiElement routineElement) {
        Intrinsics.checkNotNullParameter((Object)prototype, (String)"prototype");
        Intrinsics.checkNotNullParameter((Object)routineElement, (String)"routineElement");
        return null;
    }

    @NotNull
    public DasType createSequenceType(@NotNull PsiElement element, @Nullable PsiElement obj2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return UNKNOWN;
    }

    private static final DatabaseDialectEx databaseDialect_delegate$lambda$0(DasTypeSystemBase this$0) {
        return DbImplUtilCore.getDatabaseDialect(this$0.dbms);
    }

    private static final NamingService namingService_delegate$lambda$1(DasTypeSystemBase this$0) {
        return NamingServices.getNamingService$default(this$0.dbms, null, null, 6, null);
    }

    private static final EnumMap defaultTypes_delegate$lambda$2() {
        return new EnumMap(DasTypeCategory.class);
    }

    private static final DasType getDefaultType$lambda$5$lambda$3(DasTypeSystemBase this$0, DasTypeCategory it) {
        Intrinsics.checkNotNull((Object)((Object)it));
        return this$0.computeDefaultType(it);
    }

    private static final DasType getDefaultType$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        return (DasType)$tmp0.invoke(p0);
    }

    static {
        DasSimpleBuiltinTypeClass dasSimpleBuiltinTypeClass = DasSimpleBuiltinTypeClass.Companion.of$default(DasSimpleBuiltinTypeClass.Companion, "unknown", null, 2, null);
        UNKNOWN = new DasSimpleBuiltinType(dasSimpleBuiltinTypeClass){

            public DataType toDataType() {
                return DataType.UNKNOWN;
            }
        };
        DataType dataType = DataTypeFactory.of("reference");
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
        REFERENCE = DasDataBuiltinType.Companion.of(DasTypeCategory.REFERENCE, dataType);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/types/DasTypeSystemBase$Companion;", "", "<init>", "()V", "NULL", "Lcom/intellij/database/types/DasBuiltinType;", "VOID", "UNKNOWN", "REFERENCE", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/types/DasTypeSystemBase$DeprecatedTypeInfo;", "", "descriptionKey", "", "replacements", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getDescriptionKey", "()Ljava/lang/String;", "getReplacements", "()Ljava/util/List;", "intellij.database.core.impl"})
    public static final class DeprecatedTypeInfo {
        @NotNull
        private final String descriptionKey;
        @NotNull
        private final List<String> replacements;

        public DeprecatedTypeInfo(@NotNull String descriptionKey, @NotNull List<String> replacements) {
            Intrinsics.checkNotNullParameter((Object)descriptionKey, (String)"descriptionKey");
            Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
            this.descriptionKey = descriptionKey;
            this.replacements = replacements;
        }

        @NotNull
        public final String getDescriptionKey() {
            return this.descriptionKey;
        }

        @NotNull
        public final List<String> getReplacements() {
            return this.replacements;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasTypeCategory.values().length];
            try {
                nArray[DasTypeCategory.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.REAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BOOLEAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE_TIME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIMESTAMP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.INTERVAL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BYTES.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.RECORD.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

