/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.Dbms;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionEstablisher;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DatabaseObjectNormalizer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.ObjectNormalizer;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DbObjectFormatter;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.ui.DbDocumentationHelper;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DataSourceUtilBase;
import com.intellij.database.util.DataSourceUtilKt;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.Out;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public final class DataSourceUtil {
    private static final DateTimeFormatter ourTimestampFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @Nullable
    public static BeforeRunTaskProvider<BeforeRunTask<?>> getProvider(@NotNull Project project, Key<?> key2) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(0);
        }
        for (BeforeRunTaskProvider provider : BeforeRunTaskProvider.EP_NAME.asSequence((AreaInstance)project)) {
            if (provider.getId() != key2) continue;
            return provider;
        }
        return null;
    }

    @Nullable
    public static BeforeRunTaskProvider<BeforeRunTask<?>> getProvider(@NotNull Project project, String key2) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(1);
        }
        for (BeforeRunTaskProvider provider : BeforeRunTaskProvider.EP_NAME.asSequence((AreaInstance)project)) {
            if (!provider.getId().toString().equals(key2)) continue;
            return provider;
        }
        return null;
    }

    @NotNull
    public static <T extends EventListener, U extends T> EventDispatcher<U> eventDispatcher(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            DataSourceUtil.$$$reportNull$$$0(2);
        }
        EventDispatcher eventDispatcher = DataSourceUtilBase.eventDispatcher(listenerClass);
        if (eventDispatcher == null) {
            DataSourceUtil.$$$reportNull$$$0(3);
        }
        return eventDispatcher;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static AsyncTask<SyncQueue.SyncResult> performAutoSyncTask(@NotNull LoaderContext context) {
        if (context == null) {
            DataSourceUtil.$$$reportNull$$$0(4);
        }
        return DataSourceUtil.performAutoSyncTask(context, false);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static AsyncTask<SyncQueue.SyncResult> performAutoSyncTask(@NotNull LoaderContext context, boolean stopRunning) {
        if (context == null) {
            DataSourceUtil.$$$reportNull$$$0(5);
        }
        AsyncTask<SyncQueue.SyncResult> asyncTask = DataSourceUtilKt.performAutoSyncTask(context, stopRunning);
        if (asyncTask == null) {
            DataSourceUtil.$$$reportNull$$$0(6);
        }
        return asyncTask;
    }

    @Deprecated(forRemoval=true)
    public static void performAutoSyncTask(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(7);
        }
        if (dataSource == null) {
            DataSourceUtil.$$$reportNull$$$0(8);
        }
        DataSourceUtil.performAutoSyncTask(LoaderContext.selectGeneralTask(project, dataSource));
    }

    @Nls
    @NotNull
    public static String formatDataSourceInfoString(LocalDataSource o) {
        Casing modes = o.getCaseModes();
        NameVersion databaseVersion = o.getDatabaseVersion();
        Dbms effectiveDbms = o.getDbms();
        Dbms actualDbms = Dbms.fromString(databaseVersion.name);
        Version effectiveVersion = o.getVersion();
        String verWithFallback = StringUtil.isEmpty((String)databaseVersion.version) && !effectiveVersion.equals(Version.ZERO) ? effectiveVersion.toString() : databaseVersion.version;
        Version actualVersion = Version.parse(verWithFallback);
        boolean emptyDbName = StringUtil.isEmpty((String)databaseVersion.name);
        boolean matches = (effectiveDbms == actualDbms || emptyDbName) && (actualVersion != null && actualVersion.eqCoarse(effectiveVersion) || actualVersion == null && (effectiveVersion.eqCoarse(0) || verWithFallback.contains(effectiveVersion.toString())));
        NameVersion driverVersion = o.getDriverVersion();
        String dbmsName = emptyDbName ? effectiveDbms.getDisplayName() : databaseVersion.name;
        Object s = DatabaseBundle.message("dataSource.quickInfo.dbmsPhrase", dbmsName, verWithFallback, StringUtil.isEmpty((String)verWithFallback) ? 0 : 1);
        s = (String)s + "\n" + DatabaseBundle.message("dataSource.quickInfo.caseSensitivity2Phrase", Case.LOWER.apply(modes.plain.name()), Case.LOWER.apply(modes.quoted.name()));
        if (StringUtil.isNotEmpty((String)driverVersion.name)) {
            s = (String)s + "\n" + DatabaseBundle.message("dataSource.quickInfo.driverPhrase", driverVersion.name, driverVersion.version, o.getJDBCVersion());
        }
        if (!matches) {
            String s4 = DatabaseBundle.message("dataSource.quickInfo.effectiveVersion", effectiveDbms.getDisplayName(), effectiveVersion);
            s = (String)s + "\n" + s4;
        }
        Object object = s;
        if (object == null) {
            DataSourceUtil.$$$reportNull$$$0(9);
        }
        return object;
    }

    public static void showNotification(@NotNull Project project, @NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String message, boolean error, List<ErrorInfo.Fix> fixes) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(10);
        }
        Pair<@NlsContexts.NotificationContent String, @NotNull Collection<AnAction>> pair = DataSourceUtil.truncatePopupMessageIfNeeded(project, message, error ? DatabaseBundle.message("message.title.connection.error", new Object[0]) : title, error ? UIUtil.getErrorIcon() : UIUtil.getInformationIcon(), fixes);
        NotificationGroup group = error ? DatabaseNotifications.DATABASE_VIEW_GROUP : DatabaseNotifications.DATABASE_VIEW_LOG_GROUP;
        group.createNotification(title, (String)pair.first, error ? NotificationType.WARNING : NotificationType.INFORMATION).addActions((Collection)pair.second).setDisplayId("DataSourceUtil.generic.notification").notify(project);
    }

    public static Pair<@NlsContexts.NotificationContent String, @NotNull Collection<AnAction>> truncatePopupMessageIfNeeded(@NotNull Project project, @NlsContexts.NotificationContent String text2, @NlsContexts.DialogTitle String dialogTitle, Icon icon, List<ErrorInfo.Fix> fixes) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(11);
        }
        int maxLen = 120;
        boolean truncate = text2.length() > maxLen;
        ArrayList<DumbAwareAction> actions = new ArrayList<DumbAwareAction>(fixes.size() + 1);
        for (ErrorInfo.Fix fix : fixes) {
            actions.add(DumbAwareAction.create((String)fix.getName(), e -> {
                DatabaseUiService.getInstance().applyFix(project, fix, null);
                Notification.get((AnActionEvent)e).hideBalloon();
            }));
        }
        if (!truncate) {
            return Pair.create((Object)text2, actions);
        }
        @NlsSafe String message = text2.replace("\t", "  ");
        actions.add(DumbAwareAction.create((String)DataGridBundle.message((String)"message.hyperlink.click.for.more", (Object[])new Object[0]), e -> MessagesService.getInstance().showMessageDialog(project, null, message, dialogTitle, new String[]{CommonBundle.getOkButtonText()}, 0, 0, icon, null, true, null)));
        return Pair.create((Object)text2.substring(0, maxLen), actions);
    }

    public static void showNotification(LoaderContext context, long elapsedTime) {
        boolean isError = context.getErrorHandler().hasErrors();
        String message = StringUtil.notNullize((String)StringUtil.nullize((String)DataSourceUtil.computeMessage(context)), (String)DatabaseBundle.message("notification.content.connection.successful", new Object[0]));
        List fixes = context.getErrorHandler().getFixes();
        DataSourceUtil.showNotification(context.getProject(), context.getDataSource().getName(), message + (isError ? "" : DataSourceUtil.getElapsedString(elapsedTime)), isError, fixes);
    }

    static void showOutdatedCheckErrorNotification(LoaderContext context, long elapsedTime) {
        String message = DataSourceUtil.computeMessage(context);
        String title = context.getDataSource().getName();
        Pair<String, @NotNull Collection<AnAction>> pair = DataSourceUtil.truncatePopupMessageIfNeeded(context.getProject(), message + DataSourceUtil.getElapsedString(elapsedTime), DatabaseBundle.message("message.title.connection.error", new Object[0]), UIUtil.getErrorIcon(), context.getErrorHandler().getFixes());
        ((Collection)pair.second).add(DumbAwareAction.create((String)DatabaseBundle.message("action.disable.outdated.object.notification.text", new Object[0]), e -> {
            context.getDataSource().setCheckOutdated(false);
            DataSourceStorage.getProjectStorage(context.getProject()).updateDataSource(context.getDataSource());
            Notification.get((AnActionEvent)e).expire();
        }));
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(title, DatabaseBundle.message("notification.content.br.you.can.href.disable.disable.outdated.object.notification", pair.first), NotificationType.WARNING).addActions((Collection)pair.second).setDisplayId("OutdatedCheck.failed").notify(context.getProject());
    }

    @NlsContexts.NotificationContent
    @NotNull
    private static String computeMessage(LoaderContext context) {
        boolean isError = context.getErrorHandler().hasErrors();
        int n = context.countTasks();
        if (isError) {
            String summary = context.getErrorHandler().getSummary();
            String string = DataSourceUtil.escapeAngleBrackets(summary);
            if (string == null) {
                DataSourceUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        if (n > 0) {
            String string = ApplicationManager.getApplication().isInternal() ? DatabaseBundle.message("notification.content.synchronized", n) : DatabaseBundle.message("notification.content.synchronization.successful", new Object[0]);
            if (string == null) {
                DataSourceUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = DataSourceUtil.formatDataSourceInfoString(context.getDataSource()) + "\n\n" + DatabaseBundle.message("notification.content.connection.successful", new Object[0]);
        if (string == null) {
            DataSourceUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static String escapeAngleBrackets(String message) {
        return message.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private static String getElapsedString(long elapsedTime) {
        return elapsedTime > 1L ? " (" + NlsMessages.formatDuration((long)elapsedTime) + ")" : "";
    }

    @NlsSafe
    @NotNull
    public static String currentTime() {
        String string = "[" + ourTimestampFormat.format(LocalDateTime.now()) + "] ";
        if (string == null) {
            DataSourceUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    public static boolean isTransactionsSupported(@NotNull Dbms family) {
        if (family == null) {
            DataSourceUtil.$$$reportNull$$$0(16);
        }
        return DbImplUtilCore.getJdbcHelper(family).supportsTransactions();
    }

    public static boolean isDataSourceValid(@NotNull DbPsiFacade dbFacade, @NotNull DasDataSource dataSource) {
        if (dbFacade == null) {
            DataSourceUtil.$$$reportNull$$$0(17);
        }
        if (dataSource == null) {
            DataSourceUtil.$$$reportNull$$$0(18);
        }
        return dbFacade.findDataSource(dataSource.getUniqueId()) != null;
    }

    @NotNull
    public static AsyncTask<SyncQueue.SyncResult> performManualSyncTask(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull List<? extends IntrospectionTask> tasks) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(19);
        }
        if (dataSource == null) {
            DataSourceUtil.$$$reportNull$$$0(20);
        }
        if (tasks == null) {
            DataSourceUtil.$$$reportNull$$$0(21);
        }
        LoaderContext context = LoaderContext.selectTasks(project, dataSource, tasks);
        return DataSourceUtil.performManualSyncTask(context);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static AsyncTask<SyncQueue.SyncResult> performManualSyncTask(@NotNull LoaderContext context) {
        if (context == null) {
            DataSourceUtil.$$$reportNull$$$0(22);
        }
        AsyncTask<SyncQueue.SyncResult> asyncTask = DataSourceUtilKt.performManualSyncTask(context);
        if (asyncTask == null) {
            DataSourceUtil.$$$reportNull$$$0(23);
        }
        return asyncTask;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static AsyncTask<SyncQueue.SyncResult> applyMappings(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(24);
        }
        if (dataSource == null) {
            DataSourceUtil.$$$reportNull$$$0(25);
        }
        return DataSourceSyncManager.getInstance().applyMappingsAsync(project, dataSource);
    }

    public static boolean setNamespacesVisible(Project project, LocalDataSource dataSource, Iterable<? extends BasicNamespace> selectedValues, boolean visible) {
        return DataSourceUtil.setPathsVisible(project, dataSource, (Iterable<ObjectPath>)JBIterable.from(selectedValues).map(ObjectPaths::of), visible);
    }

    public static boolean setPathsVisible(Project project, LocalDataSource dataSource, Iterable<ObjectPath> paths, boolean visible) {
        TreePattern newScope;
        TreePattern objects = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(paths).map(TreePatternUtils::create));
        TreePattern scope2 = dataSource.getIntrospectionScope();
        TreePattern treePattern = newScope = visible ? TreePatternUtils.union(scope2, objects) : TreePatternUtils.minus(scope2, objects);
        if (scope2.equals(newScope)) {
            return false;
        }
        dataSource.setIntrospectionScope(newScope);
        DbSrcUtils.getDataSourceStorage(dataSource.isGlobal() ? null : project).updateDataSource(dataSource);
        DataSourceUtil.applyMappings(project, dataSource);
        return true;
    }

    public static void resultSetToString(@NotNull String title, @NotNull RemoteResultSet resultSet, int size, @NotNull Dbms dbms, @NotNull DataExtractor extractor, @NotNull Out out) throws Exception {
        if (title == null) {
            DataSourceUtil.$$$reportNull$$$0(26);
        }
        if (resultSet == null) {
            DataSourceUtil.$$$reportNull$$$0(27);
        }
        if (dbms == null) {
            DataSourceUtil.$$$reportNull$$$0(28);
        }
        if (extractor == null) {
            DataSourceUtil.$$$reportNull$$$0(29);
        }
        if (out == null) {
            DataSourceUtil.$$$reportNull$$$0(30);
        }
        DataConsumer.Column[] columns = JdbcEngineUtils.getColumnDescriptors(resultSet);
        int maxLobLength = DatabaseSettings.getSettings().getBytesLimitPerValue();
        RemoteResultSet.DataRetrievingOptions options = new RemoteResultSet.DataRetrievingOptions(size, maxLobLength, false);
        List data = resultSet.getObjects(options);
        ArrayList<DataConsumer.Row> rows = new ArrayList<DataConsumer.Row>(data.size());
        if (data.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < data.size(); ++i2) {
            rows.add(DataConsumer.Row.create((int)i2, (Object[])((Object[])data.get(i2))));
        }
        out.appendText((CharSequence)String.format(title, data.size()));
        GridExtractorsUtilCore.extract((Out)out, Arrays.asList(columns), (DataExtractor)extractor, rows, (int[])new int[0]);
    }

    public static void tryLoadFirstNRows(String title, DatabaseConnection connection2, String query, Out out, int rows) throws Exception {
        if (connection2 == null) {
            return;
        }
        SmartStatements.poweredBy(connection2).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results((ThrowableConsumer<RemoteResultSet, Exception>)((ThrowableConsumer)rs -> {
            DatabaseObjectNormalizer normalizer = new DatabaseObjectNormalizer(connection2.getDbms());
            DbObjectFormatter converter = new DbObjectFormatter(connection2.getDbms(), (ObjectNormalizer)normalizer){
                final /* synthetic */ ObjectNormalizer val$normalizer;
                {
                    this.val$normalizer = objectNormalizer;
                    super(arg0);
                }

                @Nullable
                public String objectToString(@Nullable Object o, GridColumn column2, @NotNull ObjectFormatterConfig config) {
                    Object o1;
                    if (config == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((o1 = this.val$normalizer.objectToObject(o, column2)) instanceof ImageInfo) {
                        ImageInfo info2 = (ImageInfo)o1;
                        String s = super.objectToString((Object)info2.stripBytes(), column2, config);
                        return DbDocumentationHelper.createImageRefTag(info2, s);
                    }
                    String s = super.objectToString(o1, column2, config);
                    return HtmlValuesExtractor.escapeChars((String)s);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/database/util/DataSourceUtil$1", "objectToString"));
                }
            };
            Color color = Objects.requireNonNull(EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)EditorColors.DOCUMENTATION_COLOR));
            DisplayHtmlValuesExtractor extractor = new DisplayHtmlValuesExtractor(color, (ObjectFormatter)converter);
            DataSourceUtil.resultSetToString(title, rs, rows, connection2.getDbms(), (DataExtractor)extractor, out);
        })));
    }

    public static void tryLoadFirstNRows(DatabaseConnection connection2, String query, @Nls StringBuilder sb, int rows) {
        try {
            Out.Readable out = new Out.Readable();
            DataSourceUtil.tryLoadFirstNRows("", connection2, query, (Out)out, rows);
            sb.append(out.getString());
        }
        catch (Exception e) {
            DataSourceUtil.exceptionToHtml(e, DatabaseBundle.message("documentation.unable.to.load.data", new Object[0]), sb);
        }
    }

    @NotNull
    public static StringBuilder exceptionToHtml(Exception e, @Nls String str, @Nls StringBuilder sb) {
        StringBuilder stringBuilder = sb.append(str).append(":<br>").append("<code>").append(e).append("</code><br>");
        if (stringBuilder == null) {
            DataSourceUtil.$$$reportNull$$$0(31);
        }
        return stringBuilder;
    }

    @NotNull
    public static Promise<?> promiseFacadeUpdate(@NotNull DbPsiFacade facade, @Nullable Disposable parent) {
        if (facade == null) {
            DataSourceUtil.$$$reportNull$$$0(32);
        }
        AsyncPromise p2 = new AsyncPromise();
        Disposable listenerDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)((Disposable)ObjectUtils.notNull((Object)parent, (Object)facade.getProject())), (Disposable)listenerDisposable);
        facade.getProject().getMessageBus().connect(listenerDisposable).subscribe(DbPsiFacade.TOPIC, o -> {
            Disposer.dispose((Disposable)listenerDisposable);
            p2.setResult(null);
        });
        AsyncPromise asyncPromise = p2;
        if (asyncPromise == null) {
            DataSourceUtil.$$$reportNull$$$0(33);
        }
        return asyncPromise;
    }

    public static List<BeforeRunTask<?>> instantiateBeforeTasks(ConsoleRunConfiguration runConfiguration, List<LocalDataSource.BeforeTask> beforeTasks) {
        return ContainerUtil.mapNotNull(beforeTasks, t -> DataSourceUtil.instantiateBeforeRunTask(runConfiguration, t));
    }

    @Nullable
    private static BeforeRunTask<?> instantiateBeforeRunTask(ConsoleRunConfiguration runConfiguration, LocalDataSource.BeforeTask t) {
        BeforeRunTask task;
        BeforeRunTaskProvider<BeforeRunTask<?>> provider = DataSourceUtil.getProvider(runConfiguration.getProject(), t.providerId);
        BeforeRunTask beforeRunTask = task = provider == null ? null : provider.createTask((RunConfiguration)runConfiguration);
        if (task != null) {
            if (task instanceof PersistentStateComponent) {
                XmlSerializer.deserializeAndLoadState((PersistentStateComponent)((PersistentStateComponent)task), (Element)t.serialized);
            } else {
                task.readExternal(t.serialized);
            }
        }
        return task;
    }

    public static List<LocalDataSource.BeforeTask> storeBeforeTasks(List<BeforeRunTask<?>> beforeTasks) {
        return ContainerUtil.mapNotNull(beforeTasks, t -> DataSourceUtil.storeBeforeRunTask(t));
    }

    @NotNull
    private static LocalDataSource.BeforeTask storeBeforeRunTask(BeforeRunTask<?> task) {
        Element rt = new Element("task");
        if (task instanceof PersistentStateComponent) {
            XmlSerializer.serializeStateInto((PersistentStateComponent)((PersistentStateComponent)task), (Element)rt);
        } else {
            task.writeExternal(rt);
        }
        return new LocalDataSource.BeforeTask(task.getProviderId().toString(), rt);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static String getEffectiveUrl(@NotNull Project project, @NotNull RawConnectionConfig dataSource) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(34);
        }
        if (dataSource == null) {
            DataSourceUtil.$$$reportNull$$$0(35);
        }
        if (dataSource instanceof LocalDataSource) {
            DatabaseConnectionInterceptor.ProtoConnection proto2 = DataSourceUtil.getProtoConnection(project, (LocalDataSource)dataSource);
            return proto2.getUrl();
        }
        return dataSource.getUrl();
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static DatabaseConnectionInterceptor.ProtoConnection getProtoConnection(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        DatabaseConnectionInterceptor.ProtoConnection protoConnection;
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(36);
        }
        if (dataSource == null) {
            DataSourceUtil.$$$reportNull$$$0(37);
        }
        try {
            protoConnection = DatabaseConnectionEstablisher.getProtoConnectionSync(project, dataSource);
        }
        catch (Exception e) {
            ExceptionUtil.rethrow((Throwable)e);
            if (null == null) {
                DataSourceUtil.$$$reportNull$$$0(39);
            }
            return null;
        }
        if (protoConnection == null) {
            DataSourceUtil.$$$reportNull$$$0(38);
        }
        return protoConnection;
    }

    public static boolean isActive(@NotNull Project project, LocalDataSource local) {
        JdbcDriverManager manager;
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(40);
        }
        return !(manager = JdbcDriverManager.getDriverManager(project)).getActiveConfigurations(local).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 9, 12, 13, 14, 15, 23, 31, 33, 38, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerClass";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 31: 
            case 33: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DataSourceUtil";
                break;
            }
            case 4: 
            case 5: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 18: 
            case 20: 
            case 25: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbFacade";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DataSourceUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "eventDispatcher";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "performAutoSyncTask";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDataSourceInfoString";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMessage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "currentTime";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "performManualSyncTask";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "exceptionToHtml";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseFacadeUpdate";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtoConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "eventDispatcher";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 31: 
            case 33: 
            case 38: 
            case 39: {
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performAutoSyncTask";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "truncatePopupMessageIfNeeded";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isTransactionsSupported";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDataSourceValid";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "performManualSyncTask";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "applyMappings";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resultSetToString";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "promiseFacadeUpdate";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveUrl";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getProtoConnection";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 9, 12, 13, 14, 15, 23, 31, 33, 38, 39 -> new IllegalStateException(string);
        };
    }
}

