/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.actions;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.actions.ConfigureLayoutDialog;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\rH\u0002J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u000eH\u0002J(\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\fH\u0002J \u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/view/actions/ConfigureLayoutAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getConfigurationKey", "", "Lcom/intellij/openapi/actionSystem/DataContext;", "Lcom/intellij/database/model/basic/BasicNode;", "showConfigurationDialog", "project", "Lcom/intellij/openapi/project/Project;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "node", "configurationKey", "invalidateCaches", "intellij.database.impl"})
public final class ConfigureLayoutAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getProject() == null) {
            return;
        }
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        String configurationKey = this.getConfigurationKey(dataContext);
        e.getPresentation().setEnabledAndVisible(configurationKey != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        BasicNode basicNode = DatabaseContextFun.getSelectedSingleNode(dataContext);
        if (basicNode == null) {
            return;
        }
        BasicNode node = basicNode;
        String string = this.getConfigurationKey(node);
        if (string == null) {
            return;
        }
        String configurationKey = string;
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataSourceNode dataSourceNode = (DataSourceNode)CollectionsKt.singleOrNull(DatabaseContextFun.getSelectionRelatedDataSources(dataContext2));
        if (dataSourceNode == null) {
            return;
        }
        DataSourceNode dsn = dataSourceNode;
        LocalDataSource localDataSource = dsn.getLocalDataSource();
        if (localDataSource == null) {
            return;
        }
        LocalDataSource ds = localDataSource;
        this.showConfigurationDialog(project2, ds, node, configurationKey);
    }

    private final String getConfigurationKey(DataContext $this$getConfigurationKey) {
        BasicNode basicNode = DatabaseContextFun.getSelectedSingleNode($this$getConfigurationKey);
        if (basicNode == null) {
            return null;
        }
        BasicNode node = basicNode;
        return this.getConfigurationKey(node);
    }

    private final String getConfigurationKey(BasicNode $this$getConfigurationKey) {
        return $this$getConfigurationKey instanceof BasicSchema ? ((BasicSchema)$this$getConfigurationKey).getNaturalName() : null;
    }

    private final void showConfigurationDialog(Project project, LocalDataSource ds, BasicNode node, String configurationKey) {
        ConfigureLayoutDialog dialog = new ConfigureLayoutDialog(project, ds, node, configurationKey);
        dialog.show();
        if (dialog.getExitCode() == 0) {
            String configurationText = dialog.getConfigurationText();
            ds.setLayoutConfigurationFor(configurationKey, configurationText);
            this.invalidateCaches(project, ds, node);
        }
    }

    private final void invalidateCaches(Project project, LocalDataSource ds, BasicNode node) {
    }
}

