/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicGrantee;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.DasSchemaExporters;
import com.intellij.database.schemaEditor.DbObjectEditorBuilder;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.GrantForUser;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeGrant;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbEditorListener;
import com.intellij.database.schemaEditor.ui.DbObjectGrantsEditor;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseForeignKeyEditor;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.StatusText;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Component;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableGrantsEditor<G extends Grants.Grant>
extends DatabaseTableEditor.TabProvider {
    @Nullable
    private final Grants.Controller<G, ?> myController;
    @Nullable
    private final DbObjectGrantsEditor<?, G, ?> myEditor;
    private final DatabaseTableEditor myTableEditor;
    private final JComponent myComponent;
    private final BasicMetaObject<?> myMeta;
    private boolean myUpdating;

    public DatabaseTableGrantsEditor(@NotNull DatabaseTableEditor tableEditor) {
        if (tableEditor == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(0);
        }
        this.myTableEditor = tableEditor;
        Dbms dbms = tableEditor.getContext().getDbms();
        this.myMeta = (BasicMetaObject)DbImplUtilCore.getMetaModel(dbms).findMetaObjects(ObjectKind.TABLE).first();
        this.myController = tableEditor.getTable().model.getExportHelper().getContext().myGrantController;
        DbObjectGrantsEditor<?, G, ?> dbObjectGrantsEditor = this.myEditor = this.myMeta == null || this.myController == null ? null : this.createGrantsEditor(tableEditor);
        if (this.myEditor == null) {
            this.myComponent = new JPanel();
            StatusText text2 = new StatusText(){

                protected boolean isStatusVisible() {
                    return true;
                }
            };
            text2.setText(DatabaseBundle.message("status.text.no.grants", new Object[0]));
            text2.attachTo((Component)this.myComponent);
        } else {
            this.myComponent = this.myEditor.getComponent();
            this.myEditor.setEditedPath(this.getTable().getPath());
            this.myEditor.getController().getEventDispatcher().addListener((EventListener)new DbEditorListener(){

                @Override
                public void modified(@NotNull DbEditor<?, ?> editor2) {
                    if (editor2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.update();
                }

                private void update() {
                    if (DatabaseTableGrantsEditor.this.myUpdating) {
                        return;
                    }
                    DatabaseTableGrantsEditor.this.updateFromEditor();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/editors/DatabaseTableGrantsEditor$2", "modified"));
                }
            });
        }
        this.myComponent.setBorder(this.myTableEditor.getTabComponentBorder());
    }

    @Nullable
    private DbObjectGrantsEditor<?, G, ?> createGrantsEditor(@NotNull DatabaseTableEditor tableEditor) {
        if (tableEditor == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(1);
        }
        return this.createGrantsEditorImpl(tableEditor, this.myController);
    }

    @Nullable
    private <U extends BasicGrantee> DbObjectGrantsEditor<?, G, ?> createGrantsEditorImpl(@NotNull DatabaseTableEditor tableEditor, Grants.Controller<G, U> grantCtl) {
        if (tableEditor == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(2);
        }
        DbObjectEditorBuilder builder = new DbObjectEditorBuilder();
        DbEditorModelController modelController = builder.createModelControllerWithScope(tableEditor.getProject(), ModalityState.defaultModalityState(), tableEditor);
        ElementMatcher matcher = builder.createMatcher(true, modelController);
        modelController.setElementMatcher(matcher);
        ElementOwner owner = matcher.createOwner();
        modelController.setActualOwner(owner);
        ElementIdentity<?> identity = this.createIdentity(tableEditor, owner);
        DbEditorModel<?, ?> model = builder.getModelFactory().createGrantsEditorModel(modelController, identity, grantCtl);
        DbEditorController editorController = builder.createEditorController(modelController, tableEditor);
        return model == null ? null : (DbObjectGrantsEditor)builder.createObjectEditor(editorController, new DbModelRef(model));
    }

    @NotNull
    private ElementIdentity<?> createIdentity(@NotNull DatabaseTableEditor tableEditor, @NotNull ElementOwner owner) {
        BasicElement basic;
        if (tableEditor == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(3);
        }
        if (owner == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(4);
        }
        ElementIdentity<BasicElement> anyId = (basic = DatabaseTableGrantsEditor.getAnyBasic(tableEditor)) == null ? null : Objects.requireNonNull(owner.getOriginal()).identify(basic);
        return DatabaseTableGrantsEditor.getIdentity(owner, anyId, this.myMeta);
    }

    @Nullable
    private static BasicElement getAnyBasic(@NotNull DatabaseTableEditor tableEditor) {
        if (tableEditor == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(5);
        }
        for (DeObject tmp = tableEditor.getTable(); tmp != null; tmp = ((DeObject)tmp).getParent()) {
            BasicElement basic = tmp.getEditedBasic();
            if (basic == null) continue;
            return basic;
        }
        DbDataSource ds = tableEditor.getContext().getDataSource();
        return ds == null ? null : DataSourceFun.getBasicModelRoot(ds);
    }

    @NotNull
    private static ElementIdentity<?> getIdentity(@NotNull ElementOwner owner, @Nullable ElementIdentity<?> any, @NotNull BasicMetaObject<?> meta) {
        if (owner == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(6);
        }
        if (meta == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(7);
        }
        if (any != null && any.getMetaObject() == meta) {
            ElementIdentity<?> elementIdentity = any;
            if (elementIdentity == null) {
                DatabaseTableGrantsEditor.$$$reportNull$$$0(8);
            }
            return elementIdentity;
        }
        BasicMetaObject<?> parent = meta.getParent();
        ElementIdentity<?> elementIdentity = owner.create(parent == null ? null : DatabaseTableGrantsEditor.getIdentity(owner, any, parent), meta);
        if (elementIdentity == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(9);
        }
        return elementIdentity;
    }

    @Override
    public void configure(@NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (caps == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(10);
        }
        this.setTabEnabled(caps.getGrants().isSupported());
    }

    @Override
    @Nullable
    public DatabaseForeignKeyEditor startItemEditing(@NotNull DeObject any) {
        if (any == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Override
    public boolean isMyObject(@NotNull DeObject object) {
        if (object == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(12);
        }
        return false;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(13);
        }
        return jComponent;
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableEditor.getTableModel();
        if (tableEditorModel == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(14);
        }
        return tableEditorModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFromModel() {
        if (this.myEditor == null) {
            return;
        }
        this.myUpdating = true;
        try {
            Int2ObjectOpenHashMap colNames = new Int2ObjectOpenHashMap();
            for (DeColumn column2 : this.getTable().columns) {
                colNames.put((int)column2.getPosition(), (Object)column2.name);
            }
            this.myEditor.updateStructure(this.myMeta, (Int2ObjectMap<String>)colNames);
            this.myEditor.reset(DasSchemaExporters.convertGrants(this.getTable(), this.myController));
        }
        finally {
            this.myUpdating = false;
        }
    }

    public void updateFromEditor() {
        if (this.myEditor == null) {
            return;
        }
        List<GrantForUser<G>> grants = this.myEditor.getGrants();
        MultiMap<Integer, DeGrant<G>> res2 = DasSchemaExporters.convertGrants(grants);
        List<DeColumn> columns = this.getTableModel().getColumns();
        for (DeColumn column2 : columns) {
            ColumnEditorModel model = this.getTableModel().modelsCache.get(column2, ColumnEditorModel.class);
            model.setGrants((List)res2.get((Object)column2.getPosition()));
        }
        this.getTableModel().setGrants((List)res2.get(null));
        for (DeColumn column2 : columns) {
            this.getTableModel().modelsCache.get(column2, ColumnEditorModel.class).commit();
        }
        this.getTableModel().commit();
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(15);
        }
        return deTable;
    }

    public int getGrantsCount() {
        if (this.myController == null) {
            return 0;
        }
        return this.allGrants().filter((Condition)new DbImplUtilCore.HashingStrategyUnique<DeGrant<G>>(){

            public int hashCode(@Nullable DeGrant<G> object) {
                if (object == null) {
                    return 0;
                }
                return Objects.hash(object.userText, DatabaseTableGrantsEditor.this.myController.getGranteeStrategy().hashCode(object.userKey));
            }

            public boolean equals(@Nullable DeGrant<G> o1, @Nullable DeGrant<G> o2) {
                if (o1 == o2) {
                    return true;
                }
                if (o1 == null || o2 == null) {
                    return false;
                }
                return Objects.equals(o1.userText, o2.userText) && DatabaseTableGrantsEditor.this.myController.getGranteeStrategy().equals(o1.userKey, o2.userKey);
            }
        }).size();
    }

    @NotNull
    private JBIterable<DeGrant<G>> allGrants() {
        JBIterable jBIterable = JBIterable.from(this.getTable().columns).flatten(c2 -> c2.grants).append(this.getTable().grants).map(o -> o);
        if (jBIterable == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public String getTabTitle() {
        int count = this.getGrantsCount();
        String string = DatabaseBundle.message("DatabaseTableGrantsEditor.grants", count, count == 0 ? 0 : 1);
        if (string == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Override
    @Nullable
    public DatabaseEditorBaseEx getActiveEditor() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 13, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableEditor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableGrantsEditor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "any";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableGrantsEditor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentity";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableModel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "allGrants";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createGrantsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createGrantsEditorImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createIdentity";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAnyBasic";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIdentity";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "startItemEditing";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isMyObject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 13, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

