/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.providers;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.common.StringFun;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.providers.SqlCompletionProviderBase;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlForeignKeyDefinition;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlToken;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.impl.SqlPrimaryKeyDefinitionImpl;
import com.intellij.sql.psi.impl.SqlReferenceTypeElementImpl;
import com.intellij.sql.psi.impl.SqlUniqueKeyDefinitionImpl;
import com.intellij.util.ProcessingContext;
import com.intellij.util.text.StringKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J>\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J*\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/sql/completion/providers/SqlExperimentalNameCompletionProvider;", "Lcom/intellij/sql/completion/providers/SqlCompletionProviderBase;", "<init>", "()V", "doAddCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "handleConstraintItems", "knownType", "Lcom/intellij/sql/completion/providers/SqlExperimentalNameCompletionProvider$ConstraintType;", "inline", "", "tableName", "", "columnName", "workPrefix", "handleVariant", "variant", "priority", "", "ConstraintType", "Companion", "intellij.database.sql.core.impl"})
public final class SqlExperimentalNameCompletionProvider
extends SqlCompletionProviderBase {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    public static final double priority0 = 1001.0;
    @Deprecated
    public static final double priorityPK = 1000.9;
    @Deprecated
    public static final double priorityAK = 1000.8;
    @Deprecated
    public static final double priorityFK = 1000.7;
    @Deprecated
    public static final double priorityCH = 1000.6;

    @Override
    protected void doAddCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        SqlTokenType sqlTokenType;
        SqlToken nextToken;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (!Registry.Companion.is("database.completion.experimental.names")) {
            return;
        }
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement position = psiElement;
        PsiElement curr = position.getParent();
        while (curr instanceof SqlIdentifier || curr instanceof SqlReferenceExpression || curr instanceof SqlReferenceTypeElementImpl) {
            curr = ((SqlElement)curr).getParent();
        }
        if (curr == null || curr instanceof PsiErrorElement) {
            return;
        }
        PsiElement psiElement2 = SqlCompletionUtil.getNonWSPrecedingLeaf(position);
        if (psiElement2 == null) {
            return;
        }
        PsiElement prevLeaf = psiElement2;
        SqlToken sqlToken = prevLeaf instanceof SqlToken ? (SqlToken)prevLeaf : null;
        if (sqlToken == null) {
            return;
        }
        SqlToken prevToken = sqlToken;
        IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)((PsiElement)prevToken));
        SqlTokenType sqlTokenType2 = iElementType instanceof SqlTokenType ? (SqlTokenType)iElementType : null;
        if (sqlTokenType2 == null) {
            return;
        }
        IElementType prevTokenType = (IElementType)sqlTokenType2;
        PsiElement nextLeaf = SqlCompletionUtil.getNonWSucceedingLeaf(position);
        SqlToken sqlToken2 = nextToken = nextLeaf instanceof SqlToken ? (SqlToken)nextLeaf : null;
        IElementType iElementType2 = sqlToken2 != null ? PsiTreeUtilKt.getElementType((PsiElement)((PsiElement)sqlToken2)) : null;
        SqlTokenType sqlTokenType3 = sqlTokenType = iElementType2 instanceof SqlTokenType ? (SqlTokenType)iElementType2 : null;
        ConstraintType knownType = Intrinsics.areEqual((Object)sqlTokenType, (Object)SqlCommonKeywords.SQL_PRIMARY) ? ConstraintType.PK : (Intrinsics.areEqual((Object)sqlTokenType, (Object)SqlCommonKeywords.SQL_UNIQUE) ? ConstraintType.AK : (Intrinsics.areEqual((Object)sqlTokenType, (Object)SqlCompositeElementTypes.SQL_REFERENCE) || Intrinsics.areEqual((Object)sqlTokenType, (Object)SqlCommonKeywords.SQL_FOREIGN) ? ConstraintType.FK : (Intrinsics.areEqual((Object)sqlTokenType, (Object)SqlCommonKeywords.SQL_CHECK) ? ConstraintType.CH : ConstraintType.NONE)));
        String workPrefix = null;
        int workPos = parameters.getOffset() - position.getTextOffset();
        if (workPos > 0) {
            String string = position.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            workPrefix = StringFun.left(string, workPos);
        }
        if (prevTokenType == SqlCommonKeywords.SQL_CONSTRAINT) {
            PsiElement psiElement3 = curr;
            if (psiElement3 instanceof SqlColumnDefinition) {
                this.handleConstraintItems(knownType, true, ((SqlColumnDefinition)curr).getTableName(), ((SqlColumnDefinition)curr).getName(), workPrefix, result2);
            } else if (psiElement3 instanceof SqlConstraintDefinition) {
                DasTable dasTable = ((SqlConstraintDefinition)curr).getTable();
                String string = dasTable != null ? dasTable.getName() : null;
                Iterable<String> iterable = ((SqlConstraintDefinition)curr).getColumnsRef().names();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"names(...)");
                this.handleConstraintItems(knownType, true, string, (String)CollectionsKt.firstOrNull(iterable), workPrefix, result2);
            } else if (psiElement3 instanceof SqlPrimaryKeyDefinitionImpl) {
                DasTable dasTable = ((SqlPrimaryKeyDefinitionImpl)curr).getTable();
                String string = dasTable != null ? dasTable.getName() : null;
                Iterable<String> iterable = ((SqlPrimaryKeyDefinitionImpl)curr).getColumnsRef().names();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"names(...)");
                this.handleConstraintItems(ConstraintType.PK, true, string, (String)CollectionsKt.firstOrNull(iterable), workPrefix, result2);
            } else if (psiElement3 instanceof SqlUniqueKeyDefinitionImpl) {
                DasTable dasTable = ((SqlUniqueKeyDefinitionImpl)curr).getTable();
                String string = dasTable != null ? dasTable.getName() : null;
                Iterable<String> iterable = ((SqlUniqueKeyDefinitionImpl)curr).getColumnsRef().names();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"names(...)");
                this.handleConstraintItems(ConstraintType.AK, true, string, (String)CollectionsKt.firstOrNull(iterable), workPrefix, result2);
            } else if (psiElement3 instanceof SqlForeignKeyDefinition) {
                DasTable dasTable = ((SqlForeignKeyDefinition)curr).getTable();
                String string = dasTable != null ? dasTable.getName() : null;
                Iterable<String> iterable = ((SqlForeignKeyDefinition)curr).getColumnsRef().names();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"names(...)");
                this.handleConstraintItems(ConstraintType.FK, true, string, (String)CollectionsKt.firstOrNull(iterable), workPrefix, result2);
            }
        } else if (prevTokenType instanceof SqlIdentifierKeywordTokenType && ((SqlIdentifierKeywordTokenType)prevTokenType).getKeyword() == SqlCommonKeywords.SQL_CONSTRAINT) {
            PsiElement psiElement4 = curr;
            if (psiElement4 instanceof SqlColumnDefinition) {
                this.handleConstraintItems(knownType, false, ((SqlColumnDefinition)curr).getTableName(), null, workPrefix, result2);
            } else if (psiElement4 instanceof SqlConstraintDefinition) {
                DasTable dasTable = ((SqlConstraintDefinition)curr).getTable();
                this.handleConstraintItems(knownType, false, dasTable != null ? dasTable.getName() : null, null, workPrefix, result2);
            }
        }
    }

    private final void handleConstraintItems(ConstraintType knownType, boolean inline, String tableName, String columnName, String workPrefix, CompletionResultSet result2) {
        CharSequence charSequence = tableName;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        String cn = StringKt.nullize((String)columnName, (boolean)true);
        switch (WhenMappings.$EnumSwitchMapping$0[knownType.ordinal()]) {
            case 1: {
                String fkWord;
                this.handleVariant(tableName + "_pk primary key", workPrefix, 1000.9, result2);
                this.handleVariant(tableName + "_ak unique", workPrefix, 1000.8, result2);
                String string = fkWord = inline ? "references" : "foreign key";
                if (cn != null) {
                    this.handleVariant(tableName + "_" + cn + "_fk " + fkWord + " ", workPrefix, 1000.7, result2);
                } else if (!inline) {
                    this.handleVariant(tableName + "_fk " + fkWord + " ", workPrefix, 1000.7, result2);
                }
                if (cn != null) {
                    this.handleVariant(tableName + "_" + columnName + "_ch check (" + columnName + " )", workPrefix, 1000.6, result2);
                    break;
                }
                if (inline) break;
                this.handleVariant(tableName + "_ch check ()", workPrefix, 1000.6, result2);
                break;
            }
            case 2: {
                this.handleVariant(tableName + "_pk", workPrefix, 1000.9, result2);
                break;
            }
            case 3: {
                this.handleVariant(tableName + "_ak", workPrefix, 1000.8, result2);
                break;
            }
            case 4: {
                if (cn != null) {
                    this.handleVariant(tableName + "_" + cn + "_fk", workPrefix, 1000.7, result2);
                    break;
                }
                this.handleVariant(tableName + "_fk", workPrefix, 1000.7, result2);
                break;
            }
            case 5: {
                if (cn != null) {
                    this.handleVariant(tableName + "_" + columnName + "_ch", workPrefix, 1000.6, result2);
                    break;
                }
                this.handleVariant(tableName + "_ch", workPrefix, 1000.6, result2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void handleVariant(String variant, String workPrefix, double priority, CompletionResultSet result2) {
        boolean matches;
        int workPrefixLength;
        String string = workPrefix;
        int n = workPrefixLength = string != null ? string.length() : 0;
        if (workPrefixLength >= variant.length()) {
            return;
        }
        boolean bl = matches = workPrefix == null || StringsKt.contains((CharSequence)variant, (CharSequence)workPrefix, (boolean)true);
        if (matches) {
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)variant, (String)variant);
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"create(...)");
            LookupElementBuilder leb = lookupElementBuilder;
            if (StringsKt.endsWith$default((CharSequence)variant, (char)')', (boolean)false, (int)2, null)) {
                leb = leb.withInsertHandler(SqlExperimentalNameCompletionProvider::handleVariant$lambda$0);
            }
            LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)leb), (double)priority);
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"withPriority(...)");
            LookupElement le = lookupElement;
            result2.addElement(le);
        }
    }

    private static final void handleVariant$lambda$0(InsertionContext context, LookupElement lookupElement) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"<unused var>");
        CaretModel caretModel = context.getEditor().getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caretModel2 = caretModel;
        int newOffset = Math.max(caretModel2.getOffset() - 1, 0);
        caretModel2.moveToOffset(newOffset);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/completion/providers/SqlExperimentalNameCompletionProvider$Companion;", "", "<init>", "()V", "priority0", "", "priorityPK", "priorityAK", "priorityFK", "priorityCH", "intellij.database.sql.core.impl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/completion/providers/SqlExperimentalNameCompletionProvider$ConstraintType;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "PK", "AK", "FK", "CH", "intellij.database.sql.core.impl"})
    private static final class ConstraintType
    extends Enum<ConstraintType> {
        public static final /* enum */ ConstraintType NONE = new ConstraintType();
        public static final /* enum */ ConstraintType PK = new ConstraintType();
        public static final /* enum */ ConstraintType AK = new ConstraintType();
        public static final /* enum */ ConstraintType FK = new ConstraintType();
        public static final /* enum */ ConstraintType CH = new ConstraintType();
        private static final /* synthetic */ ConstraintType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConstraintType[] values() {
            return (ConstraintType[])$VALUES.clone();
        }

        public static ConstraintType valueOf(String value) {
            return Enum.valueOf(ConstraintType.class, value);
        }

        @NotNull
        public static EnumEntries<ConstraintType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = constraintTypeArray = new ConstraintType[]{ConstraintType.NONE, ConstraintType.PK, ConstraintType.AK, ConstraintType.FK, ConstraintType.CH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstraintType.values().length];
            try {
                nArray[ConstraintType.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintType.PK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintType.AK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintType.FK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintType.CH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

