/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.editor.DatabaseEditorHelperCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDialectImplUtilCore {
    public static final Logger LOG = Logger.getInstance(SqlDialectImplUtilCore.class);
    public static final String DEFAULT_DIALECT_PROPERTY = "DBE.Default.Dialect";
    private static final ClearableLazyValue<Language> ourDefaultDialect = new ClearableLazyValue<Language>(){

        @NotNull
        protected Language compute() {
            SqlDialects.ensureSqlDialectsLoaded();
            PropertiesComponent properties2 = PropertiesComponent.getInstance();
            String dialectId = properties2 == null ? null : properties2.getValue(SqlDialectImplUtilCore.DEFAULT_DIALECT_PROPERTY);
            Language language = dialectId == null ? null : Language.findLanguageByID((String)dialectId);
            Language language2 = (Language)ObjectUtils.notNull((Object)language, (Object)Language.ANY);
            if (language2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return language2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtilCore$1", "compute"));
        }
    };

    protected SqlDialectImplUtilCore() {
    }

    @NotNull
    public static SqlLanguageDialectEx getDefaultSqlDialect() {
        SqlLanguageDialectEx result2 = SqlDialectImplUtilCore.getConfiguredDefaultSqlDialect();
        SqlLanguageDialectEx sqlLanguageDialectEx = result2 == null ? (SqlLanguageDialectEx)SqlDialects.getGenericDialect() : result2;
        if (sqlLanguageDialectEx == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(0);
        }
        return sqlLanguageDialectEx;
    }

    @Nullable
    public static SqlLanguageDialectEx getConfiguredDefaultSqlDialect() {
        return (SqlLanguageDialectEx)ObjectUtils.tryCast((Object)ourDefaultDialect.getValue(), SqlLanguageDialectEx.class);
    }

    public static void setDefaultSqlDialect(@Nullable SqlLanguageDialect dialect) {
        PropertiesComponent.getInstance().setValue(DEFAULT_DIALECT_PROPERTY, dialect == null ? "" : dialect.getID());
        ourDefaultDialect.drop();
    }

    public static boolean placeBefore(PsiElement p1, PsiElement p2) {
        if (p1 == null || p2 == null) {
            return true;
        }
        if (p1 instanceof StubBasedPsiElement && p2 instanceof StubBasedPsiElement) {
            StubElement s1 = ((StubBasedPsiElement)p1).getStub();
            StubElement s2 = ((StubBasedPsiElement)p2).getStub();
            if (s1 != null && s2 != null) {
                StubElement e;
                ArrayList<StubElement> parents1 = new ArrayList<StubElement>();
                for (e = s1; e != null; e = e.getParentStub()) {
                    parents1.add(e);
                }
                StubElement prevE = null;
                for (e = s2; e != null; e = e.getParentStub()) {
                    if (e == s1) {
                        return true;
                    }
                    int idx = parents1.indexOf(e);
                    if (idx != -1) {
                        if (idx == 0 || prevE == null) {
                            return true;
                        }
                        StubElement prev1 = (StubElement)parents1.get(idx - 1);
                        for (StubElement element : e.getChildrenStubs()) {
                            if (element == prev1) {
                                return true;
                            }
                            if (element != prevE) continue;
                            return false;
                        }
                        throw new AssertionError();
                    }
                    prevE = e;
                }
            }
        }
        TextRange r1 = p1.getTextRange();
        TextRange r2 = p2.getTextRange();
        return (r1 == null ? 0 : r1.getStartOffset()) <= (r2 == null ? 0 : r2.getStartOffset());
    }

    private static boolean placeInside(PsiElement p1, PsiElement p2) {
        if (p1 == null || p2 == null) {
            return true;
        }
        if (p1 instanceof StubBasedPsiElement && p2 instanceof StubBasedPsiElement) {
            StubElement s2 = ((StubBasedPsiElement)p2).getStub();
            for (StubElement s1 = ((StubBasedPsiElement)p1).getStub(); s1 != null; s1 = s1.getParentStub()) {
                if (s1 != s2) continue;
                return true;
            }
            return false;
        }
        TextRange r1 = (TextRange)ObjectUtils.notNull((Object)p1.getTextRange(), (Object)TextRange.EMPTY_RANGE);
        TextRange r2 = (TextRange)ObjectUtils.notNull((Object)p2.getTextRange(), (Object)TextRange.EMPTY_RANGE);
        return r2.contains(r1);
    }

    public static String loadDialectResource(Class<?> dialectClass, String name2) throws IOException {
        InputStream xmlIs = SqlDialectImplUtilCore.openDialectResource(dialectClass, name2);
        return xmlIs == null ? "" : FileUtil.loadTextAndClose((Reader)new InputStreamReader(xmlIs, StandardCharsets.UTF_8));
    }

    @Nullable
    public static InputStream openDialectResource(Class<?> dialectClass, String name2) {
        String dialectName = dialectClass.getName();
        String packageName = dialectName.substring(0, dialectName.lastIndexOf(46) + 1).replace('.', '/');
        String xmlResource = packageName + name2;
        return dialectClass.getClassLoader().getResourceAsStream(xmlResource);
    }

    @NotNull
    public static SqlImportState getNearestImportState(PsiElement place, SqlImportState state) {
        PsiElement p2;
        if (state.prevState == null) {
            SqlImportState sqlImportState = state;
            if (sqlImportState == null) {
                SqlDialectImplUtilCore.$$$reportNull$$$0(1);
            }
            return sqlImportState;
        }
        for (p2 = place; p2 != null; p2 = p2.getContext()) {
            if (SqlPsiElementFactory.isROFile(p2)) continue;
            if (p2 instanceof StubBasedPsiElement && ((StubBasedPsiElement)p2).getStub() != null || p2 instanceof PsiFileWithStubSupport && ((PsiFileWithStubSupport)p2).getStubTree() != null) break;
            if (!(p2 instanceof PsiFile)) continue;
            p2 = null;
            break;
        }
        if (p2 == null) {
            p2 = place;
        }
        while (state.prevState != null) {
            if (p2 != null) {
                boolean found;
                boolean bl = found = state.isEnclosing ? SqlDialectImplUtilCore.placeInside(p2, state.element) : SqlDialectImplUtilCore.placeBefore(state.element, p2);
                if (found) {
                    SqlImportState sqlImportState = state;
                    if (sqlImportState == null) {
                        SqlDialectImplUtilCore.$$$reportNull$$$0(2);
                    }
                    return sqlImportState;
                }
            }
            state = state.prevState;
        }
        SqlImportState sqlImportState = state;
        if (sqlImportState == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(3);
        }
        return sqlImportState;
    }

    @NotNull
    public static SqlImportState getImportCheckerAt(@NotNull SqlFile sqlFile, @Nullable PsiElement place) {
        if (sqlFile == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(4);
        }
        while (place != null) {
            PsiFile file = place.getContainingFile();
            if (file instanceof SqlFile) {
                sqlFile = (SqlFile)file;
            }
            if (file == sqlFile) break;
            place = file.getContext();
        }
        return SqlDialectImplUtilCore.getNearestImportState(place, SqlDialectImplUtilCore.buildImports(sqlFile));
    }

    @NotNull
    public static SqlImportState buildImports(SqlFile sqlFile) {
        SqlImportState sqlImportState = (SqlImportState)CachedValuesManager.getCachedValue((PsiElement)sqlFile, () -> CachedValueProvider.Result.create((Object)SqlDialectImplUtilCore.calcImports(sqlFile), SqlFileImpl.getMaximalDependencies((PsiElement)sqlFile)));
        if (sqlImportState == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(5);
        }
        return sqlImportState;
    }

    @Nullable
    public static TreePattern buildOverlayPattern(SqlFile sqlFile) {
        return (TreePattern)CachedValuesManager.getCachedValue((PsiElement)sqlFile, () -> CachedValueProvider.Result.create((Object)SqlDialectImplUtilCore.calcOverlayPattern(sqlFile), SqlFileImpl.getMaximalDependencies((PsiElement)sqlFile)));
    }

    protected static TreePattern calcOverlayPattern(SqlFile sqlFile) {
        PsiFile hostFile;
        SqlFile original = (SqlFile)ObjectUtils.tryCast((Object)sqlFile.getOriginalFile(), SqlFile.class);
        if (original != null && original != sqlFile) {
            return SqlDialectImplUtilCore.buildOverlayPattern(original);
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)sqlFile.getProject()).getInjectionHost((PsiElement)sqlFile);
        PsiFile psiFile = hostFile = host == null ? null : host.getContainingFile();
        if (hostFile instanceof SqlFile) {
            return SqlDialectImplUtilCore.calcOverlayPattern((SqlFile)hostFile);
        }
        if (DbSrcUtilsCore.isDbSrcFile(sqlFile.getVirtualFile())) {
            return null;
        }
        SearchPath searchPath = DatabaseEditorHelperCore.getSearchPath((PsiFile)sqlFile);
        DbDataSource dataSource = DbImplUtilCore.getForcedDataSource((PsiFile)sqlFile);
        return ((SqlLanguageDialectEx)sqlFile.getSqlLanguage()).forcedContextPattern(dataSource, searchPath);
    }

    @NotNull
    protected static SqlImportState calcImports(SqlFile sqlFile) {
        SqlImportState sqlImportState = ((SqlLanguageDialectEx)sqlFile.getSqlLanguage()).getImportBuilder().buildImports(sqlFile);
        if (sqlImportState == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(6);
        }
        return sqlImportState;
    }

    public static boolean checkImports(@NotNull SqlImportState checker, @Nullable DasDataSource dataSource, DasObject object) {
        if (checker == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(7);
        }
        return checker.isImported(dataSource, object);
    }

    public static Set<String> getAllKeywordsFromDefinition(Collection<BuiltinFunction> definitions, Set<String> keywords) {
        for (BuiltinFunction definition : definitions) {
            for (BuiltinFunction.Prototype prototype : definition.getPrototypes()) {
                SqlDialectImplUtilCore.getAllKeywordsFromDefinition((BuiltinFunction.ParameterBlock)prototype, keywords);
            }
        }
        return keywords;
    }

    public static void getAllKeywordsFromDefinition(BuiltinFunction.ParameterBlock block, Set<String> keywords) {
        for (BuiltinFunction.Parameter parameter : block.getParams()) {
            if (parameter instanceof BuiltinFunction.Keyword) {
                keywords.add(((BuiltinFunction.Keyword)parameter).getName());
                continue;
            }
            if (!(parameter instanceof BuiltinFunction.ParameterBlock)) continue;
            SqlDialectImplUtilCore.getAllKeywordsFromDefinition((BuiltinFunction.ParameterBlock)parameter, keywords);
        }
    }

    @Contract(value="null,null,null->null")
    public static TreePattern createObjectPattern(@Nullable ObjectName[] dsNames, @Nullable DasObject object, TreePatternNode.Group ... tail) {
        if (object == null && dsNames == null) {
            return null;
        }
        SmartList kinds = new SmartList();
        SmartList names = new SmartList();
        SqlImportState.getPartialTrace(SqlDialectImplUtilCore.trace(object), (List<ObjectKind>)kinds, (List)names, null);
        kinds.add(SqlImportUtil.DATA_SOURCE);
        names.add(dsNames);
        return SqlImportUtil.createPattern(names, (List<ObjectKind>)kinds, tail);
    }

    @Nullable
    public static ObjectTracer<DasObject> trace(@Nullable DasObject element) {
        return element == null || element.getKind() == ObjectKind.NONE || element.getKind() == ObjectKind.ROOT ? null : new DasObjectTracer(element);
    }

    @Contract(value="null,_,null,null->null")
    public static TreePattern createObjectPattern(@Nullable ObjectName[] dsNames, @NotNull Dbms dbms, @Nullable ObjectPath object, TreePatternNode.Group ... tail) {
        List<ObjectKind> path;
        if (dbms == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(8);
        }
        if (object == null && dsNames == null) {
            return null;
        }
        SmartList kinds = new SmartList();
        SmartList names = new SmartList();
        if (object != null && (path = SqlImportUtil.getSingleRootPath(object.kind, dbms)) != null) {
            int e = path.size() - 1;
            for (int i2 = 0; i2 < e; ++i2) {
                kinds.add(path.get(i2));
                if (object != null) {
                    names.add(new ObjectName(object.name, object.isQuoted()));
                } else {
                    names.add(ObjectName.quoted(""));
                }
                object = object == null ? null : object.parent;
            }
        }
        kinds.add(SqlImportUtil.DATA_SOURCE);
        names.add(dsNames);
        return SqlImportUtil.createPattern(names, (List<ObjectKind>)kinds, tail);
    }

    @Nullable
    public static String getUserName(@Nullable RawConnectionConfig config) {
        LocalDataSource ds = DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)((Object)config));
        if (ds == null) {
            return null;
        }
        String username = StringUtil.nullize((String)ds.getUsername());
        if (username != null) {
            return username;
        }
        JdbcUrlParser parser2 = SqlDialectImplUtilCore.getParsed(config);
        return parser2 == null ? null : StringUtil.nullize((String)parser2.getParameter("user"));
    }

    @Nullable
    public static JdbcUrlParser getParsed(@Nullable RawConnectionConfig config) {
        if (config == null) {
            return null;
        }
        JdbcUrlParser stateful = JdbcUrlParserUtil.stateful(JdbcUrlParserUtil.select(config));
        if (stateful != null) {
            stateful.setUrlText(config.getUrl());
            return stateful;
        }
        return null;
    }

    @Nullable
    public static String getDatabaseName(@Nullable RawConnectionConfig config) {
        JdbcUrlParser stateful = SqlDialectImplUtilCore.getParsed(config);
        return stateful != null ? StringUtil.nullize((String)stateful.getParameter("database")) : null;
    }

    public static Set<String> loadSystemVars(SqlLanguageDialect dialect) {
        return SqlDialectImplUtilCore.loadTokens(dialect, "systemVars.txt");
    }

    public static Set<String> loadTokens(SqlLanguageDialect dialect, String fileName) {
        Set result2 = CollectionFactory.createCaseInsensitiveStringSet();
        try {
            String tokens = SqlDialectImplUtilCore.loadDialectResource(dialect.getClass(), fileName);
            if (StringUtil.isNotEmpty((String)tokens)) {
                Collections.addAll(result2, tokens.split("(?m)\\s+"));
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return result2;
    }

    public static List<ReservedEntity> loadObjects(SqlLanguageDialect dialect, String fileName) {
        ArrayList<ReservedEntity> arrayList;
        InputStream stream = SqlDialectImplUtilCore.openDialectResource(dialect.getClass(), fileName);
        if (stream == null) {
            return Collections.emptyList();
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        try {
            ArrayList<ReservedEntity> res2 = new ArrayList<ReservedEntity>();
            String cur = r.readLine();
            while (cur != null) {
                if (StringUtil.isEmptyOrSpaces((String)cur)) {
                    cur = r.readLine();
                    continue;
                }
                ObjectKind kind = ObjectKind.getKind(cur = StringUtil.trimEnd((String)cur, (String)":"));
                if (kind == null) {
                    kind = (ObjectKind)SqlDbElementType.ourSqlKinds.get(cur);
                }
                if (kind == null) {
                    LOG.error("Unknown kind: " + cur);
                }
                while ((cur = r.readLine()) != null && cur.startsWith(" - ")) {
                    if (kind == null) continue;
                    cur = StringUtil.trimStart((String)cur, (String)" - ");
                    res2.add(new ReservedEntity(dialect.getDbms(), cur, kind));
                }
            }
            arrayList = res2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return Collections.emptyList();
            }
        }
        r.close();
        return arrayList;
    }

    @NotNull
    public static SqlImplUtil.Column col(@NotNull PsiElement element, @Nullable PsiElement object, @NotNull String name2, @NotNull DasType dasType) {
        if (element == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(9);
        }
        if (name2 == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(10);
        }
        if (dasType == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(11);
        }
        return SqlDialectImplUtilCore.col(element, object, name2, dasType, true);
    }

    @NotNull
    public static SqlImplUtil.Column col(final @NotNull PsiElement element, final @Nullable PsiElement object, @NotNull String name2, @NotNull DasType dasType, final boolean isQuoted) {
        if (element == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(12);
        }
        if (name2 == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(13);
        }
        if (dasType == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(14);
        }
        return new SqlImplUtil.Column(name2, dasType, (PsiElement)new SqlFileImpl.FakeDefinition(element, name2){

            @Override
            @NotNull
            public Dbms getDbms() {
                Dbms dbms = SqlImplUtil.getSqlDialectDbms(element);
                if (dbms == null) {
                    2.$$$reportNull$$$0(0);
                }
                return dbms;
            }

            @NotNull
            public ObjectKind getKind() {
                ObjectKind objectKind = ObjectKind.COLUMN;
                if (objectKind == null) {
                    2.$$$reportNull$$$0(1);
                }
                return objectKind;
            }

            @Override
            @Nullable
            public DasObject getDasParent() {
                return (DasObject)ObjectUtils.chooseNotNull((Object)((DasObject)ObjectUtils.tryCast((Object)object, DasObject.class)), (Object)((DasObject)ObjectUtils.tryCast((Object)element, DasObject.class)));
            }

            public boolean isNameQuoted() {
                return isQuoted;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/dialects/SqlDialectImplUtilCore$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDbms";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKind";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }, null);
    }

    @NotNull
    public static TreePattern forcedContextExpandedToSchemas(@Nullable DbDataSource dataSource, @NotNull Dbms dbms, @Nullable SearchPath searchPath, TreePatternNode.Group[] schemas, TreePatternNode.Group[] databases) {
        if (dbms == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(15);
        }
        ObjectName[] dsNames = SqlImportUtil.getRealDsNames(dataSource);
        Function expandPath = n -> {
            TreePatternNode.Group[] tail = null;
            if (n == null || n.kind == ObjectKind.NONE) {
                tail = databases;
            } else if (n.kind == ObjectKind.DATABASE) {
                ObjectName[] currentSchemas = SqlDialectImplUtilCore.getCurrentSchemasFor(dataSource, n);
                tail = currentSchemas == null ? schemas : SqlImportUtil.optAr(TreePatternUtils.create(currentSchemas, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            }
            return SqlDialectImplUtilCore.createObjectPattern(dsNames, dbms, n, tail);
        };
        List<ObjectPath> elements = SearchPath.getElements(searchPath);
        if (elements.isEmpty()) {
            TreePattern treePattern = dsNames == null ? TreePattern.EMPTY : (TreePattern)expandPath.fun(null);
            if (treePattern == null) {
                SqlDialectImplUtilCore.$$$reportNull$$$0(16);
            }
            return treePattern;
        }
        TreePattern treePattern = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(elements).transform(expandPath));
        if (treePattern == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(17);
        }
        return treePattern;
    }

    @Nullable
    private static ObjectName[] getCurrentSchemasFor(@Nullable DbDataSource dataSource, @NotNull ObjectPath db) {
        if (db == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(18);
        }
        if (dataSource == null) {
            return null;
        }
        List names = DbSqlUtilCore.findObjects(dataSource, db).filter(DasUtil.byKind(ObjectKind.DATABASE)).flatten(o -> o.getDasChildren(ObjectKind.SCHEMA).filter(BasicMateNamespace.class).filter(n -> n.isCurrent())).map(o -> new ObjectName(o.getName(), DbSqlUtilCore.isQuoted(o))).toList();
        return names.isEmpty() ? null : ObjectName.toArray(names);
    }

    @NotNull
    public static Map<String, ReservedEntity> buildEntities(@NotNull Dbms dbms, @NotNull ObjectKind kind, String ... names) {
        if (dbms == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(19);
        }
        if (kind == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(20);
        }
        LinkedHashMap<String, ReservedEntity> result2 = new LinkedHashMap<String, ReservedEntity>();
        for (String name2 : names) {
            result2.put(name2, new ReservedEntity(dbms, name2, kind));
        }
        LinkedHashMap<String, ReservedEntity> linkedHashMap = result2;
        if (linkedHashMap == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(21);
        }
        return linkedHashMap;
    }

    public static TreePattern refPatternExpandedToSchema(@NotNull TreePattern prev2, @NotNull SqlReferenceExpression ref2, @NotNull SqlLanguageDialectEx dialect) {
        if (prev2 == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(22);
        }
        if (ref2 == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(23);
        }
        if (dialect == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(24);
        }
        ObjectName refName = new ObjectName(ref2.getName(), ref2.isQuotedIdentifier());
        SearchPath refPath = SearchPath.of(ObjectPath.create(refName.name, ObjectKind.DATABASE, refName.quoted, null, null));
        TreePatternNode.Group dsGroup = prev2.root.getGroup(SqlImportUtil.DATA_SOURCE);
        if (dsGroup == null) {
            return dialect.forcedContextPattern(null, refPath);
        }
        NotNullLazyValue anyGroups = NotNullLazyValue.lazy(() -> {
            TreePatternNode.Group d = dialect.forcedContextPattern(null, (SearchPath)refPath).root.getGroup(SqlImportUtil.DATA_SOURCE);
            TreePatternNode dc = TreePatternUtils.findNegativeChild(d);
            return dc == null ? TreePatternNode.NO_GROUPS : dc.groups;
        });
        TreePattern n = null;
        TreePatternNode negativeChild = TreePatternUtils.findNegativeChild(dsGroup);
        if (negativeChild != null) {
            TreePatternNode.Group[] any = (TreePatternNode.Group[])anyGroups.getValue();
            n = any.length == 0 ? null : new TreePattern(new TreePatternNode.Group(SqlImportUtil.DATA_SOURCE, new TreePatternNode[]{new TreePatternNode(negativeChild.naming, any)}));
        }
        DbPsiFacade facade = DbPsiFacade.getInstance(ref2.getProject());
        SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)ref2.getContainingFile(), SqlFile.class);
        TreePattern scopePattern = file == null ? null : SqlImportUtil.getResolveScopePattern(file);
        ArrayList matched = new ArrayList();
        ArrayList matched2 = new ArrayList();
        Casing casing = dialect.getCasing(ObjectKind.DATABASE, null);
        return TreePatternUtils.union((Iterable<TreePattern>)JBIterable.of((Object[])dsGroup.children).flatten(c2 -> JBIterable.of((Object[])c2.naming.names)).filterMap(dsName -> {
            matched.clear();
            if (scopePattern != null) {
                scopePattern.root.matchedChildren((ObjectName)dsName, Casing.EXACT, SqlImportUtil.DATA_SOURCE, matched);
            }
            matched2.clear();
            for (TreePatternNode node : matched) {
                node.matchedChildren(refName, casing, ObjectKind.DATABASE, matched2);
            }
            if (!matched2.isEmpty()) {
                TreePatternNode.PositiveNaming naming = new TreePatternNode.PositiveNaming(refName);
                return new TreePattern(TreePatternUtils.create(dsName, SqlImportUtil.DATA_SOURCE, TreePatternUtils.create(refName, ObjectKind.DATABASE, TreePatternUtils.UNION_PROCESSOR.mergeNodes(naming, ObjectKind.DATABASE, matched2))));
            }
            DbDataSource ds = facade.findDataSource(dsName.name);
            if (ds != null) {
                return dialect.forcedContextPattern(ds, refPath);
            }
            if (dsName != SqlImportUtil.NON_MATCHING_NAME) {
                return null;
            }
            TreePatternNode.Group[] any = (TreePatternNode.Group[])anyGroups.getValue();
            return any.length == 0 ? null : new TreePattern(TreePatternUtils.create(dsName, SqlImportUtil.DATA_SOURCE, any));
        }).append((Object)n).collect());
    }

    public static boolean isLabelOrRoutineQualification(@Nullable PsiElement element, ObjectKind type, @Nullable PsiElement place, boolean isCompletion) {
        if (type == SqlDbElementType.LABEL || type == ObjectKind.ROUTINE) {
            if (place == null) {
                return false;
            }
            SqlReferenceExpression ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class);
            if (element != null) {
                PsiElement sc;
                PsiElement psiElement = sc = type == SqlDbElementType.LABEL ? element.getParent() : element;
                if (!SqlDialectImplUtilCore.isAncestorOrOriginalAncestor(sc, place)) {
                    ref2 = null;
                }
            }
            if (ref2 != null && (isCompletion || ref2.getQualifierExpression() == null && ref2.getParent() instanceof SqlReferenceExpression)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isAncestorOrOriginalAncestor(@NotNull PsiElement ancestor, @NotNull PsiElement place) {
        if (ancestor == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(25);
        }
        if (place == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(26);
        }
        PsiFile placeFile = place.getContainingFile();
        PsiFile ancestorFile = ancestor.getContainingFile();
        if (ancestorFile == placeFile) {
            return PsiTreeUtil.isContextAncestor((PsiElement)ancestor, (PsiElement)place, (boolean)true);
        }
        if (placeFile != null && ancestorFile == placeFile.getOriginalFile()) {
            return ancestor.getTextRange().contains(place.getTextRange().getStartOffset());
        }
        return false;
    }

    public static <T> JBIterable<T> staticFields(@NotNull Class<?> clazz, @NotNull Class<T> fieldC) {
        if (clazz == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(27);
        }
        if (fieldC == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(28);
        }
        return JBIterable.of((Object[])clazz.getFields()).filter(field -> Modifier.isStatic(field.getModifiers()) && fieldC.isAssignableFrom(field.getType())).transform(field -> {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }).filter(Conditions.notNull()).filter(fieldC);
    }

    public static List<ReservedEntity.Typed> loadEntities(SqlLanguageDialectEx dialect) {
        ArrayList<ReservedEntity.Typed> result2 = new ArrayList<ReservedEntity.Typed>();
        String invalid = null;
        Map kindMap = CollectionFactory.createCaseInsensitiveStringMap();
        for (ObjectKind kind : SqlDialectImplUtilCore.staticFields(SqlDbElementType.class, ObjectKind.class)) {
            kindMap.put(kind.name(), kind);
        }
        Map typeMap = CollectionFactory.createCaseInsensitiveStringMap();
        try {
            String tokens = SqlDialectImplUtilCore.loadDialectResource(dialect.getClass(), "simpleEntities.txt");
            if (StringUtil.isNotEmpty((String)tokens)) {
                for (String typed : tokens.split("(?m)\\n")) {
                    String[] split = typed.split(":");
                    String name2 = split[0].trim();
                    ObjectKind objectType = (ObjectKind)kindMap.get(split[1].trim());
                    String typeName = split.length < 3 ? null : split[2].trim();
                    DasType type = null;
                    if (typeName != null) {
                        type = (DasType)typeMap.get(typeName);
                        if (type == null) {
                            type = DasUnresolvedTypeReference.of(DataTypeFactory.of(typeName));
                            typeMap.put(typeName, type);
                        }
                        if (split.length != 3 || objectType == null) {
                            if (invalid != null) continue;
                            invalid = typed;
                            continue;
                        }
                    }
                    result2.add(new ReservedEntity.Typed(dialect.getDbms(), name2, objectType, type));
                }
            }
            if (invalid != null) {
                LOG.error("Invalid entity: `" + invalid + "`");
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlDialectImplUtilCore";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 8: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "db";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldC";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSqlDialect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNearestImportState";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlDialectImplUtilCore";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildImports";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcImports";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextExpandedToSchemas";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEntities";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getImportCheckerAt";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkImports";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createObjectPattern";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "col";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "forcedContextExpandedToSchemas";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentSchemasFor";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "buildEntities";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "refPatternExpandedToSchema";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAncestorOrOriginalAncestor";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "staticFields";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28 -> new IllegalArgumentException(string);
        };
    }

    public static abstract class ObjectTracer<T> {
        public abstract ObjectTraceIt<T> trace();

        public abstract ObjectKind getKind();

        public abstract String getName();

        @Nullable
        public abstract ObjectTracer<T> getParent(int var1);

        public static abstract class ObjectTraceIt<T>
        implements Iterator<T> {
            private final JBIterator<? extends T> myIt;

            public ObjectTraceIt(Iterator<? extends T> it) {
                this.myIt = JBIterator.from(it);
            }

            @Override
            public boolean hasNext() {
                return this.myIt.hasNext();
            }

            @Override
            public T next() {
                return (T)this.myIt.next();
            }

            @Override
            public void remove() {
                this.myIt.remove();
            }

            public abstract ObjectKind getKind();

            public abstract String getName();

            public abstract boolean isQuoted();
        }
    }

    private static class DasObjectTracer
    extends ObjectTracer<DasObject> {
        private final DasObject myElement;

        DasObjectTracer(@NotNull DasObject element) {
            if (element == null) {
                DasObjectTracer.$$$reportNull$$$0(0);
            }
            this.myElement = element;
        }

        @Override
        public ObjectTracer.ObjectTraceIt<DasObject> trace() {
            return new ObjectTracer.ObjectTraceIt<DasObject>(DasUtil.dasParents(this.myElement).filter(o -> o.getKind() != ObjectKind.ROOT).iterator()){
                private DasObject myCurrent;

                @Override
                public DasObject next() {
                    this.myCurrent = (DasObject)super.next();
                    return this.myCurrent;
                }

                @Override
                public ObjectKind getKind() {
                    return this.myCurrent.getKind();
                }

                @Override
                public String getName() {
                    return this.myCurrent.getName();
                }

                @Override
                public boolean isQuoted() {
                    return DbSqlUtilCore.isQuoted(this.myCurrent);
                }
            };
        }

        @Override
        public ObjectKind getKind() {
            return this.myElement.getKind();
        }

        @Override
        public String getName() {
            return this.myElement.getName();
        }

        @Override
        @Nullable
        public ObjectTracer<DasObject> getParent(int steps) {
            if (steps == 0) {
                return this;
            }
            DasObject parent = this.myElement;
            for (int i2 = 0; i2 < steps && parent != null; parent = parent.getDasParent(), ++i2) {
            }
            return parent == null ? null : SqlDialectImplUtilCore.trace(parent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/SqlDialectImplUtilCore$DasObjectTracer", "<init>"));
        }
    }
}

