/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql.dataFlow;

import com.intellij.psi.PsiElement;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dataFlow.SqlErrorSpecInfo;
import com.intellij.sql.dataFlow.SqlStateInfo;
import com.intellij.sql.dialects.mysql.MysqlTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlSignalStatement;
import com.intellij.sql.psi.impl.SqlSpecialErrorSpec;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0005*\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/dialects/mysql/dataFlow/MysqlErrorSpecHelper;", "Lcom/intellij/sql/dataFlow/SqlErrorSpecHelper;", "<init>", "()V", "ER_SIGNAL_WARN", "", "ER_SIGNAL_NOT_FOUND", "ER_SIGNAL_EXCEPTION", "WARNING_CODES", "", "NOT_FOUND_CODES", "getExplicitErrorCode", "Lcom/intellij/sql/psi/impl/SqlSignalStatement;", "(Lcom/intellij/sql/psi/impl/SqlSignalStatement;)Ljava/lang/Integer;", "getDefaultErrorCode", "", "sqlState", "Lcom/intellij/sql/dataFlow/SqlStateInfo;", "context", "Lcom/intellij/psi/PsiElement;", "getSqlStateByErrorCode", "errorCode", "getNotFoundErrorSpec", "Lcom/intellij/sql/dataFlow/SqlErrorSpecInfo;", "intellij.database.dialects.mysqlbase"})
public final class MysqlErrorSpecHelper
extends SqlErrorSpecHelper {
    @NotNull
    public static final MysqlErrorSpecHelper INSTANCE = new MysqlErrorSpecHelper();
    private static final int ER_SIGNAL_WARN = 1642;
    private static final int ER_SIGNAL_NOT_FOUND = 1643;
    private static final int ER_SIGNAL_EXCEPTION = 1644;
    @NotNull
    private static final Set<Integer> WARNING_CODES;
    @NotNull
    private static final Set<Integer> NOT_FOUND_CODES;

    private MysqlErrorSpecHelper() {
    }

    private final Integer getExplicitErrorCode(SqlSignalStatement $this$getExplicitErrorCode) {
        for (SqlSetAssignment infoItem : SqlImplUtil.sqlChildren((PsiElement)$this$getExplicitErrorCode.getOptionsClause()).filter(SqlSetAssignment.class)) {
            PsiElement psiElement = infoItem.getFirstChild();
            if (!Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)MysqlTypes.MYSQL_MYSQL_ERRNO)) continue;
            SqlElement sqlElement = infoItem.getRValue();
            Object object = sqlElement instanceof SqlLiteralExpression ? (SqlLiteralExpression)sqlElement : null;
            return object != null && (object = object.getText()) != null ? Integer.valueOf(Integer.parseInt((String)object)) : null;
        }
        return null;
    }

    @Override
    @Nullable
    public Object getDefaultErrorCode(@NotNull SqlStateInfo sqlState, @Nullable PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)sqlState, (String)"sqlState");
        SqlSignalStatement sqlSignalStatement = context instanceof SqlSignalStatement ? (SqlSignalStatement)context : null;
        if (sqlSignalStatement == null) {
            return null;
        }
        SqlSignalStatement signalStatement = sqlSignalStatement;
        Object object = sqlState instanceof SqlStateInfo.Specific ? (SqlStateInfo.Specific)sqlState : null;
        if (object == null || (object = ((SqlStateInfo.Specific)object).getValue()) == null) {
            return null;
        }
        Object sqlStateValue = object;
        Integer n = this.getExplicitErrorCode(signalStatement);
        if (n == null) {
            n = StringsKt.startsWith$default((String)sqlStateValue, (String)"00", (boolean)false, (int)2, null) ? null : (StringsKt.startsWith$default((String)sqlStateValue, (String)"01", (boolean)false, (int)2, null) ? Integer.valueOf(1642) : (StringsKt.startsWith$default((String)sqlStateValue, (String)"02", (boolean)false, (int)2, null) ? Integer.valueOf(1643) : Integer.valueOf(1644)));
        }
        return n;
    }

    @Override
    @Nullable
    public SqlStateInfo getSqlStateByErrorCode(@NotNull Object errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        Object object = errorCode;
        return Intrinsics.areEqual((Object)object, (Object)0) ? null : (CollectionsKt.contains((Iterable)WARNING_CODES, (Object)object) ? (SqlStateInfo)new SqlStateInfo.Wildcard(SqlSpecialErrorSpec.Kind.WARNING) : (CollectionsKt.contains((Iterable)NOT_FOUND_CODES, (Object)object) ? (SqlStateInfo)new SqlStateInfo.Wildcard(SqlSpecialErrorSpec.Kind.NOT_FOUND) : (SqlStateInfo)new SqlStateInfo.Wildcard(SqlSpecialErrorSpec.Kind.EXCEPTION)));
    }

    @Override
    @NotNull
    public SqlErrorSpecInfo getNotFoundErrorSpec() {
        return new SqlErrorSpecInfo(new SqlStateInfo.Specific("02000"), 1643);
    }

    static {
        Object[] objectArray = new Integer[]{1249, 1261, 1262, 1265, 1311, 1642, 3519, 3565, 3713, 3715, 3751};
        WARNING_CODES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Integer[]{1329, 1643};
        NOT_FOUND_CODES = SetsKt.setOf((Object[])objectArray);
    }
}

