/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingModelDumper;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.openapi.util.TextRange;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0000H\u0016J\b\u0010-\u001a\u00020.H&J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00010*H\u0016J-\u0010A\u001a\u00020.2\n\b\u0002\u0010B\u001a\u0004\u0018\u0001012\n\b\u0002\u0010C\u001a\u0004\u0018\u00010'2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010<H\u0086\bJ\n\u0010E\u001a\u0004\u0018\u000101H\u0016J\b\u0010F\u001a\u00020'H\u0016J\n\u0010G\u001a\u0004\u0018\u00010<H\u0016J\b\u0010H\u001a\u00020.H\u0002J\b\u0010I\u001a\u00020\u0014H\u0016J\b\u0010J\u001a\u00020\u0014H\u0016J\b\u0010K\u001a\u00020\u0014H\u0016J\b\u0010L\u001a\u00020\u0014H\u0016J\b\u0010M\u001a\u00020\u0014H\u0016J\u0012\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010P\u001a\u00020QH\u0016J\b\u0010R\u001a\u00020.H&J\b\u0010S\u001a\u00020.H&J\n\u0010T\u001a\u0004\u0018\u000101H\u0016J\u0010\u0010a\u001a\u00020\u00142\u0006\u0010b\u001a\u00020cH&J\u0006\u0010d\u001a\u00020OJ\b\u0010e\u001a\u00020\fH\u0016J\u001c\u0010f\u001a\u0004\u0018\u00010g2\b\u0010h\u001a\u0004\u0018\u00010\u00012\u0006\u0010i\u001a\u00020\u0001H\u0016J\u0010\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020\u0010H\u0016J\b\u0010m\u001a\u00020\u0014H\u0016J\b\u0010n\u001a\u00020OH\u0016J\n\u0010o\u001a\u0004\u0018\u00010OH\u0014J\b\u0010p\u001a\u00020OH\u0016R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00000*X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001c\u00100\u001a\u0004\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001c\u00106\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001c\u0010;\u001a\u0004\u0018\u00010<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0011\u0010U\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\bU\u0010\u0017R\u0011\u0010V\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\bV\u0010\u0017R\u0016\u0010W\u001a\u0004\u0018\u00010\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u0010\u0006R\u0016\u0010Y\u001a\u0004\u0018\u00010\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bZ\u0010\u0006R\u0016\u0010[\u001a\u0004\u0018\u00010\\8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b]\u0010^R\u0016\u0010_\u001a\u0004\u0018\u00010\\8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b`\u0010^\u0082\u0001\u0004qr\\s\u00a8\u0006t"}, d2={"Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/formatting/Block;", "<init>", "()V", "parent", "getParent", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "getContext", "()Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "range", "Lcom/intellij/openapi/util/TextRange;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "minLength", "", "getMinLength", "()I", "value", "", "hasUserBreaks", "getHasUserBreaks", "()Z", "setHasUserBreaks", "(Z)V", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "getRole", "()Lcom/intellij/sql/formatter/model/BlockRole;", "setRole", "(Lcom/intellij/sql/formatter/model/BlockRole;)V", "shape", "Lcom/intellij/sql/formatter/model/BlockShape;", "getShape", "()Lcom/intellij/sql/formatter/model/BlockShape;", "setShape", "(Lcom/intellij/sql/formatter/model/BlockShape;)V", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "nestedBlocks", "", "getNestedBlocks", "()Ljava/util/List;", "grow", "", "getSubBlocks", "myWrap", "Lcom/intellij/formatting/Wrap;", "getMyWrap", "()Lcom/intellij/formatting/Wrap;", "setMyWrap", "(Lcom/intellij/formatting/Wrap;)V", "myIndent", "getMyIndent", "()Lcom/intellij/formatting/Indent;", "setMyIndent", "(Lcom/intellij/formatting/Indent;)V", "myAlign", "Lcom/intellij/formatting/Alignment;", "getMyAlign", "()Lcom/intellij/formatting/Alignment;", "setMyAlign", "(Lcom/intellij/formatting/Alignment;)V", "setAttributes", "wrap", "indent", "align", "getWrap", "getIndent", "getAlignment", "ensureModelProcessed", "requiresPrecedingBreak", "requiresFollowingBreak", "tailFormed", "tailCompleted", "incomplete", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "analyze", "refine", "getTransitiveWrap", "isFirst", "isLast", "firstNestedSqlBlock", "getFirstNestedSqlBlock", "lastNestedSqlBlock", "getLastNestedSqlBlock", "firstLeafBlock", "Lcom/intellij/sql/formatter/model/SqlLeafBlock;", "getFirstLeafBlock", "()Lcom/intellij/sql/formatter/model/SqlLeafBlock;", "lastLeafBlock", "getLastLeafBlock", "contains", "char", "", "dump", "getTextRange", "getSpacing", "Lcom/intellij/formatting/Spacing;", "child1", "child2", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "isIncomplete", "getDebugName", "getDebugNameSuffix", "toString", "Lcom/intellij/sql/formatter/model/SqlFlowBlock;", "Lcom/intellij/sql/formatter/model/SqlInjectionHostBlock;", "Lcom/intellij/sql/formatter/model/SqlRootBlock;", "intellij.database.sql.core.impl"})
public abstract class SqlBlock
implements Block {
    private boolean hasUserBreaks;
    @NotNull
    private BlockRole role = BlockRole.NOTHING;
    @NotNull
    private BlockShape shape = BlockShape.NOT_DECIDED;
    @Nullable
    private Wrap myWrap;
    @Nullable
    private Indent myIndent;
    @Nullable
    private Alignment myAlign;

    private SqlBlock() {
    }

    @Nullable
    public abstract SqlBlock getParent();

    @NotNull
    public abstract SqlFormattingContext getContext();

    @NotNull
    public abstract TextRange getRange();

    public abstract int getMinLength();

    public final boolean getHasUserBreaks() {
        return this.hasUserBreaks;
    }

    protected final void setHasUserBreaks(boolean bl) {
        this.hasUserBreaks = bl;
    }

    @NotNull
    public final BlockRole getRole() {
        return this.role;
    }

    public final void setRole(@NotNull BlockRole blockRole) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockRole), (String)"<set-?>");
        this.role = blockRole;
    }

    @NotNull
    public final BlockShape getShape() {
        return this.shape;
    }

    public final void setShape(@NotNull BlockShape blockShape) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockShape), (String)"<set-?>");
        this.shape = blockShape;
    }

    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @NotNull
    public abstract List<SqlBlock> getNestedBlocks();

    public abstract void grow();

    @NotNull
    public List<Block> getSubBlocks() {
        this.grow();
        return this.getNestedBlocks();
    }

    @Nullable
    public final Wrap getMyWrap() {
        return this.myWrap;
    }

    public final void setMyWrap(@Nullable Wrap wrap) {
        this.myWrap = wrap;
    }

    @Nullable
    public final Indent getMyIndent() {
        return this.myIndent;
    }

    public final void setMyIndent(@Nullable Indent indent) {
        this.myIndent = indent;
    }

    @Nullable
    public final Alignment getMyAlign() {
        return this.myAlign;
    }

    public final void setMyAlign(@Nullable Alignment alignment) {
        this.myAlign = alignment;
    }

    public final void setAttributes(@Nullable Wrap wrap, @Nullable Indent indent, @Nullable Alignment align) {
        boolean $i$f$setAttributes = false;
        this.setMyWrap(wrap);
        this.setMyIndent(indent);
        this.setMyAlign(align);
    }

    public static /* synthetic */ void setAttributes$default(SqlBlock $this, Wrap wrap, Indent indent, Alignment align, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setAttributes");
        }
        if ((n & 1) != 0) {
            wrap = $this.getMyWrap();
        }
        if ((n & 2) != 0) {
            indent = $this.getMyIndent();
        }
        if ((n & 4) != 0) {
            align = $this.getMyAlign();
        }
        boolean $i$f$setAttributes = false;
        $this.setMyWrap(wrap);
        $this.setMyIndent(indent);
        $this.setMyAlign(align);
    }

    @Nullable
    public Wrap getWrap() {
        if (this.myWrap == null && this.getContext().getReformatting()) {
            this.ensureModelProcessed();
        }
        return this.myWrap;
    }

    @NotNull
    public Indent getIndent() {
        Object object;
        if (this.myIndent == null) {
            this.ensureModelProcessed();
        }
        if ((object = this.myIndent) == null) {
            SqlBlock sqlBlock = this.getParent();
            object = sqlBlock != null ? sqlBlock.defaultChildIndent(this) : null;
            if (object == null) {
                object = SqlFormattingFunKt.getNONE_INDENT();
            }
        }
        return object;
    }

    @Nullable
    public Alignment getAlignment() {
        if (this.myAlign == null) {
            this.ensureModelProcessed();
        }
        return this.myAlign;
    }

    private final void ensureModelProcessed() {
        block2: {
            if (!this.getContext().getJustAdjust()) break block2;
            SqlBlock sqlBlock = this.getParent();
            if (sqlBlock != null) {
                sqlBlock.analyze();
            }
            SqlBlock sqlBlock2 = this.getParent();
            if (sqlBlock2 != null) {
                sqlBlock2.refine();
            }
        }
    }

    public boolean requiresPrecedingBreak() {
        return SqlFormattingModelFun.isAlways(this.myWrap);
    }

    public boolean requiresFollowingBreak() {
        return false;
    }

    public boolean tailFormed() {
        return !((Collection)this.getNestedBlocks()).isEmpty() && this.role.compareTo((Enum)BlockRole.ERROR) < 0;
    }

    public boolean tailCompleted() {
        return this.tailFormed();
    }

    public boolean incomplete() {
        return false;
    }

    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        return null;
    }

    public abstract void analyze();

    public abstract void refine();

    @Nullable
    public Wrap getTransitiveWrap() {
        SqlBlock sqlBlock = this.getParent();
        return sqlBlock != null ? sqlBlock.getTransitiveWrap() : null;
    }

    public final boolean isFirst() {
        boolean bl;
        if (this.getParent() != null) {
            SqlBlock sqlBlock = this.getParent();
            Intrinsics.checkNotNull((Object)sqlBlock);
            bl = sqlBlock.getFirstNestedSqlBlock() == this;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean isLast() {
        boolean bl;
        if (this.getParent() != null) {
            SqlBlock sqlBlock = this.getParent();
            Intrinsics.checkNotNull((Object)sqlBlock);
            bl = sqlBlock.getLastNestedSqlBlock() == this;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public SqlBlock getFirstNestedSqlBlock() {
        return (SqlBlock)CollectionsKt.firstOrNull(this.getNestedBlocks());
    }

    @Nullable
    public SqlBlock getLastNestedSqlBlock() {
        return (SqlBlock)CollectionsKt.lastOrNull(this.getNestedBlocks());
    }

    @Nullable
    public SqlLeafBlock getFirstLeafBlock() {
        SqlBlock sqlBlock = this.getFirstNestedSqlBlock();
        return sqlBlock != null ? sqlBlock.getFirstLeafBlock() : null;
    }

    @Nullable
    public SqlLeafBlock getLastLeafBlock() {
        SqlBlock sqlBlock = this.getLastNestedSqlBlock();
        return sqlBlock != null ? sqlBlock.getLastLeafBlock() : null;
    }

    public abstract boolean contains(char var1);

    @NotNull
    public final String dump() {
        String string = FormattingModelDumper.dumpFormattingModelToString((Block)this);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dumpFormattingModelToString(...)");
        return string;
    }

    @NotNull
    public TextRange getTextRange() {
        return this.getRange();
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        return null;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(SqlFormattingFunKt.getNONE_INDENT(), null);
    }

    public boolean isIncomplete() {
        return this.incomplete();
    }

    @NotNull
    public String getDebugName() {
        StringBuilder b = new StringBuilder();
        if (this.role.getExists()) {
            b.append(this.role.getCode()).append(':').append(' ');
        }
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        String simpleName = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)"Sql"), (CharSequence)"Block");
        b.append(simpleName);
        String suffix = this.getDebugNameSuffix();
        if (suffix != null) {
            b.append('(').append(suffix).append(')');
        }
        if (this.getMinLength() > 0 && this.getMinLength() < Integer.MAX_VALUE) {
            b.append(' ').append('[').append(this.getMinLength()).append(']');
        }
        char shapeChar = switch (WhenMappings.$EnumSwitchMapping$0[this.shape.ordinal()]) {
            case 1 -> '\u0000';
            case 2 -> '\u25b1';
            case 3 -> '\u25d2';
            case 4 -> '\u25a3';
            default -> throw new NoWhenBranchMatchedException();
        };
        if (this.shape.getExists()) {
            b.append(' ').append(shapeChar).append(' ');
        }
        String string2 = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Nullable
    protected String getDebugNameSuffix() {
        return null;
    }

    @NotNull
    public String toString() {
        return this.getDebugName();
    }

    public /* synthetic */ SqlBlock(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlockShape.values().length];
            try {
                nArray[BlockShape.NOT_DECIDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockShape.DECIDED_TO_ONE_ROW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockShape.DECIDE_LATER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockShape.DECIDED_TO_MULTI_ROWS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

