/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.util.NameChecker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlCheckUsingColumnsInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(final @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlCheckUsingColumnsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlCheckUsingColumnsInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlCheckUsingColumnsInspection.$$$reportNull$$$0(2);
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlUsingClause(SqlUsingClause o) {
                Object rightType;
                SqlReferenceList list = o.getReferenceList();
                List refs = list != null ? list.getReferenceList() : ContainerUtil.emptyList();
                PsiElement parent = o.getParent();
                if (!(parent instanceof SqlJoinExpression)) {
                    return;
                }
                SqlExpression left = ((SqlJoinExpression)parent).getLOperand();
                SqlExpression right = ((SqlJoinExpression)parent).getROperand();
                DasType leftType = left.getDasType();
                Object object = rightType = right != null ? right.getDasType() : SqlTableTypeBase.EMPTY_TABLE;
                if (!(leftType instanceof SqlTableType)) {
                    return;
                }
                if (!(rightType instanceof SqlTableType)) {
                    return;
                }
                SqlTableType extra = null;
                if (dialect.getDbms() == Dbms.CLICKHOUSE) {
                    SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)o, SqlQueryExpression.class);
                    extra = query == null ? null : (SqlTableType)ObjectUtils.tryCast((Object)query.getDasType(), SqlTableType.class);
                }
                for (SqlReferenceExpression ref2 : refs) {
                    if (!(this.matches((SqlTableType)leftType, ref2) || extra != null && this.matches(extra, ref2))) {
                        this.addWarning(ref2, true);
                        continue;
                    }
                    if (this.matches((SqlTableType)rightType, ref2)) continue;
                    this.addWarning(ref2, false);
                }
            }

            private void addWarning(SqlReferenceExpression ref2, boolean left) {
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)ref2, SqlBundle.message((String)"inspection.message.column.specified.in.using.clause.does.not.exist.in.choice.left.right.table", (Object[])new Object[]{ref2.getName(), left ? 0 : 1}), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
            }

            private boolean matches(SqlTableType type, SqlReferenceExpression ref2) {
                final NameChecker nameChecker = new NameChecker(ref2, this.myDialect, this.myDialect);
                SqlScopeProcessorBase processor2 = new SqlScopeProcessorBase(nameChecker.sourceText, this.myDialect, SqlImplUtil.getDataSources((PsiElement)ref2), (PsiElement)ref2){

                    public boolean isResultEmpty() {
                        return true;
                    }

                    public boolean executeTarget(@NotNull DasSymbol symbol, @Nullable DasType dasType, Boolean forcedCaseSens, @NotNull ResolveState state) {
                        if (symbol == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (state == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return !nameChecker.checkName(symbol, forcedCaseSens);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "symbol";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "state";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/sql/inspections/SqlCheckUsingColumnsInspection$1$1";
                        objectArray[2] = "executeTarget";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                return !SqlImplUtil.processDeclarationsInType(type, (SqlScopeProcessor)processor2, ResolveState.initial(), (PsiElement)ref2);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlCheckUsingColumnsInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

