/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.DataType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class SqlDeprecateTypeInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlFile sqlFile, final @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        Map<String, DasTypeSystemBase.DeprecatedTypeInfo> deprecatedTypes;
        if (sqlFile == null) {
            SqlDeprecateTypeInspection.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            SqlDeprecateTypeInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SqlDeprecateTypeInspection.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            SqlDeprecateTypeInspection.$$$reportNull$$$0(3);
        }
        if ((deprecatedTypes = dialect.getTypeSystem().getDeprecatedTypes((PsiFile)sqlFile)).isEmpty()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlTypeElement(SqlTypeElement o) {
                DataType dataType = dialect.getTypeSystem().normalizeType(o.getDasType().toDataType());
                String spec = dataType.getSpecification();
                DasTypeSystemBase.DeprecatedTypeInfo typeInfo = (DasTypeSystemBase.DeprecatedTypeInfo)deprecatedTypes.get(StringUtil.toLowerCase((String)spec));
                if (typeInfo == null) {
                    return;
                }
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, DatabaseBundle.message(typeInfo.getDescriptionKey(), new Object[0]), (LocalQuickFix)new ReplaceTypeFix(typeInfo.getReplacements()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sqlFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlDeprecateTypeInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReplaceTypeFix
    implements LocalQuickFix,
    DumbAware {
        @FileModifier.SafeFieldForPreview
        private final List<String> replacements;

        private ReplaceTypeFix(List<String> replacements) {
            this.replacements = replacements;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"quickfix.name.replace.deprecated.type", (Object[])new Object[0]);
            if (string == null) {
                ReplaceTypeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                ReplaceTypeFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReplaceTypeFix.$$$reportNull$$$0(2);
            }
            PsiElement startElement = descriptor2.getStartElement();
            PsiElement parent = startElement.getParent();
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(startElement);
            DdlBuilder builder = new DdlBuilder().applyCodeStyle(project, dialect).withDialect(dialect.getDatabaseDialect());
            List variants = ContainerUtil.map(this.replacements, s -> {
                builder.clear();
                builder.type((String)s);
                return builder.getStatement();
            });
            SqlTypeElement newTypeElement = SqlPsiElementFactory.createDataTypeFromText((String)variants.get(0), dialect, parent);
            if (newTypeElement == null) {
                return;
            }
            PsiElement typeInPlace = startElement.replace((PsiElement)newTypeElement);
            if (variants.size() > 1) {
                Document doc = parent.getContainingFile().getViewProvider().getDocument();
                if (doc == null) {
                    return;
                }
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(doc);
                Editor editor2 = EditorFactory.getInstance().editors(doc).findFirst().orElse(null);
                if (editor2 == null) {
                    return;
                }
                TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl(typeInPlace);
                templateBuilder.replaceElement(typeInPlace, (Expression)new ConstantNode(typeInPlace.getText()).withLookupStrings((Collection)variants));
                Template template = templateBuilder.buildInlineTemplate();
                editor2.getCaretModel().moveToOffset(typeInPlace.getTextRange().getStartOffset());
                TemplateManager.getInstance((Project)project).startTemplate(editor2, template);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlDeprecateTypeInspection$ReplaceTypeFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlDeprecateTypeInspection$ReplaceTypeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

