/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.repository;

import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.AuthenticationDigest;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;

public final class JreProxySelector
implements ProxySelector {
    @Override
    public Proxy getProxy(RemoteRepository repository) {
        Objects.requireNonNull(repository, "repository cannot be null");
        List<java.net.Proxy> proxies = null;
        try {
            URI uri = new URI(repository.getUrl()).parseServerAuthority();
            proxies = java.net.ProxySelector.getDefault().select(uri);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (proxies != null) {
            java.net.Proxy proxy;
            Iterator iterator = proxies.iterator();
            while (iterator.hasNext() && !Proxy.Type.DIRECT.equals((Object)(proxy = (java.net.Proxy)iterator.next()).type())) {
                if (!Proxy.Type.HTTP.equals((Object)proxy.type()) || !JreProxySelector.isValid(proxy.address())) continue;
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                return new Proxy("http", addr.getHostName(), addr.getPort(), JreProxyAuthentication.INSTANCE);
            }
        }
        return null;
    }

    private static boolean isValid(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)address;
            if (addr.getPort() <= 0) {
                return false;
            }
            return addr.getHostName() != null && !addr.getHostName().isEmpty();
        }
        return false;
    }

    private static final class JreProxyAuthentication
    implements Authentication {
        public static final Authentication INSTANCE = new JreProxyAuthentication();

        private JreProxyAuthentication() {
        }

        @Override
        public void fill(AuthenticationContext context, String key2, Map<String, String> data) {
            Objects.requireNonNull(context, "context cannot be null");
            Proxy proxy = context.getProxy();
            if (proxy == null) {
                return;
            }
            if (!"username".equals(key2) && !"password".equals(key2)) {
                return;
            }
            try {
                URL url;
                try {
                    url = new URL(context.getRepository().getUrl());
                }
                catch (Exception e) {
                    url = null;
                }
                PasswordAuthentication auth = Authenticator.requestPasswordAuthentication(proxy.getHost(), null, proxy.getPort(), "http", "Credentials for proxy " + proxy, null, url, Authenticator.RequestorType.PROXY);
                if (auth != null) {
                    context.put("username", auth.getUserName());
                    context.put("password", auth.getPassword());
                } else {
                    context.put("username", System.getProperty("http.proxyUser"));
                    context.put("password", System.getProperty("http.proxyPassword"));
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        @Override
        public void digest(AuthenticationDigest digest) {
            Objects.requireNonNull(digest, "digest cannot be null");
            digest.update(UUID.randomUUID().toString());
        }

        public boolean equals(Object obj2) {
            return this == obj2 || obj2 != null && this.getClass().equals(obj2.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

