/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.version;

import java.util.Objects;
import org.eclipse.aether.version.Version;

public interface VersionRange {
    public boolean containsVersion(Version var1);

    public Bound getLowerBound();

    public Bound getUpperBound();

    public static final class Bound {
        private final Version version;
        private final boolean inclusive;

        public Bound(Version version, boolean inclusive) {
            this.version = Objects.requireNonNull(version, "version cannot be null");
            this.inclusive = inclusive;
        }

        public Version getVersion() {
            return this.version;
        }

        public boolean isInclusive() {
            return this.inclusive;
        }

        public boolean equals(Object obj2) {
            if (obj2 == this) {
                return true;
            }
            if (obj2 == null || !this.getClass().equals(obj2.getClass())) {
                return false;
            }
            Bound that = (Bound)obj2;
            return this.inclusive == that.inclusive && this.version.equals(that.version);
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.version.hashCode();
            hash = hash * 31 + (this.inclusive ? 1 : 0);
            return hash;
        }

        public String toString() {
            return String.valueOf(this.version);
        }
    }
}

