/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class EntryListAdapter<V>
extends AbstractSequentialList<V> {
    private final Iterable<? extends Map.Entry<?, V>> iterable;

    public EntryListAdapter(Iterable<? extends Map.Entry<?, V>> iterable) {
        this.iterable = iterable;
    }

    @Override
    public Iterator<V> iterator() {
        return new ValueIterator(this.iterable);
    }

    @Override
    public ListIterator<V> listIterator(int index) {
        return new ValueListIterator(this.iterable, index);
    }

    @Override
    public boolean isEmpty() {
        return false == this.iterator().hasNext();
    }

    @Override
    public int size() {
        int size = 0;
        Iterator<Map.Entry<?, V>> i2 = this.iterable.iterator();
        while (i2.hasNext()) {
            ++size;
            i2.next();
        }
        return size;
    }

    private static final class ValueIterator<V>
    implements Iterator<V> {
        private final Iterator<? extends Map.Entry<?, V>> iterator;

        ValueIterator(Iterable<? extends Map.Entry<?, V>> iterable) {
            this.iterator = iterable.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return this.iterator.next().getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ValueListIterator<V>
    implements ListIterator<V> {
        private final Iterator<? extends Map.Entry<?, V>> iterator;
        private final List<Map.Entry<?, V>> entryCache = new ArrayList();
        private int index;

        ValueListIterator(Iterable<? extends Map.Entry<?, V>> iterable, int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            this.iterator = iterable.iterator();
            try {
                while (this.index < index) {
                    this.next();
                }
            }
            catch (NoSuchElementException e) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < this.entryCache.size() || this.iterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public V next() {
            if (this.index >= this.entryCache.size()) {
                this.entryCache.add(this.iterator.next());
            }
            return this.entryCache.get(this.index++).getValue();
        }

        @Override
        public V previous() {
            if (this.index <= 0) {
                throw new NoSuchElementException();
            }
            return this.entryCache.get(--this.index).getValue();
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void add(V o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(V o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

