/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.hprtree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ArrayListVisitor;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.hprtree.HilbertEncoder;
import org.locationtech.jts.index.hprtree.Item;

public class HPRtree
implements SpatialIndex {
    private static final int ENV_SIZE = 4;
    private static final int HILBERT_LEVEL = 12;
    private static int DEFAULT_NODE_CAPACITY = 16;
    private List<Item> items = new ArrayList<Item>();
    private int nodeCapacity = DEFAULT_NODE_CAPACITY;
    private Envelope totalExtent = new Envelope();
    private int[] layerStartIndex;
    private double[] nodeBounds;
    private boolean isBuilt = false;

    public HPRtree() {
        this(DEFAULT_NODE_CAPACITY);
    }

    public HPRtree(int nodeCapacity) {
        this.nodeCapacity = nodeCapacity;
    }

    public int size() {
        return this.items.size();
    }

    @Override
    public void insert(Envelope itemEnv, Object item) {
        if (this.isBuilt) {
            throw new IllegalStateException("Cannot insert items after tree is built.");
        }
        this.items.add(new Item(itemEnv, item));
        this.totalExtent.expandToInclude(itemEnv);
    }

    @Override
    public List query(Envelope searchEnv) {
        this.build();
        if (!this.totalExtent.intersects(searchEnv)) {
            return new ArrayList();
        }
        ArrayListVisitor visitor2 = new ArrayListVisitor();
        this.query(searchEnv, visitor2);
        return visitor2.getItems();
    }

    @Override
    public void query(Envelope searchEnv, ItemVisitor visitor2) {
        this.build();
        if (!this.totalExtent.intersects(searchEnv)) {
            return;
        }
        if (this.layerStartIndex == null) {
            this.queryItems(0, searchEnv, visitor2);
        } else {
            this.queryTopLayer(searchEnv, visitor2);
        }
    }

    private void queryTopLayer(Envelope searchEnv, ItemVisitor visitor2) {
        int layerIndex = this.layerStartIndex.length - 2;
        int layerSize = this.layerSize(layerIndex);
        for (int i2 = 0; i2 < layerSize; i2 += 4) {
            this.queryNode(layerIndex, i2, searchEnv, visitor2);
        }
    }

    private void queryNode(int layerIndex, int nodeOffset, Envelope searchEnv, ItemVisitor visitor2) {
        int layerStart = this.layerStartIndex[layerIndex];
        int nodeIndex = layerStart + nodeOffset;
        if (!this.intersects(nodeIndex, searchEnv)) {
            return;
        }
        if (layerIndex == 0) {
            int childNodesOffset = nodeOffset / 4 * this.nodeCapacity;
            this.queryItems(childNodesOffset, searchEnv, visitor2);
        } else {
            int childNodesOffset = nodeOffset * this.nodeCapacity;
            this.queryNodeChildren(layerIndex - 1, childNodesOffset, searchEnv, visitor2);
        }
    }

    private boolean intersects(int nodeIndex, Envelope env) {
        boolean isBeyond = env.getMaxX() < this.nodeBounds[nodeIndex] || env.getMaxY() < this.nodeBounds[nodeIndex + 1] || env.getMinX() > this.nodeBounds[nodeIndex + 2] || env.getMinY() > this.nodeBounds[nodeIndex + 3];
        return !isBeyond;
    }

    private void queryNodeChildren(int layerIndex, int blockOffset, Envelope searchEnv, ItemVisitor visitor2) {
        int nodeOffset;
        int layerStart = this.layerStartIndex[layerIndex];
        int layerEnd = this.layerStartIndex[layerIndex + 1];
        for (int i2 = 0; i2 < this.nodeCapacity && layerStart + (nodeOffset = blockOffset + 4 * i2) < layerEnd; ++i2) {
            this.queryNode(layerIndex, nodeOffset, searchEnv, visitor2);
        }
    }

    private void queryItems(int blockStart, Envelope searchEnv, ItemVisitor visitor2) {
        int itemIndex;
        for (int i2 = 0; i2 < this.nodeCapacity && (itemIndex = blockStart + i2) < this.items.size(); ++i2) {
            Item item = this.items.get(itemIndex);
            if (!HPRtree.intersects(item.getEnvelope(), searchEnv)) continue;
            visitor2.visitItem(item.getItem());
        }
    }

    private static boolean intersects(Envelope env1, Envelope env2) {
        return !(env2.getMinX() > env1.getMaxX() || env2.getMaxX() < env1.getMinX() || env2.getMinY() > env1.getMaxY() || env2.getMaxY() < env1.getMinY());
    }

    private int layerSize(int layerIndex) {
        int layerStart = this.layerStartIndex[layerIndex];
        int layerEnd = this.layerStartIndex[layerIndex + 1];
        return layerEnd - layerStart;
    }

    @Override
    public boolean remove(Envelope itemEnv, Object item) {
        return false;
    }

    public synchronized void build() {
        if (this.isBuilt) {
            return;
        }
        this.isBuilt = true;
        if (this.items.size() <= this.nodeCapacity) {
            return;
        }
        this.sortItems();
        this.layerStartIndex = HPRtree.computeLayerIndices(this.items.size(), this.nodeCapacity);
        int nodeCount = this.layerStartIndex[this.layerStartIndex.length - 1] / 4;
        this.nodeBounds = HPRtree.createBoundsArray(nodeCount);
        this.computeLeafNodes(this.layerStartIndex[1]);
        for (int i2 = 1; i2 < this.layerStartIndex.length - 1; ++i2) {
            this.computeLayerNodes(i2);
        }
    }

    private static double[] createBoundsArray(int size) {
        double[] a = new double[4 * size];
        for (int i2 = 0; i2 < size; ++i2) {
            int index = 4 * i2;
            a[index] = Double.MAX_VALUE;
            a[index + 1] = Double.MAX_VALUE;
            a[index + 2] = -1.7976931348623157E308;
            a[index + 3] = -1.7976931348623157E308;
        }
        return a;
    }

    private void computeLayerNodes(int layerIndex) {
        int layerStart = this.layerStartIndex[layerIndex];
        int childLayerStart = this.layerStartIndex[layerIndex - 1];
        int layerSize = this.layerSize(layerIndex);
        int childLayerEnd = layerStart;
        for (int i2 = 0; i2 < layerSize; i2 += 4) {
            int childStart = childLayerStart + this.nodeCapacity * i2;
            this.computeNodeBounds(layerStart + i2, childStart, childLayerEnd);
        }
    }

    private void computeNodeBounds(int nodeIndex, int blockStart, int nodeMaxIndex) {
        int index;
        for (int i2 = 0; i2 <= this.nodeCapacity && (index = blockStart + 4 * i2) < nodeMaxIndex; ++i2) {
            this.updateNodeBounds(nodeIndex, this.nodeBounds[index], this.nodeBounds[index + 1], this.nodeBounds[index + 2], this.nodeBounds[index + 3]);
        }
    }

    private void computeLeafNodes(int layerSize) {
        for (int i2 = 0; i2 < layerSize; i2 += 4) {
            this.computeLeafNodeBounds(i2, this.nodeCapacity * i2 / 4);
        }
    }

    private void computeLeafNodeBounds(int nodeIndex, int blockStart) {
        int itemIndex;
        for (int i2 = 0; i2 <= this.nodeCapacity && (itemIndex = blockStart + i2) < this.items.size(); ++i2) {
            Envelope env = this.items.get(itemIndex).getEnvelope();
            this.updateNodeBounds(nodeIndex, env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY());
        }
    }

    private void updateNodeBounds(int nodeIndex, double minX, double minY, double maxX, double maxY) {
        if (minX < this.nodeBounds[nodeIndex]) {
            this.nodeBounds[nodeIndex] = minX;
        }
        if (minY < this.nodeBounds[nodeIndex + 1]) {
            this.nodeBounds[nodeIndex + 1] = minY;
        }
        if (maxX > this.nodeBounds[nodeIndex + 2]) {
            this.nodeBounds[nodeIndex + 2] = maxX;
        }
        if (maxY > this.nodeBounds[nodeIndex + 3]) {
            this.nodeBounds[nodeIndex + 3] = maxY;
        }
    }

    private Envelope getNodeEnvelope(int i2) {
        return new Envelope(this.nodeBounds[i2], this.nodeBounds[i2 + 1], this.nodeBounds[i2 + 2], this.nodeBounds[i2 + 3]);
    }

    private static int[] computeLayerIndices(int itemSize, int nodeCapacity) {
        ArrayList<Integer> layerIndexList = new ArrayList<Integer>();
        int layerSize = itemSize;
        int index = 0;
        do {
            layerIndexList.add(index);
            layerSize = HPRtree.numNodesToCover(layerSize, nodeCapacity);
            index += 4 * layerSize;
        } while (layerSize > 1);
        return HPRtree.toIntArray(layerIndexList);
    }

    private static int numNodesToCover(int nChild, int nodeCapacity) {
        int mult = nChild / nodeCapacity;
        int total = mult * nodeCapacity;
        if (total == nChild) {
            return mult;
        }
        return mult + 1;
    }

    private static int[] toIntArray(List<Integer> list) {
        int[] array = new int[list.size()];
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = list.get(i2);
        }
        return array;
    }

    public Envelope[] getBounds() {
        int numNodes = this.nodeBounds.length / 4;
        Envelope[] bounds = new Envelope[numNodes];
        for (int i2 = numNodes - 1; i2 >= 0; --i2) {
            int boundIndex = 4 * i2;
            bounds[i2] = new Envelope(this.nodeBounds[boundIndex], this.nodeBounds[boundIndex + 2], this.nodeBounds[boundIndex + 1], this.nodeBounds[boundIndex + 3]);
        }
        return bounds;
    }

    private void sortItems() {
        ItemComparator comp = new ItemComparator(new HilbertEncoder(12, this.totalExtent));
        Collections.sort(this.items, comp);
    }

    static class ItemComparator
    implements Comparator<Item> {
        private HilbertEncoder encoder;

        public ItemComparator(HilbertEncoder encoder) {
            this.encoder = encoder;
        }

        @Override
        public int compare(Item item1, Item item2) {
            int hcode1 = this.encoder.encode(item1.getEnvelope());
            int hcode2 = this.encoder.encode(item2.getEnvelope());
            return Integer.compare(hcode1, hcode2);
        }
    }
}

