/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Intersection;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.OffsetSegmentString;

class OffsetSegmentGenerator {
    private static final double OFFSET_SEGMENT_SEPARATION_FACTOR = 0.001;
    private static final double INSIDE_TURN_VERTEX_SNAP_DISTANCE_FACTOR = 0.001;
    private static final double CURVE_VERTEX_SNAP_DISTANCE_FACTOR = 1.0E-6;
    private static final int MAX_CLOSING_SEG_LEN_FACTOR = 80;
    private double maxCurveSegmentError = 0.0;
    private double filletAngleQuantum;
    private int closingSegLengthFactor = 1;
    private OffsetSegmentString segList;
    private double distance = 0.0;
    private PrecisionModel precisionModel;
    private BufferParameters bufParams;
    private LineIntersector li;
    private Coordinate s0;
    private Coordinate s1;
    private Coordinate s2;
    private LineSegment seg0 = new LineSegment();
    private LineSegment seg1 = new LineSegment();
    private LineSegment offset0 = new LineSegment();
    private LineSegment offset1 = new LineSegment();
    private int side = 0;
    private boolean hasNarrowConcaveAngle = false;

    public OffsetSegmentGenerator(PrecisionModel precisionModel, BufferParameters bufParams, double distance) {
        this.precisionModel = precisionModel;
        this.bufParams = bufParams;
        this.li = new RobustLineIntersector();
        int quadSegs = bufParams.getQuadrantSegments();
        if (quadSegs < 1) {
            quadSegs = 1;
        }
        this.filletAngleQuantum = 1.5707963267948966 / (double)quadSegs;
        if (bufParams.getQuadrantSegments() >= 8 && bufParams.getJoinStyle() == 1) {
            this.closingSegLengthFactor = 80;
        }
        this.init(distance);
    }

    public boolean hasNarrowConcaveAngle() {
        return this.hasNarrowConcaveAngle;
    }

    private void init(double distance) {
        this.distance = distance;
        this.maxCurveSegmentError = distance * (1.0 - Math.cos(this.filletAngleQuantum / 2.0));
        this.segList = new OffsetSegmentString();
        this.segList.setPrecisionModel(this.precisionModel);
        this.segList.setMinimumVertexDistance(distance * 1.0E-6);
    }

    public void initSideSegments(Coordinate s1, Coordinate s2, int side) {
        this.s1 = s1;
        this.s2 = s2;
        this.side = side;
        this.seg1.setCoordinates(s1, s2);
        OffsetSegmentGenerator.computeOffsetSegment(this.seg1, side, this.distance, this.offset1);
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] pts = this.segList.getCoordinates();
        return pts;
    }

    public void closeRing() {
        this.segList.closeRing();
    }

    public void addSegments(Coordinate[] pt, boolean isForward) {
        this.segList.addPts(pt, isForward);
    }

    public void addFirstSegment() {
        this.segList.addPt(this.offset1.p0);
    }

    public void addLastSegment() {
        this.segList.addPt(this.offset1.p1);
    }

    public void addNextSegment(Coordinate p2, boolean addStartPoint) {
        boolean outsideTurn;
        this.s0 = this.s1;
        this.s1 = this.s2;
        this.s2 = p2;
        this.seg0.setCoordinates(this.s0, this.s1);
        OffsetSegmentGenerator.computeOffsetSegment(this.seg0, this.side, this.distance, this.offset0);
        this.seg1.setCoordinates(this.s1, this.s2);
        OffsetSegmentGenerator.computeOffsetSegment(this.seg1, this.side, this.distance, this.offset1);
        if (this.s1.equals(this.s2)) {
            return;
        }
        int orientation = Orientation.index(this.s0, this.s1, this.s2);
        boolean bl = outsideTurn = orientation == -1 && this.side == 1 || orientation == 1 && this.side == 2;
        if (orientation == 0) {
            this.addCollinear(addStartPoint);
        } else if (outsideTurn) {
            this.addOutsideTurn(orientation, addStartPoint);
        } else {
            this.addInsideTurn(orientation, addStartPoint);
        }
    }

    private void addCollinear(boolean addStartPoint) {
        this.li.computeIntersection(this.s0, this.s1, this.s1, this.s2);
        int numInt = this.li.getIntersectionNum();
        if (numInt >= 2) {
            if (this.bufParams.getJoinStyle() == 3 || this.bufParams.getJoinStyle() == 2) {
                if (addStartPoint) {
                    this.segList.addPt(this.offset0.p1);
                }
                this.segList.addPt(this.offset1.p0);
            } else {
                this.addCornerFillet(this.s1, this.offset0.p1, this.offset1.p0, -1, this.distance);
            }
        }
    }

    private void addOutsideTurn(int orientation, boolean addStartPoint) {
        if (this.offset0.p1.distance(this.offset1.p0) < this.distance * 0.001) {
            this.segList.addPt(this.offset0.p1);
            return;
        }
        if (this.bufParams.getJoinStyle() == 2) {
            this.addMitreJoin(this.s1, this.offset0, this.offset1, this.distance);
        } else if (this.bufParams.getJoinStyle() == 3) {
            this.addBevelJoin(this.offset0, this.offset1);
        } else {
            if (addStartPoint) {
                this.segList.addPt(this.offset0.p1);
            }
            this.addCornerFillet(this.s1, this.offset0.p1, this.offset1.p0, orientation, this.distance);
            this.segList.addPt(this.offset1.p0);
        }
    }

    private void addInsideTurn(int orientation, boolean addStartPoint) {
        this.li.computeIntersection(this.offset0.p0, this.offset0.p1, this.offset1.p0, this.offset1.p1);
        if (this.li.hasIntersection()) {
            this.segList.addPt(this.li.getIntersection(0));
        } else {
            this.hasNarrowConcaveAngle = true;
            if (this.offset0.p1.distance(this.offset1.p0) < this.distance * 0.001) {
                this.segList.addPt(this.offset0.p1);
            } else {
                this.segList.addPt(this.offset0.p1);
                if (this.closingSegLengthFactor > 0) {
                    Coordinate mid0 = new Coordinate(((double)this.closingSegLengthFactor * this.offset0.p1.x + this.s1.x) / (double)(this.closingSegLengthFactor + 1), ((double)this.closingSegLengthFactor * this.offset0.p1.y + this.s1.y) / (double)(this.closingSegLengthFactor + 1));
                    this.segList.addPt(mid0);
                    Coordinate mid1 = new Coordinate(((double)this.closingSegLengthFactor * this.offset1.p0.x + this.s1.x) / (double)(this.closingSegLengthFactor + 1), ((double)this.closingSegLengthFactor * this.offset1.p0.y + this.s1.y) / (double)(this.closingSegLengthFactor + 1));
                    this.segList.addPt(mid1);
                } else {
                    this.segList.addPt(this.s1);
                }
                this.segList.addPt(this.offset1.p0);
            }
        }
    }

    static void computeOffsetSegment(LineSegment seg, int side, double distance, LineSegment offset) {
        int sideSign = side == 1 ? 1 : -1;
        double dx = seg.p1.x - seg.p0.x;
        double dy = seg.p1.y - seg.p0.y;
        double len = Math.sqrt(dx * dx + dy * dy);
        double ux = (double)sideSign * distance * dx / len;
        double uy = (double)sideSign * distance * dy / len;
        offset.p0.x = seg.p0.x - uy;
        offset.p0.y = seg.p0.y + ux;
        offset.p1.x = seg.p1.x - uy;
        offset.p1.y = seg.p1.y + ux;
    }

    public void addLineEndCap(Coordinate p0, Coordinate p1) {
        LineSegment seg = new LineSegment(p0, p1);
        LineSegment offsetL = new LineSegment();
        OffsetSegmentGenerator.computeOffsetSegment(seg, 1, this.distance, offsetL);
        LineSegment offsetR = new LineSegment();
        OffsetSegmentGenerator.computeOffsetSegment(seg, 2, this.distance, offsetR);
        double dx = p1.x - p0.x;
        double dy = p1.y - p0.y;
        double angle = Math.atan2(dy, dx);
        switch (this.bufParams.getEndCapStyle()) {
            case 1: {
                this.segList.addPt(offsetL.p1);
                this.addDirectedFillet(p1, angle + 1.5707963267948966, angle - 1.5707963267948966, -1, this.distance);
                this.segList.addPt(offsetR.p1);
                break;
            }
            case 2: {
                this.segList.addPt(offsetL.p1);
                this.segList.addPt(offsetR.p1);
                break;
            }
            case 3: {
                Coordinate squareCapSideOffset = new Coordinate();
                squareCapSideOffset.x = Math.abs(this.distance) * Math.cos(angle);
                squareCapSideOffset.y = Math.abs(this.distance) * Math.sin(angle);
                Coordinate squareCapLOffset = new Coordinate(offsetL.p1.x + squareCapSideOffset.x, offsetL.p1.y + squareCapSideOffset.y);
                Coordinate squareCapROffset = new Coordinate(offsetR.p1.x + squareCapSideOffset.x, offsetR.p1.y + squareCapSideOffset.y);
                this.segList.addPt(squareCapLOffset);
                this.segList.addPt(squareCapROffset);
            }
        }
    }

    private void addMitreJoin(Coordinate cornerPt, LineSegment offset0, LineSegment offset1, double distance) {
        double mitreLimitDistance = this.bufParams.getMitreLimit() * distance;
        Coordinate intPt = Intersection.intersection(offset0.p0, offset0.p1, offset1.p0, offset1.p1);
        if (intPt != null && intPt.distance(cornerPt) <= mitreLimitDistance) {
            this.segList.addPt(intPt);
            return;
        }
        double bevelDist = Distance.pointToSegment(cornerPt, offset0.p1, offset1.p0);
        if (bevelDist >= mitreLimitDistance) {
            this.addBevelJoin(offset0, offset1);
            return;
        }
        this.addLimitedMitreJoin(offset0, offset1, distance, mitreLimitDistance);
    }

    private void addLimitedMitreJoin(LineSegment offset0, LineSegment offset1, double distance, double mitreLimitDistance) {
        Coordinate cornerPt = this.seg0.p1;
        double angInterior = Angle.angleBetweenOriented(this.seg0.p0, cornerPt, this.seg1.p1);
        double angInterior2 = angInterior / 2.0;
        double dir0 = Angle.angle(cornerPt, this.seg0.p0);
        double dirBisector = Angle.normalize(dir0 + angInterior2);
        Coordinate bevelMidPt = OffsetSegmentGenerator.project(cornerPt, -mitreLimitDistance, dirBisector);
        double dirBevel = Angle.normalize(dirBisector + 1.5707963267948966);
        Coordinate bevel0 = OffsetSegmentGenerator.project(bevelMidPt, distance, dirBevel);
        Coordinate bevel1 = OffsetSegmentGenerator.project(bevelMidPt, distance, dirBevel + Math.PI);
        Coordinate bevelInt0 = Intersection.lineSegment(offset0.p0, offset0.p1, bevel0, bevel1);
        Coordinate bevelInt1 = Intersection.lineSegment(offset1.p0, offset1.p1, bevel0, bevel1);
        if (bevelInt0 != null && bevelInt1 != null) {
            this.segList.addPt(bevelInt0);
            this.segList.addPt(bevelInt1);
            return;
        }
        this.addBevelJoin(offset0, offset1);
    }

    private static Coordinate project(Coordinate pt, double d, double dir) {
        double x = pt.x + d * Math.cos(dir);
        double y = pt.y + d * Math.sin(dir);
        return new Coordinate(x, y);
    }

    private void addBevelJoin(LineSegment offset0, LineSegment offset1) {
        this.segList.addPt(offset0.p1);
        this.segList.addPt(offset1.p0);
    }

    private void addCornerFillet(Coordinate p2, Coordinate p0, Coordinate p1, int direction, double radius) {
        double dx0 = p0.x - p2.x;
        double dy0 = p0.y - p2.y;
        double startAngle = Math.atan2(dy0, dx0);
        double dx1 = p1.x - p2.x;
        double dy1 = p1.y - p2.y;
        double endAngle = Math.atan2(dy1, dx1);
        if (direction == -1) {
            if (startAngle <= endAngle) {
                startAngle += Math.PI * 2;
            }
        } else if (startAngle >= endAngle) {
            startAngle -= Math.PI * 2;
        }
        this.segList.addPt(p0);
        this.addDirectedFillet(p2, startAngle, endAngle, direction, radius);
        this.segList.addPt(p1);
    }

    private void addDirectedFillet(Coordinate p2, double startAngle, double endAngle, int direction, double radius) {
        int directionFactor = direction == -1 ? -1 : 1;
        double totalAngle = Math.abs(startAngle - endAngle);
        int nSegs = (int)(totalAngle / this.filletAngleQuantum + 0.5);
        if (nSegs < 1) {
            return;
        }
        double angleInc = totalAngle / (double)nSegs;
        Coordinate pt = new Coordinate();
        for (int i2 = 0; i2 < nSegs; ++i2) {
            double angle = startAngle + (double)(directionFactor * i2) * angleInc;
            pt.x = p2.x + radius * Math.cos(angle);
            pt.y = p2.y + radius * Math.sin(angle);
            this.segList.addPt(pt);
        }
    }

    public void createCircle(Coordinate p2) {
        Coordinate pt = new Coordinate(p2.x + this.distance, p2.y);
        this.segList.addPt(pt);
        this.addDirectedFillet(p2, 0.0, Math.PI * 2, -1, this.distance);
        this.segList.closeRing();
    }

    public void createSquare(Coordinate p2) {
        this.segList.addPt(new Coordinate(p2.x + this.distance, p2.y + this.distance));
        this.segList.addPt(new Coordinate(p2.x + this.distance, p2.y - this.distance));
        this.segList.addPt(new Coordinate(p2.x - this.distance, p2.y - this.distance));
        this.segList.addPt(new Coordinate(p2.x - this.distance, p2.y + this.distance));
        this.segList.closeRing();
    }
}

