/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j;

import java.io.Serializable;
import java.text.DecimalFormat;

public class ProjCoordinate
implements Serializable {
    public static String DECIMAL_FORMAT_PATTERN = "0.0###############";
    public static DecimalFormat DECIMAL_FORMAT = new DecimalFormat(DECIMAL_FORMAT_PATTERN);
    public double x;
    public double y;
    public double z;

    public ProjCoordinate() {
        this(0.0, 0.0);
    }

    public ProjCoordinate(double argX, double argY, double argZ) {
        this.x = argX;
        this.y = argY;
        this.z = argZ;
    }

    public ProjCoordinate(double argX, double argY) {
        this.x = argX;
        this.y = argY;
        this.z = Double.NaN;
    }

    public ProjCoordinate(String argToParse) {
        int length;
        int positionOfCharBeforeLast;
        boolean startsWith = argToParse.startsWith("ProjCoordinate: ");
        if (!startsWith) {
            IllegalArgumentException toThrow = new IllegalArgumentException("The input string was not in the proper format.");
            throw toThrow;
        }
        String chomped = argToParse.substring(16);
        String withoutFrontBracket = chomped.substring(1);
        String withoutBackBracket = withoutFrontBracket.substring(0, positionOfCharBeforeLast = (length = withoutFrontBracket.length()) - 2);
        String[] parts = withoutBackBracket.split(" ");
        if (parts.length != 2 && parts.length != 3) {
            IllegalArgumentException toThrow = new IllegalArgumentException("The input string was not in the proper format.");
            throw toThrow;
        }
        this.x = Double.parseDouble(parts[0]);
        this.y = Double.parseDouble(parts[0]);
        if (parts.length == 3) {
            this.z = Double.parseDouble(parts[0]);
        }
    }

    public void setValue(ProjCoordinate p2) {
        this.x = p2.x;
        this.y = p2.y;
        this.z = p2.z;
    }

    public void setValue(double x, double y) {
        this.x = x;
        this.y = y;
        this.z = Double.NaN;
    }

    public void setValue(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void clearZ() {
        this.z = Double.NaN;
    }

    public boolean areXOrdinatesEqual(ProjCoordinate argToCompare, double argTolerance) {
        double difference = argToCompare.x - this.x;
        return !(difference > argTolerance);
    }

    public boolean areYOrdinatesEqual(ProjCoordinate argToCompare, double argTolerance) {
        double difference = argToCompare.y - this.y;
        return !(difference > argTolerance);
    }

    public boolean areZOrdinatesEqual(ProjCoordinate argToCompare, double argTolerance) {
        if (Double.isNaN(this.z)) {
            return Double.isNaN(argToCompare.z);
        }
        if (Double.isNaN(argToCompare.z)) {
            return false;
        }
        double difference = argToCompare.z - this.z;
        return !(difference > argTolerance);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ProjCoordinate)) {
            return false;
        }
        ProjCoordinate p2 = (ProjCoordinate)other;
        if (this.x != p2.x) {
            return false;
        }
        return this.y == p2.y;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + ProjCoordinate.hashCode(this.x);
        result2 = 37 * result2 + ProjCoordinate.hashCode(this.y);
        return result2;
    }

    private static int hashCode(double x) {
        long f = Double.doubleToLongBits(x);
        return (int)(f ^ f >>> 32);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProjCoordinate[");
        builder.append(this.x);
        builder.append(" ");
        builder.append(this.y);
        builder.append(" ");
        builder.append(this.z);
        builder.append("]");
        return builder.toString();
    }

    public String toShortString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(DECIMAL_FORMAT.format(this.x).replace(",", "."));
        builder.append(", ");
        builder.append(DECIMAL_FORMAT.format(this.y).replace(",", "."));
        if (!Double.isNaN(this.z)) {
            builder.append(", ");
            builder.append(this.z);
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean hasValidZOrdinate() {
        return !Double.isNaN(this.z);
    }

    public boolean hasValidXandYOrdinates() {
        if (Double.isNaN(this.x)) {
            return false;
        }
        if (Double.isInfinite(this.x)) {
            return false;
        }
        if (Double.isNaN(this.y)) {
            return false;
        }
        return !Double.isInfinite(this.y);
    }
}

