/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.refactoring;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.python.django.extension.PyDjangoUrlViewMagicLiteralExtensionPoint;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.util.ProcessingContext;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.StringLiteralExpression;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class DjangoUrlRenameInputValidator
implements RenameInputValidator {
    private static final ObjectPattern.Capture<PyStringLiteralExpression> PATTERN = (ObjectPattern.Capture)StandardPatterns.instanceOf(PyStringLiteralExpression.class).with((PatternCondition)new DjangoUrlRenameCondition());
    private static final Pattern REGEXP = Pattern.compile("^[a-zA-Z0-9+=, -]+$");

    @NotNull
    public ElementPattern<? extends PsiElement> getPattern() {
        ObjectPattern.Capture<PyStringLiteralExpression> capture = PATTERN;
        if (capture == null) {
            DjangoUrlRenameInputValidator.$$$reportNull$$$0(0);
        }
        return capture;
    }

    public boolean isInputValid(@NotNull String newName, @NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (newName == null) {
            DjangoUrlRenameInputValidator.$$$reportNull$$$0(1);
        }
        if (element == null) {
            DjangoUrlRenameInputValidator.$$$reportNull$$$0(2);
        }
        if (context == null) {
            DjangoUrlRenameInputValidator.$$$reportNull$$$0(3);
        }
        return REGEXP.matcher(newName).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/refactoring/DjangoUrlRenameInputValidator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/refactoring/DjangoUrlRenameInputValidator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInputValid";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static final class DjangoUrlRenameCondition
    extends PatternCondition<PyStringLiteralExpression> {
        private DjangoUrlRenameCondition() {
            super("DjangoUrlRenameCondition");
        }

        public boolean accepts(@NotNull PyStringLiteralExpression expression, ProcessingContext context) {
            if (expression == null) {
                DjangoUrlRenameCondition.$$$reportNull$$$0(0);
            }
            if (DjangoModelApi.create((PyElement)expression).getSuccessOrNull() == null) {
                return false;
            }
            return PyDjangoUrlViewMagicLiteralExtensionPoint.isUrlNameArgument((StringLiteralExpression)expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/python/django/refactoring/DjangoUrlRenameInputValidator$DjangoUrlRenameCondition", "accepts"));
        }
    }
}

