/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.run;

import com.intellij.DynamicBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BrowserUrlPanel
extends JPanel
implements PanelWithAnchor {
    private static final String DEFAULT_HOST = "127.0.0.1";
    private JTextField myBrowserUrlField;
    private JPanel myMainPanel;
    private JBCheckBox myRunBrowserCheckBox;
    private JCheckBox myStartJavaScriptDebugger;

    public BrowserUrlPanel() {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.add((Component)this.myMainPanel, "Center");
        this.myRunBrowserCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = BrowserUrlPanel.this.myRunBrowserCheckBox.isSelected();
                BrowserUrlPanel.this.myBrowserUrlField.setEnabled(isSelected);
                BrowserUrlPanel.this.myStartJavaScriptDebugger.setEnabled(isSelected);
            }
        });
    }

    protected String getHost() {
        return DEFAULT_HOST;
    }

    protected abstract String getPort();

    protected String getDefaultBrowserUrl() {
        String host = this.getHost();
        if (StringUtil.isEmptyOrSpaces((String)host)) {
            host = DEFAULT_HOST;
        }
        StringBuilder builder = new StringBuilder("http://").append(host);
        String port = this.getPort();
        if (!StringUtil.isEmpty((String)port)) {
            builder.append(":").append(port);
        }
        builder.append("/");
        return builder.toString();
    }

    public void watch(JTextField ... fields) {
        DocumentAdapter listener = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!BrowserUrlPanel.this.myRunBrowserCheckBox.isSelected()) {
                    BrowserUrlPanel.this.myBrowserUrlField.setText(BrowserUrlPanel.this.getDefaultBrowserUrl());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/python/django/run/BrowserUrlPanel$2", "textChanged"));
            }
        };
        for (JTextField field : fields) {
            field.getDocument().addDocumentListener((DocumentListener)listener);
        }
    }

    public void setBrowserUrl(String url) {
        if (StringUtil.isEmpty((String)url)) {
            this.myRunBrowserCheckBox.setSelected(false);
            this.myBrowserUrlField.setEnabled(false);
            this.myStartJavaScriptDebugger.setEnabled(false);
            this.myBrowserUrlField.setText(this.getDefaultBrowserUrl());
        } else {
            this.myRunBrowserCheckBox.setSelected(true);
            this.myBrowserUrlField.setEnabled(true);
            this.myBrowserUrlField.setText(url);
        }
    }

    @Nullable
    public String getBrowserUrl() {
        return this.myRunBrowserCheckBox.isSelected() ? this.myBrowserUrlField.getText() : null;
    }

    public JComponent getAnchor() {
        return this.myRunBrowserCheckBox.getAnchor();
    }

    public void setAnchor(JComponent anchor) {
        this.myRunBrowserCheckBox.setAnchor(anchor);
    }

    public boolean isLaunchJavascriptDebugger() {
        return this.myStartJavaScriptDebugger.isEnabled() && this.myStartJavaScriptDebugger.isSelected();
    }

    public void setLaunchJavascriptDebugger(boolean launch) {
        this.myStartJavaScriptDebugger.setSelected(launch);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myRunBrowserCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DjangoBundle", BrowserUrlPanel.class).getString("django.run.browser.setting"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myBrowserUrlField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myStartJavaScriptDebugger = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(0, 0, 0, 1));
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/DjangoBundle", BrowserUrlPanel.class).getString("django.start.js.debugger.automatically"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

