/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.formatter;

import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PuppetWrappingProcessor {
    private static final Wrap NORMAL_WRAP = Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)false);
    private static final Wrap NONE_WRAP = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
    @NotNull
    private final PsiFile myFile;
    private final NotNullLazyValue<List<TextRange>> myHeredocsRangesList;

    PuppetWrappingProcessor(@NotNull PsiFile file) {
        if (file == null) {
            PuppetWrappingProcessor.$$$reportNull$$$0(0);
        }
        this.myFile = file;
        this.myHeredocsRangesList = NotNullLazyValue.atomicLazy(() -> {
            final Document document = this.myFile.getViewProvider().getDocument();
            if (document == null) {
                return Collections.emptyList();
            }
            final ArrayList result = new ArrayList();
            this.myFile.accept(new PsiElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitElement(element);
                    if (PsiUtilCore.getElementType((PsiElement)element) == PuppetTokenTypes.HEREDOC_EXPRESSION) {
                        int startOffset = element.getNode().getStartOffset();
                        result.add(TextRange.create((int)(startOffset + 1), (int)document.getLineEndOffset(document.getLineNumber(startOffset))));
                    } else {
                        element.acceptChildren((PsiElementVisitor)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/puppet/formatter/PuppetWrappingProcessor$1", "visitElement"));
                }
            });
            return result;
        });
    }

    public boolean isHereDocOnLineBefore(@NotNull ASTNode node) {
        if (node == null) {
            PuppetWrappingProcessor.$$$reportNull$$$0(1);
        }
        int startOffset = node.getStartOffset();
        for (TextRange range : (List)this.myHeredocsRangesList.getValue()) {
            if (!range.contains(startOffset)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Wrap getNodeWrap(@NotNull ASTNode node) {
        PsiElement psiElement;
        if (node == null) {
            PuppetWrappingProcessor.$$$reportNull$$$0(2);
        }
        if ((psiElement = node.getPsi()) instanceof PsiFile) {
            return null;
        }
        return this.isHereDocOnLineBefore(node) ? NONE_WRAP : NORMAL_WRAP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/puppet/formatter/PuppetWrappingProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isHereDocOnLineBefore";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getNodeWrap";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

