/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi;

import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.lexer.PuppetLexerBase;
import com.intellij.lang.puppet.lexer.PuppetTokenTypeSets;
import com.intellij.lang.puppet.psi.PuppetPolyNamedElement;
import com.intellij.lang.puppet.util.PuppetElementFactory;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PuppetPsiUtil {
    @Nullable
    public static PsiElement getPrevNonSpaceSibling(@NotNull PsiElement element) {
        if (element == null) {
            PuppetPsiUtil.$$$reportNull$$$0(0);
        }
        while ((element = element.getPrevSibling()) != null) {
            if (PuppetTokenTypeSets.WHITESPACE_OR_COMMENTS.contains(PsiUtilCore.getElementType((PsiElement)element))) continue;
            return element;
        }
        return null;
    }

    public static PsiElement setName(@NotNull PsiNameIdentifierOwner element, @NotNull String name) {
        ElementManipulator manipulator;
        PsiElement identifier;
        if (element == null) {
            PuppetPsiUtil.$$$reportNull$$$0(1);
        }
        if (name == null) {
            PuppetPsiUtil.$$$reportNull$$$0(2);
        }
        if ((identifier = element.getNameIdentifier()) == null) {
            return element;
        }
        if (identifier instanceof LeafPsiElement) {
            ((LeafPsiElement)identifier).replaceWithText(name);
        }
        if ((manipulator = ElementManipulators.getManipulator((PsiElement)identifier)) != null) {
            manipulator.handleContentChange(identifier, name);
        }
        return element;
    }

    public static boolean processPsiElementsRecursively(@Nullable PsiElement currentElement, @NotNull Processor<? super PsiElement> processor, @NotNull TokenSet elementsToProcess, @NotNull TokenSet elementsToEnter) {
        if (processor == null) {
            PuppetPsiUtil.$$$reportNull$$$0(3);
        }
        if (elementsToProcess == null) {
            PuppetPsiUtil.$$$reportNull$$$0(4);
        }
        if (elementsToEnter == null) {
            PuppetPsiUtil.$$$reportNull$$$0(5);
        }
        while (currentElement != null) {
            IElementType currentElementType = PsiUtilCore.getElementType((PsiElement)currentElement);
            if (elementsToProcess.contains(currentElementType) ? !processor.process((Object)currentElement) : elementsToEnter.contains(currentElementType) && !PuppetPsiUtil.processPsiElementsRecursively(currentElement.getFirstChild(), processor, elementsToProcess, elementsToEnter)) {
                return false;
            }
            currentElement = currentElement.getNextSibling();
        }
        return true;
    }

    @NotNull
    public static List<String> computeResourceLikeNamesList(PuppetPolyNamedElement polyNamedElement) {
        List<PsiElement> identifiersList = polyNamedElement.getNameIdentifiersList();
        if (identifiersList.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PuppetPsiUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (PsiElement identifier : identifiersList) {
            String name = polyNamedElement.getNameFromIdentifier(identifier);
            if (name == null) continue;
            result.add(name);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            PuppetPsiUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public static String getResourceLikeNameFromIdentifier(PsiElement nameIdentifier) {
        IElementType type = PsiUtilCore.getElementType((PsiElement)nameIdentifier);
        if (type == PuppetTokenTypes.QUOTED_TEXT || type == PuppetTokenTypes.REGULAR_NAME_WRAPPER) {
            return ElementManipulators.getValueText((PsiElement)nameIdentifier);
        }
        if (type == PuppetTokenTypes.DEFAULT_WRAPPER) {
            return "default - the real one";
        }
        return "resource with heavy name";
    }

    public static List<PsiElement> getResourceLikeIdentifiersList(PsiElement firstChild) {
        if (PuppetTokenTypeSets.RESOURCE_NAME_HOLDERS.contains(PsiUtilCore.getElementType((PsiElement)firstChild))) {
            return Collections.singletonList(firstChild);
        }
        return PuppetPsiUtil.collectPsiElementsRecursively(firstChild.getFirstChild(), PuppetTokenTypeSets.RESOURCE_NAME_HOLDERS, PuppetTokenTypeSets.RESOURCE_NAME_CONTAINERS);
    }

    public static List<PsiElement> collectPsiElementsRecursively(@Nullable PsiElement currentElement, @NotNull TokenSet elementsToCollect, @NotNull TokenSet elementsToEnter) {
        if (elementsToCollect == null) {
            PuppetPsiUtil.$$$reportNull$$$0(8);
        }
        if (elementsToEnter == null) {
            PuppetPsiUtil.$$$reportNull$$$0(9);
        }
        if (currentElement == null) {
            return Collections.emptyList();
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(new ArrayList());
        PuppetPsiUtil.processPsiElementsRecursively(currentElement, (Processor<? super PsiElement>)processor, elementsToCollect, elementsToEnter);
        return (List)processor.getResults();
    }

    @Nullable
    public static PsiElement renameResourceInstanceIdentifier(@Nullable PsiElement nameIdentifier, @NotNull String newName) {
        if (newName == null) {
            PuppetPsiUtil.$$$reportNull$$$0(10);
        }
        if (nameIdentifier == null) {
            return null;
        }
        if (PsiUtilCore.getElementType((PsiElement)nameIdentifier) == PuppetTokenTypes.REGULAR_NAME_WRAPPER && !PuppetLexerBase.IDENTIFIER_PATTERN.matcher(newName).matches()) {
            return nameIdentifier.replace((PsiElement)PuppetElementFactory.createQuotedStringElementWithContent(nameIdentifier.getProject(), newName));
        }
        return ElementManipulators.handleContentChange((PsiElement)nameIdentifier, (String)newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToProcess";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToEnter";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/psi/PuppetPsiUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToCollect";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/psi/PuppetPsiUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeResourceLikeNamesList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPrevNonSpaceSibling";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processPsiElementsRecursively";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectPsiElementsRecursively";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "renameResourceInstanceIdentifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

