/**
 * workaround for https://github.com/vitest-dev/vitest/issues/2176
 */
function fixRequirePath(relativePath) {
  const fileName = process.env['_JETBRAINS_VITEST_REPORTER_ABSOLUTE_PATH'];
  if (fileName == null) {
    return relativePath; // if --reporter is passed as a relative path, no need to workaround
  }
  const path = require('path');
  return path.join(path.dirname(fileName), relativePath);
}

try {
  module.exports = require(fixRequirePath('../vitest-intellij-reporter'));
}
catch (e) {
  process.stderr.write(e.message + '\n' + e.stack);
}
