from collections.abc import Iterator, Sequence
from typing import Any, Generic, TypeVar

from django.utils.functional import cached_property

_T = TypeVar("_T")

class ConnectionProxy(Generic[_T]):
    def __init__(self, connections: BaseConnectionHandler[_T], alias: str) -> None: ...
    def __getattr__(self, item: str) -> _T: ...
    def __setattr__(self, name: str, value: _T) -> None: ...
    def __delattr__(self, name: str) -> None: ...
    def __contains__(self, key: str) -> bool: ...
    def __eq__(self, other: object) -> bool: ...

class ConnectionDoesNotExist(Exception): ...

class BaseConnectionHandler(Generic[_T]):
    settings_name: str | None
    exception_class: type[Exception]
    thread_critical: bool
    @cached_property
    def settings(self) -> dict[str, Any]: ...
    def __init__(self, settings: Any | None = ...) -> None: ...
    def configure_settings(self, settings: dict[str, Any] | None) -> dict[str, Any]: ...
    def create_connection(self, alias: str) -> _T: ...
    def __getitem__(self, alias: str) -> _T: ...
    def __setitem__(self, key: str, value: _T) -> None: ...
    def __delitem__(self, key: str) -> None: ...
    def __iter__(self) -> Iterator[str]: ...
    def all(self, initialized_only: bool = ...) -> Sequence[_T]: ...
    def close_all(self) -> None: ...
