/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.dependency.DownloadableArtifact;
import org.jfrog.build.api.dependency.PatternResultFileSet;
import org.jfrog.build.api.dependency.PropertySearchResult;
import org.jfrog.build.api.dependency.pattern.BuildDependencyPattern;
import org.jfrog.build.api.dependency.pattern.DependencyPattern;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloader;
import org.jfrog.build.extractor.clientConfiguration.util.PatternFactory;
import org.jfrog.build.extractor.clientConfiguration.util.PublishedItemsHelper;

public class AntPatternsDependenciesHelper {
    private DependenciesDownloader downloader;
    private Log log;

    public AntPatternsDependenciesHelper(DependenciesDownloader downloader, Log log) {
        this.downloader = downloader;
        this.log = log;
    }

    public List<Dependency> retrievePublishedDependencies(String resolvePattern) throws IOException, InterruptedException {
        if (StringUtils.isBlank(resolvePattern)) {
            return Collections.emptyList();
        }
        List<String> patternLines = PublishedItemsHelper.parsePatternsFromProperty(resolvePattern);
        List<Dependency> dependencies = Collections.emptyList();
        if (patternLines.isEmpty()) {
            return dependencies;
        }
        this.log.info("Beginning to resolve Build Info dependencies.");
        dependencies = this.downloader.download(this.collectArtifactsToDownload(patternLines));
        this.log.info("Finished resolving Build Info dependencies.");
        return dependencies;
    }

    private Set<DownloadableArtifact> collectArtifactsToDownload(List<String> patternLines) throws IOException, InterruptedException {
        HashSet<DownloadableArtifact> downloadableArtifacts = new HashSet<DownloadableArtifact>();
        for (String patternLine : patternLines) {
            DependencyPattern dependencyPattern = PatternFactory.create(patternLine);
            if (dependencyPattern instanceof BuildDependencyPattern) continue;
            downloadableArtifacts.addAll(this.handleDependencyPattern(dependencyPattern));
        }
        return downloadableArtifacts;
    }

    private Set<DownloadableArtifact> handleDependencyPattern(DependencyPattern dependencyPattern) throws IOException {
        String pattern = dependencyPattern.getPattern();
        this.log.info("Resolving published dependencies with pattern " + pattern);
        if (StringUtils.contains(pattern, "**")) {
            if (StringUtils.isNotBlank(dependencyPattern.getMatrixParams())) {
                return this.performPropertySearch(dependencyPattern);
            }
            throw new IllegalArgumentException("Wildcard '**' is not allowed without matrix params for pattern '" + pattern + "'");
        }
        return this.performPatternSearch(dependencyPattern);
    }

    private Set<DownloadableArtifact> performPropertySearch(DependencyPattern dependencyPattern) throws IOException {
        HashSet<DownloadableArtifact> downloadableArtifacts = new HashSet<DownloadableArtifact>();
        String pattern = dependencyPattern.getPattern();
        String matrixParams = dependencyPattern.getMatrixParams();
        PropertySearchResult propertySearchResult = this.downloader.getClient().searchArtifactsByProperties(matrixParams);
        List<PropertySearchResult.SearchEntry> filteredEntries = this.filterResultEntries(propertySearchResult.getResults(), pattern);
        this.log.info("Found " + filteredEntries.size() + " dependencies by doing a property search.");
        for (PropertySearchResult.SearchEntry searchEntry : filteredEntries) {
            downloadableArtifacts.add(new DownloadableArtifact(searchEntry.getRepoUri(), dependencyPattern.getTargetDirectory(), searchEntry.getFilePath(), matrixParams, pattern, dependencyPattern.getPatternType()));
        }
        return downloadableArtifacts;
    }

    private List<PropertySearchResult.SearchEntry> filterResultEntries(List<PropertySearchResult.SearchEntry> results, String pattern) {
        String patternStr = pattern.replaceFirst(":", "/");
        return new ArrayList<PropertySearchResult.SearchEntry>(CommonUtils.filterCollection(results, result -> PatternMatcher.match(patternStr, result.getRepoPath(), false)));
    }

    private Set<DownloadableArtifact> performPatternSearch(DependencyPattern dependencyPattern) throws IOException {
        HashSet<DownloadableArtifact> downloadableArtifacts = new HashSet<DownloadableArtifact>();
        String pattern = dependencyPattern.getPattern();
        PatternResultFileSet fileSet = this.downloader.getClient().searchArtifactsByPattern(pattern);
        Set<String> filesToDownload = fileSet.getFiles();
        this.log.info("Found " + filesToDownload.size() + " dependencies by doing a pattern search.");
        for (String fileToDownload : filesToDownload) {
            downloadableArtifacts.add(new DownloadableArtifact(fileSet.getRepoUri(), dependencyPattern.getTargetDirectory(), fileToDownload, dependencyPattern.getMatrixParams(), pattern, dependencyPattern.getPatternType()));
        }
        return downloadableArtifacts;
    }
}

