#include "webmon.h"
#include "w.xpm"

#define CONFIG_NAME	"GKWebMon"
#define STYLE_NAME	"gkwebmon"
#define CONFIG_KEYWORD  "gkwebmon"
#define PLACEMENT	(MON_MAIL | MON_INSERT_AFTER)


static GkrellmPanel *panel;
static GkrellmMonitor *web_monitor;
static GkrellmDecal *www_decal, *text_decal;
static GkrellmPiximage *www_image;

static gint style_id;

static GtkTooltips *tooltip;
static gchar *tooltip_text;

static gchar *httpstr;
static GtkWidget *url_entry[20];

static GtkWidget *update_spin;

static GkrellmTicks *ticks;
static gint hours_since_update;
static gint checkmins;

static gint number_of_changed;

/* function declares */

static void callback_button(GkrellmDecalbutton * button, gpointer data);
static gint panel_expose_event(GtkWidget * widget, GdkEventExpose * ev);
static gint button_press_event(GtkWidget * widget, GdkEventButton * ev);
static void update_plugin(void);
static void apply_plugin_config(void);
static void create_plugin(GtkWidget * vbox, gint first_create);
static void print_on_textdecal(gint number);
static void create_plugin_tab(GtkWidget * tab_vbox);
static void load_config(gchar * str);
static void save_config(FILE * fp);
GkrellmMonitor *gkrellm_init_plugin(void);
static void get_pages_for_check(void);
static void change_tooltip(int i);
static void default_tooltip(void);
static void compare_md5(int i);
static void do_alarm(int i);

static GkrellmMonitor webmon = {
  CONFIG_NAME,
  0,
  create_plugin,
  update_plugin,
  create_plugin_tab,
  apply_plugin_config,

  save_config,
  load_config,
  CONFIG_KEYWORD,

  NULL,
  NULL,
  NULL,

  PLACEMENT,

  NULL,
  NULL
};

/* functions */

#ifdef DEBUG
static void printElem(int i)
{
  if (wi[i].use == 1) {
    fprintf(stderr, "wi[%d].server:   %s\n", i, wi[i].server);
    fprintf(stderr, "wi[%d].port:     %d\n", i, wi[i].port);
    fprintf(stderr, "wi[%d].user:     %s\n", i, wi[i].user);
    fprintf(stderr, "wi[%d].password: %s\n", i, wi[i].password);
    fprintf(stderr, "wi[%d].path:     %s\n", i, wi[i].page);
    fprintf(stderr, "wi[%d].updated : %d\n", i, wi[i].updated);
    fprintf(stderr, "wi[%d].flagged : %d\n", i, wi[i].flagged);
    fprintf(stderr, "wi[%d].init:     %s\n", i, wi[i].init_md5);
    fprintf(stderr, "wi[%d].new :     %s\n", i, wi[i].new_md5);
  } else {
    fprintf(stderr, "wi[%d] is free\n", i);
  }
}
#endif

static void callback_button(GkrellmDecalbutton * button, gpointer data)
{

  int i;

  if (GPOINTER_TO_INT(data) == 1) {
#ifdef DEBUG     
    for (i=0; i<20; i++) {
      printElem(i);
    }
#endif
    if (number_of_changed > 0) {
      /* we are in an alarm state... */
      number_of_changed = 0;
      /* mark all url's as not-flagged */
      for (i=0; i<20; i++) {
	wi[i].flagged = 0;
      }
      print_on_textdecal(0);
      gkrellm_draw_decal_pixmap(panel, www_decal, 0);
      /* we also need to set the tooltip_text */
      default_tooltip();
      /* ...back to normal state */
    } else {
      /* forced check */
      get_pages_for_check();
    }
  }
}

static gint panel_expose_event(GtkWidget * widget, GdkEventExpose * ev)
{

  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
		  panel->pixmap, ev->area.x, ev->area.y, ev->area.x,
		  ev->area.y, ev->area.width, ev->area.height);
  return FALSE;
}
static gint button_press_event(GtkWidget * widget, GdkEventButton * ev)
{

  if (ev->button == 3) {
    gkrellm_open_config_window(web_monitor);
  }
  return TRUE;
}

static void update_plugin(void)
{
  int i;
  if (ticks->hour_tick == 1) {
    hours_since_update++;
    if (hours_since_update >= updatetime) {
      /* get the webpages */
      get_pages_for_check();
      hours_since_update = 0;
    }
  }
  if (ticks->minute_tick == 1) {
    /* look to see if any MD5 checksums updated */
#ifdef DEBUG
    fprintf(stderr, "checkingfor updates\n");
#endif
    for (i = 0; i < 20; i++) {
      if (wi[i].updated) {
#ifdef DEBUG
    fprintf(stderr, "%d was updated\n", i);
#endif
	wi[i].updated = 0;
	compare_md5(i);
      }
    }
  }
  gkrellm_draw_panel_layers(panel);
}

static void apply_plugin_config(void)
{
  int i;
  gchar *oldurl;

#ifdef DEBUG
  fprintf(stderr, "pluginConfig\n");
#endif

  /* copy data to webinfo struct */
  for (i = 0; i < 20; i++) {
    if (wi[i].use == 1) {
      /* now we need to see if an existing URL was changed */
      if (wi[i].port == 80) {
	oldurl = g_strdup_printf("http://%s%s", wi[i].server, wi[i].page);
      } else {
	oldurl = g_strdup_printf("http://%s:%d%s", wi[i].server,
				 wi[i].port, wi[i].page);
      }
      if ((strcmp(oldurl, gtk_entry_get_text(GTK_ENTRY(url_entry[i]))) != 0)) {
	/* the URL has changed, we need to get new init_md5 */
	/* first of all we need to copy the URL to the struct */
	/* the copy will be done 2 times for those changed */
	/* but that probably won't happen that often.. */
#ifdef DEBUG
	fprintf(stderr, "plugin_config: URL for %d changed\n", i);
#endif
	httpstr = (gchar *) gtk_entry_get_text(GTK_ENTRY(url_entry[i]));
	parse_url_to_config_struct(i, httpstr);
      }
    } else {
      httpstr = (gchar *) gtk_entry_get_text(GTK_ENTRY(url_entry[i]));
      if (*httpstr) {
	parse_url_to_config_struct(i, httpstr);
      }
    }
  }
  updatetime = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(update_spin));

  /* now we need to check if we have an MD5 for each the page */
  for (i = 0; i < 20; i++) {
    if (wi[i].use == 1) {
      if (!(wi[i].init_md5[0])) {
	/* no MD5 for this page, lets get it */
#ifdef DEBUG
	printf("plugin_config: getting MD5 for %d\n", i);
#endif
	start_thread((void *) i);
      }
    }
  }
}

static void create_plugin(GtkWidget * vbox, gint first_create)
{
  GkrellmStyle *style;
  GkrellmTextstyle *ts, *ts_alt;

  static GdkPixmap *www_pixmap = NULL;
  static GdkBitmap *www_mask = NULL;
  
  gint w, x;

  if (first_create) {
    panel = gkrellm_panel_new0();
  }

  style = gkrellm_panel_style(style_id);
  ts = gkrellm_meter_textstyle(style_id);
  ts_alt = gkrellm_meter_alt_textstyle(style_id);

  /* pixmap decal */
  gkrellm_load_piximage("w", w_xpm, &www_image, STYLE_NAME);

  gkrellm_scale_piximage_to_pixmap(www_image, &www_pixmap, &www_mask, 0,
				     0);
  www_decal = gkrellm_create_decal_pixmap(panel, www_pixmap, www_mask, 2, NULL,
				    5, 0);
  gkrellm_draw_decal_pixmap(panel, www_decal, 0);

  /* text decal */
  w = gkrellm_chart_width() - www_decal->w - 2;
  x = www_decal->w + 8;

  text_decal = gkrellm_create_decal_text(panel, "0", ts_alt, style, x, 1, w);
  text_decal->y += 3;
  gkrellm_put_decal_in_meter_button(panel, text_decal, callback_button,
				    GINT_TO_POINTER(1), NULL);
  print_on_textdecal(number_of_changed);

  /* create panel */
  gkrellm_panel_configure(panel, NULL, style);
  gkrellm_panel_create(vbox, web_monitor, panel);

  /* tooltips */
  tooltip = gtk_tooltips_new();
  gtk_tooltips_set_delay(tooltip, 1000);
  default_tooltip();

  if (first_create) {
    g_signal_connect(G_OBJECT(panel->drawing_area), "expose_event",
		     G_CALLBACK(panel_expose_event), NULL);
    g_signal_connect(G_OBJECT(panel->drawing_area),
		     "button_press_event",
		     G_CALLBACK(button_press_event), NULL);
  }

}

static void print_on_textdecal(gint number)
{
  GkrellmStyle *style;
  gchar output[3];

  style = gkrellm_meter_style(style_id);

  text_decal->x = text_decal->w;

  sprintf(output, "%d", number);
  gkrellm_draw_decal_text(panel, text_decal, output, number);

}

static void create_plugin_tab(GtkWidget * tab_vbox)
{
  GtkWidget *tabs, *text, *vbox_options, *vbox_url1, *vbox_url2,
    *vbox_help, *vbox_about;
  gchar *update_label;
  gchar *about_text;
  gchar *url;
  int i;


  gchar *help_text[] = {
    "<b>GKrellM Web Monitor Plugin\n",
    "This plugin will monitor web pages for changes.\n",
    "\n",
    "<b>How it works\n",
    "The plugin will fetch the web pages you tell it to and calculate\n",
    "MD5. You specify how often it should grab new pages and compare\n",
    "the new MD5 with the init MD5. If the new MD5 is not equal to the\n",
    "init MD5 the icon decal will change apperance and the number of\n",
    "pages that has changed will show. The results of which pages has\n",
    "changed will be shown in a tool tip.\n",
    "\n",
    "Once one or more pages has changed you will have to press the\n",
    "right mouse button on the decal with the number to reset it. When\n",
    "the plugin is not in an alarm state you may use the same button\n",
    "to force a check.\n",
    "\n",
    "<b>Settings\n",
    "Hours between update:\n",
    "This is how often you want the plugin to check for changes.\n"
  };


  /* create the notebook-stylee tabs */
  tabs = gtk_notebook_new();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(tabs), GTK_POS_TOP);
  gtk_box_pack_start(GTK_BOX(tab_vbox), tabs, TRUE, TRUE, 0);

  /* options tab */
  vbox_options = gkrellm_gtk_framed_notebook_page(tabs, "Options");

  update_label = g_strdup("Hours between updates");
  gkrellm_gtk_spin_button(vbox_options, &update_spin, 24, 1, 336, 1, 10,
			  0, 0, NULL, 0, FALSE, update_label);
  g_free(update_label);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(update_spin), updatetime);

  /* url tab1 */
  vbox_url1 = gkrellm_gtk_framed_notebook_page(tabs, "URL #1");
  
  for (i = 0; i < 10; i++) {
    url_entry[i] = gtk_entry_new_with_max_length(900);
    if (wi[i].use == 1) {
      url = make_url_from_config_struct(i);
      gtk_entry_set_text(GTK_ENTRY(url_entry[i]), url);
      free(url);
    }
    gtk_box_pack_start(GTK_BOX(vbox_url1), url_entry[i], FALSE, FALSE, 0);
  }

  /* url tab2 */
  vbox_url2 = gkrellm_gtk_framed_notebook_page(tabs, "URL #2");
  for (i = 10; i < 20; i++) {
    url_entry[i] = gtk_entry_new_with_max_length(900);
    if (wi[i].use == 1) {
      url = make_url_from_config_struct(i);
      gtk_entry_set_text(GTK_ENTRY(url_entry[i]), url);
      free(url);
    }
    gtk_box_pack_start(GTK_BOX(vbox_url2), url_entry[i], FALSE, FALSE, 0);
  }

  /* help tab */
  vbox_help = gkrellm_gtk_framed_notebook_page(tabs, "Help");
  text = gkrellm_gtk_scrolled_text_view(vbox_help, NULL,
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
  gkrellm_gtk_text_view_append_strings(text, help_text,
				       sizeof(help_text) / sizeof(gchar *));

  /* about tab */
  about_text = g_strdup_printf("GKWebMon %s\n"
			       "GKrellM Web Monitor Plugin\n"
			       "\n"
			       "Copyright (c) 2003  Erik Waling\n"
			       "erikw@acc.umu.se\n"
			       "\n"
			       "Released under the GNU Public License\n",
			       VERSION);

  vbox_about = gtk_label_new("About");
  text = gtk_label_new(about_text);
  gtk_notebook_append_page(GTK_NOTEBOOK(tabs), text, vbox_about);
  g_free(about_text);
}

static void load_config(gchar * str)
{
  /* this function should be changed with a malloc(strlen(str)) */
  char conf_option[20];
  int value;
  char *server = NULL;
  int port;
  char *page = NULL;
  char init_md5[33];
  int ret;
  
#ifdef DEBUG
  fprintf(stderr, "load_config()\n");
#endif

  if (sscanf(str, "%s", conf_option) != 1)
    return;

  if (!(strcmp(conf_option, "update"))) {
    if (sscanf(str, "%s %d", conf_option, &value) != 2)
      return;
    updatetime = value;
  } else if (!(strcmp(conf_option, "url"))) { /* old style url */
    ret = sscanf(str, "%s %d %as %d %as %s", conf_option, &value,
		 &server, &port, &page, init_md5);
    if ((ret == 5) || (ret == 6)) {
      if (ret == 6) { /* have initial MD5 */
	strcpy(wi[value].init_md5, init_md5);
      }
      wi[value].use = 1;	/* mark as used */
      wi[value].server = server;
      wi[value].port = port;
      wi[value].page = page;
      /* this will get init_md5 if not supplied in config file */
#ifdef DEBUG
      printElem(value);
      fprintf(stderr, "fetching md5 for server %s port %d page %s\n", 
	     wi[value].server, wi[value].port, wi[value].page);
#endif
      start_thread((void *) value);
    }
    gkrellm_config_modified(); /* to force write of new style config lines */
  } else if (!(strcmp(conf_option, "nurl"))) { /* new style url */
    char *url;
    ret = sscanf(str, "%s %d %as %s", conf_option, &value, &url, init_md5);
    parse_url_to_config_struct(value, url);
    free(url);
    if (ret == 4) {
      strcpy(wi[value].init_md5, init_md5);
    }
#ifdef DEBUG
    printElem(value);
    fprintf(stderr, "fetching md5 for server %s port %d page %s\n", 
	    wi[value].server, wi[value].port, wi[value].page);
#endif
    start_thread((void *) value);
  }
}

static void save_config(FILE * fp)
{
  int i;
  char *url;

#ifdef DEBUG
  fprintf(stderr, "save_config()\n");
#endif
  fprintf(fp, "%s update %d\n", CONFIG_KEYWORD, updatetime);

  for (i = 0; i < 20; i++) {
    if (wi[i].use == 1) {
#if 0
      fprintf(fp, "%s url %d %s %d %s %s\n", CONFIG_KEYWORD, i,
	      wi[i].server, wi[i].port, wi[i].page, wi[i].init_md5);
#endif
      url = make_url_from_config_struct(i);
      fprintf(fp, "%s nurl %d %s %s\n", CONFIG_KEYWORD, i,
	      url, wi[i].init_md5);
      free(url);
    }
  }
}

GkrellmMonitor *gkrellm_init_plugin(void)
{
  style_id = gkrellm_add_meter_style(&webmon, STYLE_NAME);
  web_monitor = &webmon;

  hours_since_update = 0;
  checkmins = -1;
  number_of_changed = 0;
  set_config_default();
  ticks = gkrellm_ticks();

  return &webmon;
}

static void get_pages_for_check(void)
{
  int i;
#ifdef DEBUG
  fprintf(stderr, "get_pages_for_check()\n");
#endif
  for (i = 0; i < 20; i++) {
    if (wi[i].use == 1) {
      if ((wi[i].init_md5[0])) {
	start_thread((void *) i);
      }
    }
  }
}

static void change_tooltip(int i)
{
  gchar *buf;
  gchar *tmp;

  if (number_of_changed == 1) {
    g_free(tooltip_text);
    if (wi[i].port == 80) {
      tooltip_text = g_strdup_printf("http://%s/%s", wi[i].server, wi[i].page);
    } else {
      tooltip_text = g_strdup_printf("http://%s:%d/%s", wi[i].server, wi[i].port,
				     wi[i].page);
	}
    gtk_tooltips_set_tip(tooltip, panel->drawing_area, tooltip_text, NULL);
  }

  if (number_of_changed > 1) {
    buf = g_strdup(tooltip_text);
    g_free(tooltip_text);
    
    if (wi[i].port == 80) {
      tmp = g_strdup_printf("\nhttp://%s%s", wi[i].server, wi[i].page);
    } else {
      tmp = g_strdup_printf("\nhttp://%s:%d%s", wi[i].server,
			    wi[i].port, wi[i].page);
    }

    tooltip_text = g_strdup_printf("%s%s", buf, tmp);
    g_free(buf);
    g_free(tmp);
    gtk_tooltips_set_tip(tooltip, panel->drawing_area, tooltip_text, NULL);
  }
  wi[i].flagged = 1; /* we have notified a change in this url */ 
}

static void default_tooltip(void)
{
  g_free(tooltip_text);
  tooltip_text = g_strdup_printf("GkWebMon %s", VERSION);
  gtk_tooltips_set_tip(tooltip, panel->drawing_area, tooltip_text, NULL);
}

static void compare_md5(int i)
{
  if (wi[i].init_md5[0] && wi[i].new_md5[0]) {
    if ((strncmp(wi[i].init_md5, wi[i].new_md5, 32))) {
      do_alarm(i);
    }
  }
}

static void do_alarm(int i)
{
#ifdef DEBUG
  fprintf(stderr, "Alarm for %d\n", i);
#endif
  if (wi[i].flagged) return; /* already done this one */
  number_of_changed++;	/* the number of pages that have changed */
  gkrellm_draw_decal_pixmap(panel, www_decal, 1);	/* change the pixmap */
  print_on_textdecal(number_of_changed);
  /* if the page has changed we want that MD5 as a future reference */
  strncpy(wi[i].init_md5, wi[i].new_md5, 32);
  gkrellm_config_modified();
  /* and we need to set the tool tip if not already notified */
  change_tooltip(i);
}
