/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.xmind.core.IFileEntry;
import org.xmind.core.IImage;
import org.xmind.core.IManifest;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.ui.internal.AttachmentImageDescriptor;
import org.xmind.ui.internal.dnd.MindMapDNDClientBase;
import org.xmind.ui.util.Logger;

public class ImageDndClient
extends MindMapDNDClientBase {
    private ImageTransfer transfer = ImageTransfer.getInstance();

    public Object getData(Transfer transfer, TransferData data) {
        if (transfer == this.transfer) {
            return this.transfer.nativeToJava(data);
        }
        return null;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public Object toTransferData(Object[] viewerElements, IViewer viewer) {
        if (viewerElements != null && viewerElements.length > 0) {
            Object[] objectArray = viewerElements;
            int n = viewerElements.length;
            int n2 = 0;
            while (n2 < n) {
                IImage image;
                String source;
                Object element = objectArray[n2];
                if (element instanceof IImage && (source = (image = (IImage)element).getSource()) != null && HyperlinkUtils.isAttachmentURL((String)source)) {
                    String path = HyperlinkUtils.toAttachmentPath((String)source);
                    ImageDescriptor imageDescriptor = AttachmentImageDescriptor.createFromEntryPath(image.getOwnedWorkbook(), path);
                    ImageData imageData = imageDescriptor.getImageData();
                    return imageData;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    protected Object[] toViewerElements(Object transferData, Request request, IWorkbook workbook, ITopic targetParent, boolean dropInParent) {
        if (transferData instanceof ImageData && workbook != null) {
            ImageData imageData = (ImageData)transferData;
            ImageLoader saver = new ImageLoader();
            saver.data = new ImageData[]{imageData};
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                saver.save((OutputStream)os, 5);
            }
            catch (Throwable throwable) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                os.close();
            }
            catch (IOException iOException) {}
            byte[] imageDataInBytes = os.toByteArray();
            IManifest manifest = workbook.getManifest();
            try {
                IFileEntry entry;
                ByteArrayInputStream is = new ByteArrayInputStream(imageDataInBytes);
                try {
                    entry = manifest.createAttachmentFromStream((InputStream)is, "temp.png", "image/png");
                }
                finally {
                    is.close();
                }
                String imageSource = HyperlinkUtils.toAttachmentURL((String)entry.getPath());
                if (targetParent != null && dropInParent) {
                    return new Object[]{this.createModifyImageCommand(targetParent, imageSource, -1, -1, null)};
                }
                ITopic topic = workbook.createTopic();
                topic.getImage().setSource(imageSource);
                return new Object[]{topic};
            }
            catch (IOException e) {
                Logger.log(e, "[ImageDndClient] Failed to create image entry.");
            }
        }
        return null;
    }
}

