/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IMemento;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.ISerializer;
import org.xmind.core.IWorkbook;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.CloneHandler;
import org.xmind.ui.internal.editor.AbstractWorkbookRef;
import org.xmind.ui.mindmap.IWorkbookRef;

public class PreLoadedWorkbookRef
extends AbstractWorkbookRef {
    private static final String TAG_NAME = "name";
    private IWorkbook sourceWorkbook;
    private String name;

    private PreLoadedWorkbookRef(IMemento state, IWorkbook workbook, String name) {
        super(null, state);
        this.sourceWorkbook = workbook;
        this.name = name;
    }

    @Override
    protected IWorkbook doLoadWorkbookFromURI(IProgressMonitor monitor, URI uri) throws InterruptedException, InvocationTargetException {
        if (this.sourceWorkbook == null) {
            throw new IllegalStateException("No source workbook to load");
        }
        try {
            IWorkbook workbook = Core.getWorkbookBuilder().createWorkbook(this.getTempStorage());
            ISerializer serializer = Core.getWorkbookBuilder().newSerializer();
            serializer.setWorkbook(workbook);
            serializer.setWorkbookStorageAsOutputTarget();
            serializer.setEntryStreamNormalizer(this.getEncryptionHandler());
            serializer.serialize(null);
            new CloneHandler().withWorkbooks(this.sourceWorkbook, workbook).copyWorkbookContents();
            return workbook;
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    @Override
    protected IWorkbook doLoadWorkbookFromTempStorage(IProgressMonitor monitor, IStorage tempStorage) throws InterruptedException, InvocationTargetException {
        IWorkbook workbook = super.doLoadWorkbookFromTempStorage(monitor, tempStorage);
        if (this.sourceWorkbook == null) {
            String sourceStoragePath = Core.getWorkspace().getTempDir("preloaded/" + UUID.randomUUID().toString());
            File sourceStorageDir = new File(sourceStoragePath);
            sourceStorageDir.mkdirs();
            try {
                this.sourceWorkbook = Core.getWorkbookBuilder().createWorkbook((IStorage)new DirectoryStorage(sourceStorageDir));
                new CloneHandler().withWorkbooks(workbook, this.sourceWorkbook).copyWorkbookContents();
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        return workbook;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        IWorkbook w = this.getWorkbook();
        return w == null ? super.hashCode() : w.hashCode();
    }

    public boolean equals(Object obj) {
        IWorkbook thatWorkbook;
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PreLoadedWorkbookRef)) {
            return false;
        }
        PreLoadedWorkbookRef that = (PreLoadedWorkbookRef)obj;
        IWorkbook thisWorkbook = this.getWorkbook();
        return thisWorkbook == (thatWorkbook = that.getWorkbook()) || thisWorkbook != null && thisWorkbook.equals(thatWorkbook);
    }

    public String toString() {
        IWorkbook w = this.getWorkbook();
        return w == null ? super.toString() : w.toString();
    }

    @Override
    protected void saveState(IMemento memento) {
        if (this.name != null) {
            memento.putString(TAG_NAME, this.name);
        }
        super.saveState(memento);
    }

    public static IWorkbookRef createFromSavedState(IMemento state) {
        Assert.isLegal((state != null ? 1 : 0) != 0);
        return new PreLoadedWorkbookRef(state, null, state.getString(TAG_NAME));
    }

    public static IWorkbookRef createFromLoadedWorkbook(IWorkbook workbook, String name) {
        Assert.isLegal((workbook != null ? 1 : 0) != 0);
        return new PreLoadedWorkbookRef(null, workbook, name);
    }
}

