/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.ITopic;
import org.xmind.gef.IDecorator;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.ui.internal.decorators.InfoItemIconDecorator;
import org.xmind.ui.internal.mindmap.InfoItemIcon;
import org.xmind.ui.internal.mindmap.InfoPart;
import org.xmind.ui.internal.mindmap.MindMapPartBase;
import org.xmind.ui.internal.mindmap.SelectionFeedbackHelper;
import org.xmind.ui.internal.mindmap.SimpleSelectionFeedback;
import org.xmind.ui.internal.svgsupport.SVGImageData;
import org.xmind.ui.internal.svgsupport.SVGImageFigure;
import org.xmind.ui.internal.svgsupport.SVGReference;
import org.xmind.ui.mindmap.IInfoItemPart;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ISelectionFeedbackHelper;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.resources.ImageReference;

public class InfoItemIconPart
extends MindMapPartBase
implements IInfoItemPart,
IPropertyChangeListener {
    private IAction action;
    private IMenuManager menu;
    private String actionId;
    private ImageReference imageRef = null;
    private SVGReference svgRef = null;
    private ResourceManager resources;

    public InfoItemIconPart() {
        this.setDecorator((IDecorator)InfoItemIconDecorator.getInstance());
    }

    protected IFigure createFigure() {
        if (this.svgRef != null) {
            SVGImageFigure figure = new SVGImageFigure();
            figure.setManager(this.resources);
            return figure;
        }
        return new SizeableImageFigure();
    }

    @Override
    public IAction getAction() {
        return this.action;
    }

    @Override
    public Image getImage() {
        if (this.imageRef != null && !this.imageRef.isDisposed()) {
            return this.imageRef.getImage();
        }
        return null;
    }

    @Override
    public SVGImageData getSVGData() {
        return this.svgRef == null ? null : this.svgRef.getSVGData();
    }

    @Override
    public IMenuManager getPopupMenu() {
        InfoPart infoPart = (InfoPart)this.getParent();
        ITopicPart topicPart = infoPart.getTopicPart();
        ITopic topic = infoPart.getTopic();
        InfoItemIcon infoItem = (InfoItemIcon)this.getModel();
        final List<IAction> actions = infoItem.getContributor().getPopupMenuActions(topicPart, topic);
        if (actions == null) {
            return null;
        }
        if (this.menu == null) {
            this.menu = new MenuManager();
            this.menu.setRemoveAllWhenShown(true);
            this.menu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    for (IAction action : actions) {
                        InfoItemIconPart.this.menu.add(action);
                    }
                }
            });
        }
        return this.menu;
    }

    @Override
    public ITopic getTopic() {
        return (ITopic)super.getRealModel();
    }

    @Override
    public IInfoPart getInforPart() {
        if (this.getParent() instanceof IInfoPart) {
            return (IInfoPart)this.getParent();
        }
        return null;
    }

    @Override
    public ITopicPart getTopicPart() {
        if (this.getInforPart() != null) {
            return this.getInforPart().getTopicPart();
        }
        return null;
    }

    public void setParent(IPart parent) {
        if (this.getParent() instanceof InfoPart) {
            ((InfoPart)this.getParent()).removeInfoItemIcon(this);
        }
        super.setParent(parent);
        if (this.getParent() instanceof InfoPart) {
            ((InfoPart)this.getParent()).addInfoItemIcon(this);
        }
    }

    public void setModel(Object model) {
        String svgFilePath;
        super.setModel(model);
        if (this.svgRef == null && model instanceof InfoItemIcon && (svgFilePath = ((InfoItemIcon)model).getContributor().getSVGFilePath(this.getTopic(), this.action)) != null && !"".equals(svgFilePath)) {
            this.svgRef = this.createSVGReference(svgFilePath);
        }
    }

    protected void register() {
        super.register();
        if (this.getModel() instanceof InfoItemIcon) {
            this.setAction(((InfoItemIcon)this.getModel()).getAction());
        }
    }

    protected void unregister() {
        this.setAction(null);
        super.unregister();
    }

    private void setAction(IAction action) {
        if (action == this.action) {
            return;
        }
        if (this.action != null) {
            this.action.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        if (this.actionId != null) {
            this.unregisterAction(this.actionId, this.action);
        }
        this.action = action;
        String string = this.actionId = action == null ? null : action.getId();
        if (this.actionId != null) {
            this.registerAction(action);
        }
        if (action != null) {
            action.addPropertyChangeListener((IPropertyChangeListener)this);
        }
        this.updateImage();
    }

    private void unregisterAction(String actionId, IAction action) {
        IInfoPart branchPart = this.getInforPart();
        if (branchPart == null) {
            return;
        }
        IActionRegistry actionRegistry = (IActionRegistry)branchPart.getAdapter(IActionRegistry.class);
        if (actionRegistry == null) {
            return;
        }
        if (actionRegistry.getAction(actionId) == action) {
            actionRegistry.removeAction(actionId);
        }
    }

    private void registerAction(IAction action) {
        IInfoPart infoPart = this.getInforPart();
        if (infoPart == null) {
            return;
        }
        IActionRegistry actionRegistry = (IActionRegistry)infoPart.getAdapter(IActionRegistry.class);
        if (actionRegistry == null) {
            return;
        }
        actionRegistry.addAction(action);
    }

    private void updateImage() {
        if (this.svgRef == null) {
            ImageDescriptor oldImageDescriptor = this.imageRef == null ? null : this.imageRef.getImageDescriptor();
            ImageDescriptor newImageDescriptor = null;
            if (this.action != null) {
                ImageDescriptor imageDescriptor = newImageDescriptor = this.action.isEnabled() ? this.action.getImageDescriptor() : this.action.getDisabledImageDescriptor();
            }
            if (!(oldImageDescriptor == newImageDescriptor || oldImageDescriptor != null && oldImageDescriptor.equals(newImageDescriptor))) {
                if (this.imageRef != null) {
                    this.imageRef.dispose();
                }
                this.imageRef = newImageDescriptor == null ? null : new ImageReference(newImageDescriptor, false);
            }
        } else {
            String filePath;
            Object model = this.getModel();
            if (model != null && model instanceof InfoItemIcon && ((filePath = ((InfoItemIcon)model).getContributor().getSVGFilePath(this.getTopic(), this.action)) == null || "".equals(filePath))) {
                this.svgRef = null;
                this.getParent().refresh();
            }
        }
    }

    @Override
    protected void onActivated() {
        this.resources = new LocalResourceManager(JFaceResources.getResources());
        super.onActivated();
    }

    @Override
    protected void onDeactivated() {
        if (this.imageRef != null) {
            this.imageRef.dispose();
            this.imageRef = null;
        }
        if (this.svgRef != null) {
            this.svgRef = null;
            this.resources.dispose();
        }
        super.onDeactivated();
    }

    @Override
    protected void updateView() {
        super.updateView();
        this.updateToolTip();
        this.updateImage();
    }

    protected IFigure createToolTip() {
        if (this.action != null) {
            String text = this.action.getText();
            String tooltip = this.action.getToolTipText();
            if (text != null || tooltip != null) {
                Figure fig = new Figure();
                fig.setBorder((Border)new MarginBorder(1, 3, 1, 3));
                ToolbarLayout layout = new ToolbarLayout(false);
                layout.setMinorAlignment(1);
                layout.setSpacing(7);
                fig.setLayoutManager((LayoutManager)layout);
                if (text != null) {
                    text = Action.removeAcceleratorText((String)text);
                    text = Action.removeMnemonics((String)text);
                    Label title = new Label(text);
                    title.setFont(FontUtils.getBold((String)"org.eclipse.jface.defaultfont"));
                    fig.add((IFigure)title);
                }
                if (tooltip != null) {
                    RotatableWrapLabel description = new RotatableWrapLabel(tooltip, 0);
                    description.setTextAlignment(1);
                    description.setPrefWidth(Math.min(Display.getCurrent().getClientArea().width / 3, 128));
                    description.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
                    description.setForegroundColor(ColorConstants.gray);
                    fig.add((IFigure)description);
                }
                return fig;
            }
        }
        return super.createToolTip();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ITopic.class)) {
            return this.getTopic();
        }
        if (adapter == Image.class) {
            return this.getImage();
        }
        if (adapter == IAction.class) {
            return this.getAction();
        }
        if (adapter == IMenuManager.class) {
            return this.getPopupMenu();
        }
        return super.getAdapter(adapter);
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("selectable role", (IEditPolicy)NullEditPolicy.getInstance());
    }

    @Override
    protected IFeedback createFeedback() {
        return new SimpleSelectionFeedback(this);
    }

    @Override
    protected ISelectionFeedbackHelper createSelectionFeedbackHelper() {
        return new SelectionFeedbackHelper();
    }

    private SVGReference createSVGReference(String svgFilePath) {
        SVGReference ref = new SVGReference(svgFilePath);
        if (this.resources == null) {
            this.resources = new LocalResourceManager(JFaceResources.getResources());
        }
        return ref;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("text".equals(property) || "toolTipText".equals(property)) {
            this.updateToolTip();
        } else if ("image".equals(property)) {
            this.updateImage();
            this.update();
        }
    }
}

